/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.actions;

import java.util.ResourceBundle;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.loaders.ExeObject;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.RunDialogPanel;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RunDialogAction
extends NodeAction {
    protected JButton runButton = null;
    private Object[] options;
    private ResourceBundle bundle;

    private void init() {
        if (this.runButton == null) {
            this.runButton = new JButton(this.getString("RunButtonText"));
            this.runButton.getAccessibleContext().setAccessibleDescription(this.getString("RunButtonAD"));
            this.options = new Object[]{this.runButton, DialogDescriptor.CANCEL_OPTION};
        }
    }

    public String getName() {
        return this.getString("RUN_COMMAND");
    }

    protected void performAction(Node[] nodeArray) {
        DataObject dataObject;
        String string = null;
        if (nodeArray != null && nodeArray.length == 1 && (dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class)) != null && dataObject instanceof ExeObject) {
            Node node = dataObject.getNodeDelegate();
            string = FileUtil.toFile((FileObject)dataObject.getPrimaryFile()).getPath();
        }
        this.perform(string);
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
        return dataObject instanceof ExeObject;
    }

    public void perform(String string) {
        if (this.runButton == null) {
            this.init();
        }
        this.perform(new RunDialogPanel(string, true, this.runButton));
    }

    protected void perform(RunDialogPanel runDialogPanel) {
        if (this.runButton == null) {
            this.init();
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)runDialogPanel, this.getString("RunDialogTitle"), true, this.options, (Object)this.runButton, 0, null, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == this.runButton) {
            Project project = runDialogPanel.getSelectedProject();
            RunProfile runProfile = ConfigurationSupport.getProjectDescriptor(project).getConfs().getActive().getProfile();
            String string = runDialogPanel.getExecutablePath();
            string = IpeUtils.toRelativePath((String)runProfile.getRunDirectory(), (String)string);
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(project, 2, IpeUtils.getBaseName((String)string) + " (run)", string, ConfigurationSupport.getProjectDescriptor(project).getConfs().getActive(), runProfile, false);
            ProjectActionSupport.fireActionPerformed(new ProjectActionEvent[]{projectActionEvent});
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RunDialogAction.class);
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(RunDialogAction.class);
        }
        return this.bundle.getString(string);
    }
}

