/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.MakeActionProvider;
import org.netbeans.modules.cnd.makeproject.MakeProjectConfigurationProvider;
import org.netbeans.modules.cnd.makeproject.MakeProjectEncodingQueryImpl;
import org.netbeans.modules.cnd.makeproject.MakeProjectOperations;
import org.netbeans.modules.cnd.makeproject.MakeProjectType;
import org.netbeans.modules.cnd.makeproject.MakeSharabilityQuery;
import org.netbeans.modules.cnd.makeproject.MakeSources;
import org.netbeans.modules.cnd.makeproject.MakeTemplateListener;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifactProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.OperationListener;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openidex.search.SearchInfo;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class MakeProject
implements Project,
AntProjectListener {
    private static final Icon MAKE_PROJECT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif"));
    private static MakeTemplateListener templateListener = null;
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private ConfigurationDescriptorProvider projectDescriptorProvider;
    private int projectType = -1;
    private MakeProject thisMP;
    private List<Runnable> openedTasks;

    MakeProject(AntProjectHelper antProjectHelper) throws IOException {
        this.helper = antProjectHelper;
        this.eval = this.createEvaluator();
        AuxiliaryConfiguration auxiliaryConfiguration = antProjectHelper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(antProjectHelper, auxiliaryConfiguration, this.eval);
        this.projectDescriptorProvider = new ConfigurationDescriptorProvider(antProjectHelper.getProjectDirectory());
        this.genFilesHelper = new GeneratedFilesHelper(antProjectHelper);
        this.lookup = this.createLookup(auxiliaryConfiguration);
        antProjectHelper.addAntProjectListener((AntProjectListener)this);
        this.thisMP = this;
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagName("make-project-type");
        if (nodeList.getLength() == 1) {
            nodeList = nodeList.item(0).getChildNodes();
            String string = nodeList.item(0).getNodeValue();
            this.projectType = new Integer(string);
        }
        if (templateListener == null) {
            templateListener = new MakeTemplateListener();
            DataLoaderPool.getDefault().addOperationListener((OperationListener)templateListener);
        }
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public String toString() {
        return "MakeProject[" + this.getProjectDirectory() + "]";
    }

    private PropertyEvaluator createEvaluator() {
        return this.helper.getStandardPropertyEvaluator();
    }

    PropertyEvaluator evaluator() {
        return this.eval;
    }

    ReferenceHelper getReferenceHelper() {
        return this.refHelper;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private Lookup createLookup(AuxiliaryConfiguration auxiliaryConfiguration) {
        MakeSubprojectProvider makeSubprojectProvider = new MakeSubprojectProvider();
        return Lookups.fixed((Object[])new Object[]{new Info(), auxiliaryConfiguration, this.helper.createCacheDirectoryProvider(), makeSubprojectProvider, new MakeActionProvider(this), new MakeLogicalViewProvider(this, makeSubprojectProvider), new MakeCustomizerProvider(this, this.projectDescriptorProvider), new MakeArtifactProviderImpl(), new ProjectXmlSavedHookImpl(), new ProjectOpenedHookImpl(), new MakeSharabilityQuery(FileUtil.toFile((FileObject)this.getProjectDirectory())), new MakeSources(this, this.helper), new AntProjectHelperProvider(), this.projectDescriptorProvider, new MakeProjectConfigurationProvider(this, this.projectDescriptorProvider), new NativeProjectProvider(this, this.projectDescriptorProvider), new RecommendedTemplatesImpl(), new MakeProjectOperations(this), new FolderSearchInfo(this.projectDescriptorProvider), new MakeProjectType(), new MakeProjectEncodingQueryImpl(this.projectDescriptorProvider)});
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        if (antProjectEvent.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element element = MakeProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/make-project/1", "name");
                if (nodeList.getLength() == 1 && (nodeList = nodeList.item(0).getChildNodes()).getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                    return ((Text)nodeList.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    public void setName(final String string) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                Element element;
                Element element2 = MakeProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/make-project/1", "name");
                if (nodeList.getLength() == 1) {
                    element = (Element)nodeList.item(0);
                    NodeList nodeList2 = element.getChildNodes();
                    while (nodeList2.getLength() > 0) {
                        element.removeChild(nodeList2.item(0));
                    }
                } else {
                    element = element2.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/make-project/1", "name");
                    element2.insertBefore(element, element2.getChildNodes().item(0));
                }
                element.appendChild(element2.getOwnerDocument().createTextNode(string));
                MakeProject.this.helper.putPrimaryConfigurationData(element2, true);
                return null;
            }
        });
    }

    public void addOpenedTask(Runnable runnable) {
        if (this.openedTasks == null) {
            this.openedTasks = new ArrayList<Runnable>();
        }
        this.openedTasks.add(runnable);
    }

    class FolderSearchInfo
    implements SearchInfo {
        private ConfigurationDescriptorProvider projectDescriptorProvider;

        FolderSearchInfo(ConfigurationDescriptorProvider configurationDescriptorProvider) {
            this.projectDescriptorProvider = configurationDescriptorProvider;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator objectsToSearch() {
            MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)this.projectDescriptorProvider.getConfigurationDescriptor();
            Folder folder = makeConfigurationDescriptor.getLogicalFolders();
            return folder.getAllItemsAsDataObjectSet(false, "text/").iterator();
        }
    }

    private final class MakeArtifactProviderImpl
    implements MakeArtifactProvider {
        private MakeArtifactProviderImpl() {
        }

        public MakeArtifact[] getBuildArtifacts() {
            ArrayList<MakeArtifact> arrayList = new ArrayList<MakeArtifact>();
            MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor();
            Configuration[] configurationArray = makeConfigurationDescriptor.getConfs().getConfs();
            String string = null;
            boolean bl = false;
            Object var6_6 = null;
            boolean bl2 = false;
            Object var8_8 = null;
            Object var9_9 = null;
            Object var10_10 = null;
            Object var11_11 = null;
            string = FileUtil.toFile((FileObject)MakeProject.this.helper.getProjectDirectory()).getPath();
            for (int i = 0; i < configurationArray.length; ++i) {
                MakeConfiguration makeConfiguration = (MakeConfiguration)configurationArray[i];
                arrayList.add(new MakeArtifact(makeConfigurationDescriptor, makeConfiguration));
            }
            return arrayList.toArray(new MakeArtifact[arrayList.size()]);
        }
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            if (MakeProject.this.openedTasks != null) {
                for (Runnable runnable : MakeProject.this.openedTasks) {
                    runnable.run();
                }
                MakeProject.this.openedTasks.clear();
                MakeProject.this.openedTasks = null;
            }
        }

        protected void projectClosed() {
            if (MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor() != null) {
                MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor().save(NbBundle.getMessage(MakeProject.class, (String)"ProjectNotSaved"));
                MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor().closed();
            }
        }
    }

    private final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        ProjectXmlSavedHookImpl() {
        }

        protected void projectXmlSaved() throws IOException {
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        void firePropertyChange(String string) {
            this.pcs.firePropertyChange(string, null, null);
        }

        public String getName() {
            String string = PropertyUtils.getUsablePropertyName((String)MakeProject.this.getName());
            return string;
        }

        public String getDisplayName() {
            String string = MakeProject.this.getName();
            return string;
        }

        public Icon getIcon() {
            Icon icon = null;
            icon = MakeConfigurationDescriptor.MAKEFILE_ICON;
            return icon;
        }

        public Project getProject() {
            return MakeProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private class MakeSubprojectProvider
    implements SubprojectProvider {
        private MakeSubprojectProvider() {
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public Set getSubprojects() {
            String string;
            Object object;
            Object object2;
            HashSet<String> hashSet = new HashSet<String>();
            Set<Object> set = new HashSet();
            Element element = MakeProject.this.helper.getPrimaryConfigurationData(true);
            if (!MakeProject.this.projectDescriptorProvider.gotDescriptor() && element.getElementsByTagName("make-dep-projects").getLength() > 0) {
                object2 = element.getElementsByTagName("make-dep-project");
                if (object2.getLength() > 0) {
                    for (int i = 0; i < object2.getLength(); ++i) {
                        Object object3 = object2.item(i);
                        object = object3.getChildNodes();
                        for (int j = 0; j < object.getLength(); ++j) {
                            string = object.item(j).getNodeValue();
                            set.add(string);
                        }
                    }
                }
            } else {
                object2 = MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor();
                if (object2 == null) {
                    return hashSet;
                }
                set = ((MakeConfigurationDescriptor)object2).getSubprojectLocations();
            }
            object2 = FileUtil.toFile((FileObject)MakeProject.this.getProjectDirectory()).getPath();
            for (Object object3 : set) {
                object = IpeUtils.toAbsolutePath((String)object2, (String)object3);
                object = FilePathAdaptor.mapToLocal((String)object);
                try {
                    FileObject fileObject = FileUtil.toFileObject((File)new File((String)object).getCanonicalFile());
                    string = ProjectManager.getDefault().findProject(fileObject);
                    if (string == null) continue;
                    hashSet.add(string);
                }
                catch (Exception exception) {
                    System.err.println("Cannot find subproject in '" + (String)object + "' " + exception);
                }
            }
            return hashSet;
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] RECOMMENDED_TYPES = new String[]{"c-types", "cpp-types", "shell-types", "makefile-types", "c-types", "simple-files", "asm-types"};
        private static final String[] RECOMMENDED_TYPES_FORTRAN = new String[]{"c-types", "cpp-types", "shell-types", "makefile-types", "c-types", "simple-files", "fortran-types", "asm-types"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/cFiles/main.c", "Templates/cFiles/file.c", "Templates/cFiles/file.h", "Templates/cppFiles/main.cc", "Templates/cppFiles/file.cc", "Templates/cppFiles/file.h", "Templates/MakeTemplates/ComplexMakefile", "Templates/MakeTemplates/SimpleMakefile/ExecutableMakefile", "Templates/MakeTemplates/SimpleMakefile/SharedLibMakefile", "Templates/MakeTemplates/SimpleMakefile/StaticLibMakefile"};
        private static final String[] PRIVILEGED_NAMES_FORTRAN = new String[]{"Templates/cFiles/main.c", "Templates/cFiles/file.c", "Templates/cFiles/file.h", "Templates/cppFiles/main.cc", "Templates/cppFiles/file.cc", "Templates/cppFiles/file.h", "Templates/fortranFiles/fortranFreeFormatFile.f90", "Templates/MakeTemplates/ComplexMakefile", "Templates/MakeTemplates/SimpleMakefile/ExecutableMakefile", "Templates/MakeTemplates/SimpleMakefile/SharedLibMakefile", "Templates/MakeTemplates/SimpleMakefile/StaticLibMakefile"};

        private RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            if (CppSettings.getDefault().isFortranEnabled()) {
                return RECOMMENDED_TYPES_FORTRAN;
            }
            return RECOMMENDED_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            if (CppSettings.getDefault().isFortranEnabled()) {
                return PRIVILEGED_NAMES_FORTRAN;
            }
            return PRIVILEGED_NAMES;
        }
    }

    final class AntProjectHelperProvider {
        AntProjectHelperProvider() {
        }

        AntProjectHelper getAntProjectHelper() {
            return MakeProject.this.helper;
        }
    }
}

