/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.codegen.ui.customizer;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.netbeans.modules.uml.codegen.dataaccess.xmlbeans.DomainObject;
import org.netbeans.modules.uml.codegen.dataaccess.xmlbeans.Family;
import org.netbeans.modules.uml.codegen.dataaccess.xmlbeans.TemplateFamiliesHandler;
import org.netbeans.modules.uml.codegen.ui.customizer.TabbedPanelModel;
import org.netbeans.modules.uml.codegen.ui.customizer.TemplateEntry;
import org.netbeans.modules.uml.project.ui.customizer.UMLProjectProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateModel
extends TabbedPanelModel {
    private TemplateFamiliesHandler handler = TemplateFamiliesHandler.getInstance(true);
    private UMLProjectProperties umlProjectProperties = null;
    private List<String> checkedTree = null;
    public static final String PROP_TEMPLATE_STATE_CHANGE = "TEMPLATE_STATE_CHANGE";
    public static final String PROP_NO_TEMPLATES_ENABLED = "NO_TEMPLATES_ENABLED";
    public static final String PROP_ONE_TEMPLATE_ENABLED = "ONE_TEMPLATE_ENABLED";
    private PropertyChangeSupport propertyChangeSupport = null;

    public TemplateModel(UMLProjectProperties uMLProjectProperties) {
        this.setUMLProjectProperties(uMLProjectProperties);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public List<String> getCategories() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Family[] familyArray = this.handler.getTemplateFamilies().getFamily();
        for (int i = 0; i < familyArray.length; ++i) {
            arrayList.add(familyArray[i].getName());
        }
        return arrayList;
    }

    @Override
    public String getToolTip(String string) {
        return "";
    }

    @Override
    public JComponent getPanel(String string) {
        DomainObject[] domainObjectArray = null;
        String string2 = null;
        Family[] familyArray = this.handler.getTemplateFamilies().getFamily();
        for (int i = 0; i < familyArray.length; ++i) {
            if (!familyArray[i].getName().equals(string)) continue;
            domainObjectArray = familyArray[i].getDomainObject();
            string2 = familyArray[i].getName();
            break;
        }
        Box box = Box.createVerticalBox();
        for (DomainObject domainObject : domainObjectArray) {
            TemplateEntry templateEntry = new TemplateEntry(string2, domainObject, this.fetchCheckedValue(string2, domainObject.getName()));
            this.addTemplateEntryCheckEventListener(templateEntry);
            box.add(templateEntry);
        }
        return box;
    }

    private boolean fetchCheckedValue(String string, String string2) {
        return this.checkedTree.indexOf(string + ':' + string2) != -1;
    }

    private void updateCheckedValue(String string, String string2, boolean bl) {
        if (this.checkedTree.indexOf(string + ':' + string2) == -1 && bl) {
            this.checkedTree.add(string + ':' + string2);
        } else if (this.checkedTree.indexOf(string + ':' + string2) != -1 && !bl) {
            this.checkedTree.remove(string + ':' + string2);
        }
    }

    public void setUMLProjectProperties(UMLProjectProperties uMLProjectProperties) {
        this.umlProjectProperties = uMLProjectProperties;
        this.checkedTree = this.umlProjectProperties.getCodeGenTemplatesArray();
    }

    public UMLProjectProperties getUMLProjectProperties() {
        this.umlProjectProperties.setCodeGenTemplates(this.checkedTree);
        return this.umlProjectProperties;
    }

    private void addTemplateEntryCheckEventListener(TemplateEntry templateEntry) {
        templateEntry.getTemplateNameField().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                TemplateModel.this.updateCheckedValue(jCheckBox.getClientProperty("familyName").toString(), jCheckBox.getText(), jCheckBox.isSelected());
                TemplateModel.this.getPropertyChangeSupport().firePropertyChange(TemplateModel.PROP_TEMPLATE_STATE_CHANGE, null, itemEvent);
                if (jCheckBox.isSelected() && TemplateModel.this.checkedTree.size() == 1) {
                    TemplateModel.this.getPropertyChangeSupport().firePropertyChange(TemplateModel.PROP_ONE_TEMPLATE_ENABLED, null, itemEvent);
                } else if (!jCheckBox.isSelected() && TemplateModel.this.checkedTree.size() == 0) {
                    TemplateModel.this.getPropertyChangeSupport().firePropertyChange(TemplateModel.PROP_NO_TEMPLATES_ENABLED, null, itemEvent);
                }
            }
        });
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }
}

