/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.codegen.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.uml.codegen.dataaccess.xmlbeans.DomainObject;
import org.openide.util.NbBundle;

public class TemplateEntry
extends JPanel {
    private DomainObject domainObject = null;
    private DescriptionTextArea templateDescription = new DescriptionTextArea();
    private JPanel descContainer;
    private JLabel elementTypeLabel;
    private JLabel elementTypeValue;
    private JLabel stereotypeLabel;
    private JLabel stereotypeValue;
    private JCheckBox templateNameCheckBox;

    public TemplateEntry(String string, DomainObject domainObject, boolean bl) {
        this.initComponents();
        this.setLabelFont();
        this.descContainer.add((Component)this.templateDescription, "Center");
        this.domainObject = domainObject;
        this.setTemplateName(this.domainObject.getName());
        this.setTemplateDescription(this.domainObject.getDescription());
        this.setModelElement(this.domainObject.getModelElement());
        this.setStereroType(this.domainObject.getStereotype());
        this.templateNameCheckBox.setSelected(bl);
        this.templateNameCheckBox.putClientProperty("familyName", string);
    }

    private void setLabelFont() {
        String string = this.getFont().getFamily();
        int n = this.getFont().getSize() - 1;
        this.templateDescription.setFont(new Font(string, 2, n));
        this.elementTypeLabel.setFont(new Font(string, 2, n));
        this.elementTypeValue.setFont(new Font(string, 2, n));
        this.stereotypeLabel.setFont(new Font(string, 2, n));
        this.stereotypeValue.setFont(new Font(string, 2, n));
    }

    public void setTemplateName(String string) {
        this.templateNameCheckBox.setText(string);
    }

    public void setTemplateDescription(String string) {
        this.templateDescription.setText(string);
        Dimension dimension = this.templateDescription.getPreferredSize();
        this.templateDescription.setSize(dimension);
    }

    public void setStereroType(String string) {
        if (string == null || string.length() == 0) {
            string = NbBundle.getMessage(TemplateEntry.class, (String)"LBL_NA");
        }
        this.stereotypeValue.setText(string);
    }

    public void setModelElement(String string) {
        this.elementTypeValue.setText(string);
    }

    public JCheckBox getTemplateNameField() {
        return this.templateNameCheckBox;
    }

    private void initComponents() {
        this.templateNameCheckBox = new JCheckBox();
        this.elementTypeLabel = new JLabel();
        this.elementTypeValue = new JLabel();
        this.stereotypeLabel = new JLabel();
        this.stereotypeValue = new JLabel();
        this.descContainer = new JPanel();
        this.setOpaque(false);
        this.templateNameCheckBox.setText("<domainName>");
        this.templateNameCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.templateNameCheckBox.setOpaque(false);
        this.elementTypeLabel.setText(NbBundle.getMessage(TemplateEntry.class, (String)"LBL_ElementType"));
        this.elementTypeValue.setText("<elementType>");
        this.stereotypeLabel.setText(NbBundle.getMessage(TemplateEntry.class, (String)"LBL_Stereotype"));
        this.stereotypeValue.setText(NbBundle.getMessage(TemplateEntry.class, (String)"LBL_NA"));
        this.descContainer.setBackground(new Color(255, 255, 0));
        this.descContainer.setOpaque(false);
        this.descContainer.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.templateNameCheckBox, -1, 373, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(39, 39, 39).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.descContainer, -1, 342, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.elementTypeLabel).addPreferredGap(0).add((Component)this.elementTypeValue, -1, -1, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.stereotypeLabel, -2, 53, -2).addPreferredGap(0).add((Component)this.stereotypeValue, -1, 112, Short.MAX_VALUE))))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.templateNameCheckBox).addPreferredGap(0).add((Component)this.descContainer, -2, -1, -2).add(4, 4, 4).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.elementTypeLabel).add((Component)this.elementTypeValue).add((Component)this.stereotypeLabel, -2, 12, -2).add((Component)this.stereotypeValue)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public class DescriptionTextArea
    extends JTextArea {
        public DescriptionTextArea() {
            this.setOpaque(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            int n5 = this.getRows();
            int n6 = this.getRowHeight();
            if (n4 == n5 * n6) {
                this.setBounds(n, n2, n3, n5 * n6);
            }
        }

        public void setBounds(Rectangle rectangle) {
            super.setBounds(rectangle);
            int n = this.getRows();
            int n2 = this.getRowHeight();
            if (rectangle.height == n * n2) {
                this.setBounds(rectangle.x, rectangle.y, rectangle.width, n * n2);
            }
        }
    }
}

