/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.codegen.action.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.uml.codegen.CodeGenUtil;
import org.netbeans.modules.uml.codegen.action.GenerateCodeAction;
import org.netbeans.modules.uml.codegen.ui.customizer.TabbedPanel;
import org.netbeans.modules.uml.codegen.ui.customizer.TemplateModel;
import org.netbeans.modules.uml.codegen.ui.customizer.VerticalTabbedPanel;
import org.netbeans.modules.uml.project.UMLProject;
import org.netbeans.modules.uml.project.ui.customizer.UMLProjectProperties;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class GenerateCodePanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
DocumentListener {
    public static final String PROP_TARGET_PROJECT = "TARGET_PROJECT";
    public static final String PROP_NO_TARGET_PROJECT = "NO_TARGET_PROJECT";
    public static final String PROP_SOURCE_FOLDER = "SOURCE_FOLDER";
    public static final String PROP_NO_SOURCE_FOLDER = "NO_SOURCE_FOLDER";
    private VerticalTabbedPanel templateFamilies = null;
    private TemplateModel model = null;
    private UMLProject umlProject = null;
    private Project targetPrj = null;
    private Project origPrj = null;
    private SourceGroup srcGroup = null;
    private boolean noTargetProject = false;
    private boolean noOpenTargets = false;
    private boolean noTemplatesEnabled = false;
    private JCheckBox addMarkersCheck;
    private JCheckBox backupSourcesCheck;
    private JCheckBox generateMarkersCheck;
    private JPanel panelPlaceHolder;
    private JScrollPane scrollPlaceHolder;
    private JCheckBox showDialogCheckBox;
    private JLabel srcFolder;
    private JComboBox srcFolderCombo;
    private JLabel statusLabel;
    private ButtonGroup targetGroup;
    private JLabel targetProject;
    private JComboBox targetProjectCombo;
    private JLabel templatesLabel;
    private PropertyChangeSupport propertyChangeSupport = null;

    public GenerateCodePanel(boolean bl, UMLProjectProperties uMLProjectProperties, UMLProject uMLProject) {
        this.initComponents();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.umlProject = uMLProject;
        this.statusLabel.setText("");
        this.configureTargetProject(uMLProjectProperties);
        this.populateExistingProjectElementGroup();
        this.backupSourcesCheck.setSelected(uMLProjectProperties.isCodeGenBackupSources());
        this.generateMarkersCheck.setSelected(uMLProjectProperties.isCodeGenUseMarkers());
        this.addMarkersCheck.setSelected(uMLProjectProperties.isCodeGenAddMarkers());
        this.addMarkersCheck.setEnabled(uMLProjectProperties.isCodeGenUseMarkers());
        this.showDialogCheckBox.setSelected(uMLProjectProperties.isCodeGenShowDialog());
        this.scrollPlaceHolder.setVisible(true);
        this.templatesLabel.setVisible(true);
        uMLProjectProperties.setCodeGenTemplates(CodeGenUtil.cleanProjectTemplatesList((ArrayList)uMLProjectProperties.getCodeGenTemplatesArray()));
        uMLProjectProperties.save();
        this.model = new TemplateModel(uMLProjectProperties);
        this.model.getPropertyChangeSupport().addPropertyChangeListener(this);
        this.getPropertyChangeSupport().addPropertyChangeListener(this);
        this.templateFamilies = new VerticalTabbedPanel(this.model, TabbedPanel.EXPAND_ALL);
        this.panelPlaceHolder.add((Component)this.templateFamilies, "Center");
        boolean bl2 = this.noTemplatesEnabled = !CodeGenUtil.areTemplatesEnabled(uMLProjectProperties.getCodeGenTemplatesArray());
        if (bl) {
            if (!this.noTemplatesEnabled) {
                this.setSize(this.getWidth(), this.getHeight() - 200);
                this.scrollPlaceHolder.setVisible(false);
                this.templatesLabel.setVisible(false);
            } else {
                this.statusLabel.setText(NbBundle.getMessage(GenerateCodePanel.class, (String)"MSG_AtLeastOneTemplate"));
            }
        }
        this.statusLabel.setVisible(true);
    }

    public void requestFocus() {
        this.propertyChange(null);
    }

    private void configureTargetProject(UMLProjectProperties uMLProjectProperties) {
        String string = uMLProjectProperties.getCodeGenFolderLocation();
        if (string != null && string.length() > 0) {
            FileObject fileObject = FileUtil.toFileObject((File)new File(string));
            if (fileObject == null || !fileObject.isValid()) {
                string = this.retrieveFolderLocationDefault(uMLProjectProperties);
            }
        } else {
            string = this.retrieveFolderLocationDefault(uMLProjectProperties);
        }
        if (string != null && string.length() > 0) {
            this.setTargetElementsFromFolder(string);
            this.targetPrj = this.origPrj;
        } else {
            this.noTargetProject = true;
        }
        if (this.noTargetProject) {
            this.statusLabel.setText(NbBundle.getMessage(GenerateCodePanel.class, (String)"MSG_NoTargetJavaProject"));
        }
    }

    private void initComponents() {
        this.targetGroup = new ButtonGroup();
        this.backupSourcesCheck = new JCheckBox();
        this.generateMarkersCheck = new JCheckBox();
        this.addMarkersCheck = new JCheckBox();
        this.showDialogCheckBox = new JCheckBox();
        this.templatesLabel = new JLabel();
        this.scrollPlaceHolder = new JScrollPane();
        this.panelPlaceHolder = new JPanel();
        this.statusLabel = new JLabel();
        this.targetProjectCombo = new JComboBox();
        this.srcFolderCombo = new JComboBox();
        this.targetProject = new JLabel();
        this.srcFolder = new JLabel();
        this.backupSourcesCheck.setSelected(true);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/uml/codegen/action/ui/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.backupSourcesCheck, (String)resourceBundle.getString("LBL_BackupSourcesCheckBox"));
        this.backupSourcesCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.backupSourcesCheck.setMargin(new Insets(0, 0, 0, 0));
        this.generateMarkersCheck.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.generateMarkersCheck, (String)resourceBundle.getString("LBL_GenerateMarkersCheckBox"));
        this.generateMarkersCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.generateMarkersCheck.setMargin(new Insets(0, 0, 0, 0));
        this.generateMarkersCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenerateCodePanel.this.generateMarkersActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addMarkersCheck, (String)NbBundle.getMessage(GenerateCodePanel.class, (String)"LBL_AddMergeMarkers"));
        this.addMarkersCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.addMarkersCheck.setMargin(new Insets(0, 0, 0, 0));
        this.showDialogCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.showDialogCheckBox, (String)NbBundle.getMessage(GenerateCodePanel.class, (String)"LBL_GenCodeShowDialog"));
        this.showDialogCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showDialogCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.templatesLabel.setLabelFor(this.panelPlaceHolder);
        Mnemonics.setLocalizedText((JLabel)this.templatesLabel, (String)NbBundle.getMessage(GenerateCodePanel.class, (String)"LBL_TemplatesLabel"));
        this.panelPlaceHolder.setLayout(new BorderLayout());
        this.scrollPlaceHolder.setViewportView(this.panelPlaceHolder);
        this.panelPlaceHolder.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GenerateCodePanel.class, (String)"ACSN_TemplatesPanel"));
        this.panelPlaceHolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GenerateCodePanel.class, (String)"ACSD_TemplatesPanel"));
        this.statusLabel.setForeground(new Color(255, 0, 0));
        this.statusLabel.setText("<status message>");
        this.targetProjectCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                GenerateCodePanel.this.targetProjectComboItemStateChanged(itemEvent);
            }
        });
        this.srcFolderCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                GenerateCodePanel.this.srcFolderComboItemStateChanged(itemEvent);
            }
        });
        this.targetProject.setLabelFor(this.targetProjectCombo);
        Mnemonics.setLocalizedText((JLabel)this.targetProject, (String)NbBundle.getMessage(GenerateCodePanel.class, (String)"LBL_TargetProject"));
        this.srcFolder.setLabelFor(this.srcFolderCombo);
        Mnemonics.setLocalizedText((JLabel)this.srcFolder, (String)NbBundle.getMessage(GenerateCodePanel.class, (String)"LBL_SourceFolder"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.scrollPlaceHolder, -1, 385, Short.MAX_VALUE).add((Component)this.templatesLabel, -1, 385, Short.MAX_VALUE).add(2, (Component)this.statusLabel, -1, 385, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.showDialogCheckBox, -1, 302, Short.MAX_VALUE).add(1, (Component)this.addMarkersCheck, -1, 302, Short.MAX_VALUE).add(1, (Component)this.generateMarkersCheck, -1, 302, Short.MAX_VALUE).add(1, (Component)this.backupSourcesCheck, -1, 302, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add(1, (Component)this.srcFolder, -1, -1, Short.MAX_VALUE).add(1, (Component)this.targetProject, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.srcFolderCombo, 0, 219, Short.MAX_VALUE).add((Component)this.targetProjectCombo, 0, 219, Short.MAX_VALUE)))).add(83, 83, 83))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.targetProject).add((Component)this.targetProjectCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.srcFolder).add((Component)this.srcFolderCombo, -2, -1, -2)).add(7, 7, 7).add((Component)this.backupSourcesCheck).addPreferredGap(0).add((Component)this.generateMarkersCheck).addPreferredGap(0).add((Component)this.addMarkersCheck).addPreferredGap(0).add((Component)this.showDialogCheckBox).addPreferredGap(0).add((Component)this.templatesLabel).addPreferredGap(0).add((Component)this.scrollPlaceHolder, -2, 226, -2).addPreferredGap(0).add((Component)this.statusLabel).addContainerGap(24, Short.MAX_VALUE)));
        this.backupSourcesCheck.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GenerateCodePanel.class, (String)"ACSN_BackupFiles"));
        this.backupSourcesCheck.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_BackupSourcesCheckBox"));
        this.generateMarkersCheck.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GenerateCodePanel.class, (String)"ACSN_GenMarkersMerge"));
        this.generateMarkersCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GenerateCodePanel.class, (String)"ACSD_GenMakersMerge"));
        this.addMarkersCheck.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GenerateCodePanel.class, (String)"ASCN_AddMergeMarkers"));
        this.addMarkersCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GenerateCodePanel.class, (String)"ACSD_AddMergeMarkers"));
        this.showDialogCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GenerateCodePanel.class, (String)"ACSN_PromptDialog"));
        this.showDialogCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GenerateCodePanel.class, (String)"ACSD_PromptDialog"));
        this.statusLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GenerateCodePanel.class, (String)"ACSN_StatusMessage"));
        this.statusLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GenerateCodePanel.class, (String)"ACSD_StatusMessage"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GenerateCodePanel.class, (String)"ACSN_GenCodeDialog"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GenerateCodePanel.class, (String)"ASCD_ExportCodePanel"));
    }

    private void generateMarkersActionPerformed(ActionEvent actionEvent) {
        if (this.addMarkersCheck != null) {
            if (!this.generateMarkersCheck.isSelected()) {
                this.addMarkersCheck.setSelected(false);
            }
            this.addMarkersCheck.setEnabled(this.generateMarkersCheck.isSelected());
        }
    }

    private void targetProjectComboItemStateChanged(ItemEvent itemEvent) {
        this.targetPrj = (Project)this.targetProjectCombo.getSelectedItem();
        this.populateSourceFolderCombo(this.targetPrj);
        String string = this.targetPrj == null ? PROP_NO_TARGET_PROJECT : PROP_TARGET_PROJECT;
        this.getPropertyChangeSupport().firePropertyChange(string, null, itemEvent);
    }

    private void srcFolderComboItemStateChanged(ItemEvent itemEvent) {
        this.srcGroup = (SourceGroup)this.srcFolderCombo.getSelectedItem();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK")) {
            this.storeProjectProperties();
        } else if (actionEvent.getActionCommand().equals("TEMPLATES")) {
            JButton jButton = (JButton)actionEvent.getSource();
            Container container = this.getTopLevelAncestor();
            this.scrollPlaceHolder.setVisible(!this.scrollPlaceHolder.isVisible());
            this.templatesLabel.setVisible(this.scrollPlaceHolder.isVisible());
            if (this.scrollPlaceHolder.isVisible()) {
                jButton.setText(NbBundle.getMessage(GenerateCodeAction.class, (String)"LBL_TemplatesHideButton"));
                Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(GenerateCodeAction.class, (String)"LBL_TemplatesHideButton"));
                this.setSize(this.getWidth(), this.getHeight() + 200);
                container.setSize(container.getWidth(), container.getHeight() + 250);
            } else {
                jButton.setText(NbBundle.getMessage(GenerateCodeAction.class, (String)"LBL_TemplatesShowButton"));
                Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(GenerateCodeAction.class, (String)"LBL_TemplatesShowButton"));
                this.setSize(this.getWidth(), this.getHeight() - 200);
                container.setSize(container.getWidth(), container.getHeight() - 250);
            }
            container.doLayout();
        }
    }

    public void storeProjectProperties() {
        UMLProjectProperties uMLProjectProperties = this.model.getUMLProjectProperties();
        uMLProjectProperties.setCodeGenFolderLocation(this.getSelectedFolderName());
        uMLProjectProperties.setCodeGenBackupSources(this.isBackupSources());
        uMLProjectProperties.setCodeGenUseMarkers(this.isGenerateMarkers());
        uMLProjectProperties.setCodeGenShowDialog(this.isShowDialog());
        uMLProjectProperties.setCodeGenAddMarkers(this.isAddMarkers());
        uMLProjectProperties.save();
    }

    public String getSelectedFolderName() {
        try {
            if (this.srcGroup != null && this.srcGroup.getRootFolder() != null) {
                return FileUtil.toFile((FileObject)this.srcGroup.getRootFolder()).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean isBackupSources() {
        return this.backupSourcesCheck != null ? this.backupSourcesCheck.isSelected() : true;
    }

    public boolean isGenerateMarkers() {
        return this.generateMarkersCheck != null ? this.generateMarkersCheck.isSelected() : true;
    }

    public boolean isAddMarkers() {
        return this.addMarkersCheck != null ? this.addMarkersCheck.isSelected() : false;
    }

    public boolean isShowDialog() {
        return this.showDialogCheckBox != null ? this.showDialogCheckBox.isSelected() : true;
    }

    private String retrieveFolderLocationDefault(UMLProjectProperties uMLProjectProperties) {
        File file = uMLProjectProperties.getJavaSourceRootFolder();
        if (file != null) {
            return file.getPath();
        }
        return uMLProjectProperties.getCodeGenFolderLocation();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = "";
        if (propertyChangeEvent != null) {
            string = propertyChangeEvent.getPropertyName();
        }
        if (string.equals("NO_TEMPLATES_ENABLED")) {
            this.noTemplatesEnabled = true;
        } else if (string.equals("ONE_TEMPLATE_ENABLED")) {
            this.noTemplatesEnabled = false;
        } else if (string.equals(PROP_TARGET_PROJECT)) {
            this.noTargetProject = false;
        } else if (string.equals(PROP_NO_TARGET_PROJECT)) {
            this.noTargetProject = true;
        }
        String string2 = "";
        if (this.noOpenTargets) {
            string2 = NbBundle.getMessage(GenerateCodePanel.class, (String)"MSG_NoOpenTargets");
        } else if (this.noTargetProject) {
            string2 = NbBundle.getMessage(GenerateCodePanel.class, (String)"MSG_NoTargetJavaProject");
        } else if (this.noTemplatesEnabled) {
            string2 = NbBundle.getMessage(GenerateCodePanel.class, (String)"MSG_AtLeastOneTemplate");
        }
        this.statusLabel.setText(string2);
        this.statusLabel.setVisible(this.noTargetProject || this.noOpenTargets || this.noTemplatesEnabled);
        this.firePropertyChange("valid", null, (Object)(!this.noTargetProject && !this.noOpenTargets && !this.noTemplatesEnabled ? 1 : 0));
    }

    private void enableExistingProjectElementGroup(boolean bl) {
        this.targetProjectCombo.setEnabled(bl);
        this.srcFolderCombo.setEnabled(bl);
    }

    private void populateExistingProjectElementGroup() {
        ProjectCellRenderer projectCellRenderer = new ProjectCellRenderer();
        this.targetProjectCombo.setRenderer(projectCellRenderer);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        ArrayList<Project> arrayList = new ArrayList<Project>();
        if (projectArray != null) {
            for (Project project : projectArray) {
                SourceGroup[] sourceGroupArray;
                Sources sources = ProjectUtils.getSources((Project)project);
                if (sources == null || (sourceGroupArray = sources.getSourceGroups("java")) == null || sourceGroupArray.length <= 0) continue;
                arrayList.add(project);
            }
        }
        if (this.origPrj != null && !arrayList.contains(this.origPrj)) {
            arrayList.add(this.origPrj);
        }
        if (arrayList == null || arrayList.size() == 0) {
            this.noOpenTargets = true;
            this.enableExistingProjectElementGroup(false);
        } else {
            arrayList.add(0, null);
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
            this.targetProjectCombo.setModel(defaultComboBoxModel);
            this.selectTargetProject();
            this.noOpenTargets = false;
        }
        this.propertyChange(null);
    }

    private void selectTargetProject() {
        if (this.targetPrj == null) {
            this.targetProjectCombo.setSelectedIndex(0);
            if (this.targetProjectCombo.getSelectedItem() != null) {
                this.targetPrj = (Project)this.targetProjectCombo.getSelectedItem();
                this.srcFolderCombo.setEnabled(true);
            } else {
                this.srcFolderCombo.setEnabled(false);
            }
        } else {
            this.targetProjectCombo.setSelectedItem(this.targetPrj);
            this.srcFolderCombo.setEnabled(true);
        }
        if (this.targetProjectCombo.getSelectedItem() != null) {
            Project project = (Project)this.targetProjectCombo.getSelectedItem();
            this.populateSourceFolderCombo(project);
            this.srcFolderCombo.setEnabled(true);
        }
    }

    private void populateSourceFolderCombo(Project project) {
        SourceGroup[] sourceGroupArray;
        Object object;
        SourceRootCellRenderer sourceRootCellRenderer = new SourceRootCellRenderer();
        this.srcFolderCombo.setRenderer(sourceRootCellRenderer);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        int n = 0;
        FileObject fileObject = null;
        if (this.srcGroup != null) {
            fileObject = this.srcGroup.getRootFolder();
        }
        if (project != null && (object = ProjectUtils.getSources((Project)project)) != null && (sourceGroupArray = object.getSourceGroups("java")) != null) {
            for (SourceGroup sourceGroup : sourceGroupArray) {
                if (sourceGroup == null) continue;
                arrayList.add(sourceGroup);
                if (sourceGroup.getRootFolder() == null || !sourceGroup.getRootFolder().equals(fileObject)) continue;
                n = arrayList.size() - 1;
            }
        }
        object = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this.srcFolderCombo.setModel(object);
        if (arrayList.size() > 0) {
            this.srcFolderCombo.setSelectedIndex(n);
            this.srcGroup = (SourceGroup)arrayList.get(n);
            this.srcFolderCombo.setEnabled(true);
        } else {
            this.srcFolderCombo.setEnabled(false);
        }
    }

    private boolean setTargetElementsFromFolder(String string) {
        if (string == null) {
            return false;
        }
        FileObject fileObject = null;
        try {
            fileObject = FileUtil.toFileObject((File)new File(new File(string).getCanonicalPath()));
        }
        catch (IOException iOException) {
            return false;
        }
        if (fileObject == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        if (sources == null) {
            return false;
        }
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            for (SourceGroup sourceGroup : sourceGroupArray) {
                FileObject fileObject2 = sourceGroup.getRootFolder();
                if (!fileObject.equals(fileObject2)) continue;
                this.origPrj = project;
                this.srcGroup = sourceGroup;
                return true;
            }
        }
        return false;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    private static class SourceRootCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public SourceRootCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof SourceGroup) {
                SourceGroup sourceGroup = (SourceGroup)object;
                String string = sourceGroup.getDisplayName();
                if (string == null || string.length() == 0) {
                    FileObject fileObject = sourceGroup.getRootFolder();
                    string = fileObject.getPath();
                }
                this.setText(string);
            } else {
                this.setText(object == null ? " " : object.toString());
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private static class ProjectCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ProjectCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Project) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                this.setText(projectInformation.getDisplayName());
                this.setIcon(projectInformation.getIcon());
            } else {
                this.setText(object == null ? " " : object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

