/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.includes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.completion.cplusplus.NbCsmSyntaxSupport;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;

public class CsmIncludeCompletionItem
implements CompletionItem {
    protected static final String QUOTE = "\"";
    protected static final String SYS_OPEN = "<";
    protected static final String SYS_CLOSE = ">";
    protected static final String SLASH = "/";
    protected static final String PARENT_COLOR_TAG = "<font color=\"#557755\">";
    private static final int MAX_DISPLAYED_DIR_LENGTH = 35;
    private static final int NR_DISPLAYED_FRONT_DIRS = 2;
    private static final int NR_DISPLAYED_TRAILING_DIRS = 2;
    private final int substitutionOffset;
    private final int priority;
    private final String item;
    private final String parentFolder;
    private final String childSubdir;
    private final boolean isSysInclude;
    private final boolean isFolder;
    private final boolean supportInstantSubst;
    private static final int FOLDER_PRIORITY = 30;
    private static final int FILE_PRIORITY = 10;
    private static final int SYS_VS_USR = 5;

    protected CsmIncludeCompletionItem(int n, int n2, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        this.substitutionOffset = n;
        this.priority = n2;
        this.parentFolder = string == null ? "" : string;
        this.childSubdir = string2 == null ? "" : string2;
        this.isSysInclude = bl;
        this.isFolder = bl2;
        assert (string3 != null);
        this.item = string3;
        this.supportInstantSubst = bl3;
    }

    public static CsmIncludeCompletionItem createItem(int n, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2 = bl3 ? (bl2 ? 25 : 35) : (bl2 ? 5 : 15);
        String string4 = string;
        return new CsmIncludeCompletionItem(n, n2, string2, string3, string4, bl, bl3, bl4);
    }

    public String getItemText() {
        return this.item;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int n = jTextComponent.getSelectionEnd();
            this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, this.isFolder() ? SLASH : null);
            if (this.isFolder()) {
                Completion.get().showCompletion();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400) {
            JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            int n = jTextComponent.getSelectionEnd();
            int n2 = n - this.substitutionOffset;
            if (n2 < 0) {
                Completion.get().hideDocumentation();
                Completion.get().hideCompletion();
            }
            switch (keyEvent.getKeyChar()) {
                case '>': {
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                    break;
                }
                case '\"': {
                    baseDocument.atomicLock();
                    try {
                        String string;
                        if (n2 <= 0 || !(string = baseDocument.getText(this.substitutionOffset, n2)).startsWith(QUOTE) || n2 <= 1) break;
                        Completion.get().hideDocumentation();
                        Completion.get().hideCompletion();
                        break;
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                        break;
                    }
                    finally {
                        baseDocument.atomicUnlock();
                    }
                }
                case '/': {
                    if (n2 <= 1 || !this.isFolder()) break;
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                    this.substituteText(jTextComponent, this.substitutionOffset, n2, SLASH);
                    keyEvent.consume();
                    Completion.get().showCompletion();
                }
            }
        }
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        if (this.supportInstantSubst) {
            this.defaultAction(jTextComponent);
            return true;
        }
        return false;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(true), (String)this.getRightText(false, File.separator), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(true), (String)(PARENT_COLOR_TAG + this.getRightText(true, File.separator)), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.isFolder() ? "[D] " : "[F] ");
        stringBuilder.append(this.isSysInclude() ? SYS_OPEN : QUOTE);
        stringBuilder.append(this.getLeftHtmlText(false));
        stringBuilder.append(this.isSysInclude() ? SYS_CLOSE : QUOTE);
        stringBuilder.append(" : ");
        stringBuilder.append(this.getRightText(false, SLASH));
        return stringBuilder.toString();
    }

    public int getSortPriority() {
        return this.priority;
    }

    public CharSequence getSortText() {
        return this.item;
    }

    public CharSequence getInsertPrefix() {
        return this.item;
    }

    protected ImageIcon getIcon() {
        return CsmImageLoader.getIncludeImageIcon((boolean)this.isSysInclude(), (boolean)this.isFolder());
    }

    protected String getLeftHtmlText(boolean bl) {
        return (bl ? (this.isFolder() ? "<i>" : "") : "") + this.getItemText();
    }

    protected String getRightText(boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder(this.getParentFolder());
        stringBuilder.append(string).append(this.getChildSubdir());
        int n = stringBuilder.length();
        if (bl && n > 35) {
            int n2;
            StringBuilder stringBuilder2 = new StringBuilder(stringBuilder).reverse();
            int n3 = stringBuilder.indexOf(string);
            n3 = n3 < 0 ? 0 : ++n3;
            int n4 = 0;
            while (stringBuilder2.charAt(n4) == string.charAt(0)) {
                ++n4;
            }
            int n5 = Integer.MAX_VALUE;
            for (n2 = 2; n2 > 0 && n5 > 0; --n2) {
                n5 = stringBuilder.indexOf(string, n3);
                n3 = n5 + 1;
            }
            n2 = Integer.MAX_VALUE;
            for (int i = 2; i > 0 && n2 > 0; --i) {
                n2 = stringBuilder2.indexOf(string, n4);
                n4 = n2 + 1;
            }
            if (n2 > 0 && n5 > 0 && n5 < (n2 = n - n2) - 1) {
                stringBuilder.replace(n5, n2 - 1, "...");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        String string2 = this.getItemText();
        if (string2 != null) {
            TokenItem tokenItem = null;
            NbCsmSyntaxSupport nbCsmSyntaxSupport = (NbCsmSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)jTextComponent).get(NbCsmSyntaxSupport.class);
            if (nbCsmSyntaxSupport != null) {
                tokenItem = nbCsmSyntaxSupport.getTokenItem(n);
            }
            if (string != null) {
                string2 = string2 + string;
            }
            String string3 = QUOTE;
            String string4 = QUOTE;
            if (tokenItem != null) {
                switch (tokenItem.getTokenID().getNumericID()) {
                    case 6: 
                    case 7: {
                        string3 = this.isSysInclude ? SYS_OPEN : QUOTE;
                        string4 = this.isSysInclude ? SYS_CLOSE : QUOTE;
                        break;
                    }
                    case 155: 
                    case 165: {
                        string3 = QUOTE;
                        string4 = QUOTE;
                        n2 = tokenItem.getOffset() + tokenItem.getImage().length() - n;
                        break;
                    }
                    case 154: 
                    case 164: {
                        string3 = SYS_OPEN;
                        string4 = SYS_CLOSE;
                        n2 = tokenItem.getOffset() + tokenItem.getImage().length() - n;
                    }
                }
            }
            baseDocument.atomicLock();
            try {
                String string5 = this.getChildSubdir();
                if (string5.length() > 0 && !string5.endsWith(SLASH)) {
                    string5 = string5 + SLASH;
                }
                string2 = string3 + string5 + string2 + string4;
                Position position = baseDocument.createPosition(n);
                Position position2 = baseDocument.createPosition(n + n2);
                baseDocument.remove(n, n2);
                baseDocument.insertString(position.getOffset(), string2, null);
                if (jTextComponent != null && this.isFolder()) {
                    jTextComponent.setCaretPosition(position2.getOffset() - 1);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
    }

    protected boolean isFolder() {
        return this.isFolder;
    }

    protected String getParentFolder() {
        return this.parentFolder;
    }

    protected String getChildSubdir() {
        return this.childSubdir;
    }

    protected boolean isSysInclude() {
        return this.isSysInclude;
    }
}

