/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.modules.cnd.ui.options.AddCompilerSetPanel;
import org.netbeans.modules.cnd.ui.options.DuplicateCompilerSetPanel;
import org.netbeans.modules.cnd.ui.options.GlobalToolsPanelModel;
import org.netbeans.modules.cnd.ui.options.ToolsPanelModel;
import org.netbeans.modules.cnd.ui.options.VersionCommand;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ToolsPanel
extends JPanel
implements ActionListener,
DocumentListener,
ListSelectionListener,
ItemListener {
    private final String MAKE_NAME = "make";
    private final String GDB_NAME = "gdb";
    private final String C_NAME = "C";
    private final String CPP_NAME = "C++";
    private final String FORTRAN_NAME = "Fortran";
    public static final String PROP_VALID = "valid";
    private boolean initialized = false;
    private boolean changed;
    private boolean changingCompilerSet;
    private boolean updating;
    private boolean valid;
    private ToolsPanelModel model = null;
    private Color tfColor = null;
    private boolean gdbEnabled;
    private static ToolsPanel instance = null;
    private CompilerSetManager csm;
    private CompilerSet currentCompilerSet;
    static Set<ChangeListener> listenerChanged = new HashSet<ChangeListener>();
    static Set<ChangeListener> listenerModified = new HashSet<ChangeListener>();
    private JPanel ToolSetPanel;
    private JButton btAdd;
    private JButton btBaseDirectory;
    private JButton btCVersion;
    private JButton btCppVersion;
    private JButton btDown;
    private JButton btFortranVersion;
    private JButton btGdbVersion;
    private JButton btMakeVersion;
    private JButton btRemove;
    private JButton btRestore;
    private JButton btVersions;
    private JPanel buttomPanel;
    private JPanel buttonPanel;
    private JCheckBox cbCRequired;
    private JCheckBox cbCppRequired;
    private JComboBox cbFamily;
    private JCheckBox cbFortranRequired;
    private JCheckBox cbGdbRequired;
    private JCheckBox cbMakeRequired;
    private JButton duplicateButton;
    private JScrollPane errorScrollPane;
    private JTextArea errorTextArea;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel lbBaseDirectory;
    private JLabel lbCCommand;
    private JLabel lbCompilerCollection;
    private JLabel lbCppCommand;
    private JLabel lbDirlist;
    private JLabel lbFortranCommand;
    private JLabel lbGdbCommand;
    private JLabel lbMakeCommand;
    private JList lstDirlist;
    private JScrollPane spDirlist;
    private JTextField tfBaseDirectory;
    private JTextField tfCPath;
    private JTextField tfCppPath;
    private JTextField tfFortranPath;
    private JTextField tfGdbPath;
    private JTextField tfMakePath;

    public ToolsPanel() {
        this.initComponents();
        this.setName("TAB_ToolsTab");
        this.cbGdbRequired.setName("gdb");
        this.cbCRequired.setName("c");
        this.cbCppRequired.setName("c++");
        this.cbFortranRequired.setName("fortran");
        this.changed = false;
        instance = this;
        this.currentCompilerSet = null;
        this.errorTextArea.setText("");
        this.errorTextArea.setBackground(this.jPanel1.getBackground());
        this.lstDirlist.setCellRenderer(new MyCellRenderer());
    }

    public ToolsPanel(ToolsPanelModel toolsPanelModel) {
        this();
        this.model = toolsPanelModel;
    }

    private void initialize() {
        this.changingCompilerSet = true;
        if (this.model == null) {
            this.model = new GlobalToolsPanelModel();
        }
        if (!this.model.showRequiredTools()) {
            this.jLabel1.setVisible(false);
            this.jPanel1.setVisible(false);
        }
        this.btBaseDirectory.setEnabled(false);
        this.btCVersion.setEnabled(false);
        this.btCppVersion.setEnabled(false);
        this.btFortranVersion.setEnabled(false);
        this.btMakeVersion.setEnabled(false);
        this.btGdbVersion.setEnabled(false);
        this.btVersions.setEnabled(false);
        this.tfMakePath.setEnabled(false);
        this.tfGdbPath.setEnabled(false);
        this.btVersions.setEnabled(false);
        if (this.model.enableRequiredCompilerCB()) {
            this.cbCRequired.setEnabled(true);
            this.cbCppRequired.setEnabled(true);
            this.cbFortranRequired.setEnabled(true);
        } else {
            this.cbCRequired.setEnabled(false);
            this.cbCppRequired.setEnabled(false);
            this.cbFortranRequired.setEnabled(false);
        }
        this.csm = CompilerSetManager.getDefault().deepCopy();
        if (this.csm.getCompilerSets().size() == 1 && this.csm.getCompilerSets().get(0).getName() == "None") {
            this.csm.remove(this.csm.getCompilerSets().get(0));
        }
        this.gdbEnabled = !IpeUtils.isDbxguiEnabled();
        boolean bl = CppSettings.getDefault().isFortranEnabled();
        this.lbFortranCommand.setVisible(bl);
        this.tfFortranPath.setVisible(bl);
        this.btFortranVersion.setVisible(bl);
        this.cbFortranRequired.setVisible(bl);
        this.cbMakeRequired.setSelected(this.model.isMakeRequired());
        this.cbGdbRequired.setSelected(this.model.isGdbRequired());
        this.cbCRequired.setSelected(this.model.isCRequired());
        this.cbCppRequired.setSelected(this.model.isCppRequired());
        this.cbFortranRequired.setSelected(this.model.isFortranRequired());
    }

    private void addCompilerSet() {
        AddCompilerSetPanel addCompilerSetPanel = new AddCompilerSetPanel(this.csm);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addCompilerSetPanel, ToolsPanel.getString("NEW_TOOL_SET_TITLE"));
        addCompilerSetPanel.setDialogDescriptor(dialogDescriptor);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        String string = addCompilerSetPanel.getBaseDirectory();
        CompilerSet.CompilerFlavor compilerFlavor = addCompilerSetPanel.getFamily();
        String string2 = addCompilerSetPanel.getCompilerSetName().trim();
        CompilerSet compilerSet = CompilerSet.getCustomCompilerSet(new File(string).getAbsolutePath(), compilerFlavor, string2);
        CompilerSetManager.getDefault().initCompilerSet(compilerSet);
        this.csm.add(compilerSet);
        this.changed = true;
        this.update(false, compilerSet);
    }

    private void duplicateCompilerSet() {
        CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        DuplicateCompilerSetPanel duplicateCompilerSetPanel = new DuplicateCompilerSetPanel(this.csm, compilerSet);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)duplicateCompilerSetPanel, ToolsPanel.getString("COPY_TOOL_SET_TITLE"));
        duplicateCompilerSetPanel.setDialogDescriptor(dialogDescriptor);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        String string = duplicateCompilerSetPanel.getCompilerSetName().trim();
        CompilerSet compilerSet2 = compilerSet.createCopy();
        compilerSet2.setName(string);
        compilerSet2.setAsDefault(false);
        compilerSet2.setAutoGenerated(false);
        this.csm.add(compilerSet2);
        this.changed = true;
        this.update(false, compilerSet2);
    }

    private void removeCompilerSet() {
        CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        if (compilerSet != null) {
            int n = this.csm.getCompilerSets().indexOf(compilerSet);
            this.csm.remove(compilerSet);
            if (compilerSet.isDefault() && this.csm.getCompilerSets().size() > 0) {
                this.csm.getCompilerSet(0).setAsDefault(true);
            }
            if (n >= 0 && n < this.csm.getCompilerSets().size()) {
                this.update(false, this.csm.getCompilerSets().get(n));
            } else if (n > 0) {
                this.update(false, this.csm.getCompilerSets().get(n - 1));
            } else {
                this.tfBaseDirectory.setText("");
                this.btBaseDirectory.setEnabled(false);
                this.cbFamily.removeAllItems();
                this.tfCPath.setText("");
                this.tfCppPath.setText("");
                this.tfFortranPath.setText("");
                this.tfMakePath.setText("");
                this.tfGdbPath.setText("");
                this.update(false);
            }
            this.changed = true;
        }
    }

    private void setSelectedAsDefault() {
        CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        this.csm.setDefault(compilerSet);
        this.changed = true;
        this.update(false);
    }

    private void setMakePathField(String string) {
        this.tfMakePath.setText(string);
    }

    private void validateMakePathField() {
        this.setPathFieldValid(this.tfMakePath, this.isPathFieldValid(this.tfMakePath));
        this.dataValid();
    }

    private void setGdbPathField(String string) {
        this.tfGdbPath.setText(string);
    }

    private void validateGdbPathField() {
        this.setPathFieldValid(this.tfGdbPath, this.isPathFieldValid(this.tfGdbPath));
        this.dataValid();
    }

    private void setCPathField(String string) {
        this.tfCPath.setText(string);
    }

    private void validateCPathField() {
        this.setPathFieldValid(this.tfCPath, this.isPathFieldValid(this.tfCPath));
        this.dataValid();
    }

    private void setCppPathField(String string) {
        this.tfCppPath.setText(string);
    }

    private void validateCppPathField() {
        this.setPathFieldValid(this.tfCppPath, this.isPathFieldValid(this.tfCppPath));
        this.dataValid();
    }

    private void setFortranPathField(String string) {
        this.tfFortranPath.setText(string);
    }

    private void validateFortranPathField() {
        this.setPathFieldValid(this.tfFortranPath, this.isPathFieldValid(this.tfFortranPath));
        this.dataValid();
    }

    private boolean isPathFieldValid(JTextField jTextField) {
        boolean bl;
        block2: {
            String string;
            String string2 = jTextField.getText();
            if (string2.length() == 0) {
                return false;
            }
            File file = new File(string2);
            bl = false;
            boolean bl2 = bl = file.exists() && !file.isDirectory();
            if (bl) break block2;
            ArrayList<String> arrayList = Path.getPath();
            Iterator<String> iterator = arrayList.iterator();
            while (iterator.hasNext() && !(bl = (file = new File((string = iterator.next()) + File.separatorChar + string2)).exists() && !file.isDirectory())) {
            }
        }
        return bl;
    }

    private void setPathFieldValid(JTextField jTextField, boolean bl) {
        if (bl) {
            jTextField.setForeground(this.tfColor);
        } else {
            jTextField.setForeground(Color.RED);
        }
    }

    public void update() {
        this.update(true, null);
    }

    private void update(CompilerSet compilerSet) {
        this.update(true, compilerSet);
    }

    private void update(boolean bl) {
        this.update(bl, null);
    }

    public void update(boolean bl, CompilerSet compilerSet) {
        this.updating = true;
        if (!this.initialized || bl) {
            this.initialize();
        }
        this.lbGdbCommand.setVisible(this.gdbEnabled);
        this.tfGdbPath.setVisible(this.gdbEnabled);
        this.btGdbVersion.setVisible(this.gdbEnabled);
        this.cbMakeRequired.setVisible(this.model.showRequiredBuildTools());
        this.cbGdbRequired.setVisible(this.model.showRequiredDebugTools() && this.gdbEnabled);
        this.cbCppRequired.setVisible(this.model.showRequiredBuildTools());
        this.cbCRequired.setVisible(this.model.showRequiredBuildTools());
        this.cbFortranRequired.setVisible(this.model.showRequiredBuildTools() && CppSettings.getDefault().isFortranEnabled());
        if (bl && !this.csm.getCompilerSets().isEmpty()) {
            String string = this.model.getCompilerSetName();
            if (string == null) {
                // empty if block
            }
            if (string.length() == 0 || this.csm.getCompilerSet(string) == null) {
                this.csm.getCompilerSet(0).setAsDefault(true);
            } else {
                this.csm.setDefault(this.csm.getCompilerSet(string));
            }
            String string2 = this.model.getSelectedCompilerSetName();
            if (string2 != null) {
                compilerSet = this.csm.getCompilerSet(string2);
            }
            if (compilerSet == null) {
                compilerSet = this.csm.getDefaultCompilerSet();
            }
        }
        if (compilerSet == null) {
            compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        }
        this.lstDirlist.setListData(this.csm.getCompilerSets().toArray());
        if (compilerSet != null) {
            this.lstDirlist.setSelectedValue(compilerSet, true);
        }
        if (this.lstDirlist.getSelectedIndex() < 0) {
            this.lstDirlist.setSelectedIndex(0);
        }
        this.updating = false;
        this.dataValid();
        this.initialized = true;
    }

    private void changeCompilerSet(CompilerSet compilerSet) {
        Object object;
        Object object2;
        Object object3;
        if (compilerSet != null) {
            this.tfBaseDirectory.setText(compilerSet.getDirectory());
            this.btBaseDirectory.setEnabled(true);
            this.cbFamily.removeAllItems();
            object3 = CompilerSet.CompilerFlavor.getFlavors();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (CompilerSet.CompilerFlavor)((Object)object2.next());
                this.cbFamily.addItem(object);
            }
        } else {
            this.tfBaseDirectory.setText("");
            this.btBaseDirectory.setEnabled(false);
            this.cbFamily.removeAllItems();
            return;
        }
        this.cbFamily.setSelectedItem((Object)compilerSet.getCompilerFlavor());
        if (this.currentCompilerSet != null && this.currentCompilerSet != compilerSet) {
            object3 = this.currentCompilerSet.findTool(Tool.CCompiler);
            ((Tool)object3).setPath(this.tfCPath.getText());
            object3 = this.currentCompilerSet.findTool(Tool.CCCompiler);
            ((Tool)object3).setPath(this.tfCppPath.getText());
            object3 = this.currentCompilerSet.findTool(Tool.FortranCompiler);
            ((Tool)object3).setPath(this.tfFortranPath.getText());
            object3 = this.currentCompilerSet.findTool(Tool.MakeTool);
            ((Tool)object3).setPath(this.tfMakePath.getText());
            object3 = this.currentCompilerSet.findTool(Tool.DebuggerTool);
            ((Tool)object3).setPath(this.tfGdbPath.getText());
        }
        this.changingCompilerSet = true;
        object3 = compilerSet.getTool(Tool.CCompiler);
        object2 = compilerSet.getTool(Tool.CCCompiler);
        object = compilerSet.getTool(Tool.FortranCompiler);
        Tool tool = compilerSet.getTool(Tool.MakeTool);
        Tool tool2 = compilerSet.getTool(Tool.DebuggerTool);
        if (object3 != null) {
            this.setCPathField(((Tool)object3).getPath());
        } else {
            this.tfCPath.setText("");
        }
        if (object2 != null) {
            this.setCppPathField(((Tool)object2).getPath());
        } else {
            this.tfCppPath.setText("");
        }
        if (object != null) {
            this.setFortranPathField(((Tool)object).getPath());
        } else {
            this.tfFortranPath.setText("");
        }
        this.setMakePathField(tool.getPath());
        this.setGdbPathField(tool2.getPath());
        this.changingCompilerSet = false;
        this.currentCompilerSet = compilerSet;
        this.fireCompilerSetChange();
        this.dataValid();
    }

    public void applyChanges(boolean bl) {
        this.changed = bl;
        this.applyChanges();
    }

    public void applyChanges() {
        if (this.changed) {
            CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
            this.changed = false;
            if (compilerSet != null) {
                compilerSet.getTool(Tool.MakeTool).setPath(this.tfMakePath.getText());
                compilerSet.getTool(Tool.DebuggerTool).setPath(this.tfGdbPath.getText());
                compilerSet.getTool(Tool.CCompiler).setPath(this.tfCPath.getText());
                compilerSet.getTool(Tool.CCCompiler).setPath(this.tfCppPath.getText());
                compilerSet.getTool(Tool.FortranCompiler).setPath(this.tfFortranPath.getText());
                this.model.setCompilerSetName(this.csm.getDefaultCompilerSet().getName());
                this.model.setSelectedCompilerSetName(compilerSet.getName());
            }
            this.csm.saveToDisk();
            CompilerSetManager.setDefault(this.csm);
            this.currentCompilerSet = compilerSet;
        }
        if (this.model != null) {
            if (this.model.isGdbRequired() != this.cbGdbRequired.isSelected()) {
                this.model.setGdbRequired(this.cbGdbRequired.isSelected());
            }
            if (this.model.isCRequired() != this.cbCRequired.isSelected()) {
                this.model.setCRequired(this.cbCRequired.isSelected());
            }
            if (this.model.isCppRequired() != this.cbCppRequired.isSelected()) {
                this.model.setCppRequired(this.cbCppRequired.isSelected());
            }
            if (this.model.isFortranRequired() != this.cbFortranRequired.isSelected()) {
                this.model.setFortranRequired(this.cbFortranRequired.isSelected());
            }
        }
        instance = null;
    }

    public void cancel() {
        this.changed = false;
    }

    public static ToolsPanel getToolsPanel() {
        return instance;
    }

    public CompilerSetManager getCompilerSetManager() {
        if (this.csm == null) {
            this.csm = CompilerSetManager.getDefault();
        }
        return this.csm;
    }

    public CompilerSet getCurrentCompilerSet() {
        return this.currentCompilerSet;
    }

    public boolean dataValid() {
        boolean bl;
        if (this.csm.getCompilerSets().size() == 0) {
            this.valid = false;
            this.firePropertyChange(PROP_VALID, !this.valid, this.valid);
            return false;
        }
        if (this.updating || this.changingCompilerSet) {
            return true;
        }
        boolean bl2 = this.csm.getCompilerSets().size() > 0;
        boolean bl3 = this.cbMakeRequired.isSelected() ? this.isPathFieldValid(this.tfMakePath) : true;
        boolean bl4 = this.cbGdbRequired.isSelected() ? this.isPathFieldValid(this.tfGdbPath) : true;
        boolean bl5 = this.cbCRequired.isSelected() ? this.isPathFieldValid(this.tfCPath) : true;
        boolean bl6 = this.cbCppRequired.isSelected() ? this.isPathFieldValid(this.tfCppPath) : true;
        boolean bl7 = bl = this.cbFortranRequired.isSelected() ? this.isPathFieldValid(this.tfFortranPath) : true;
        if (!this.initialized) {
            this.valid = !bl2 || !bl3 || !bl4 || !bl5 || !bl6 || !bl;
        }
        if (this.valid != (bl2 && bl3 && bl4 && bl5 && bl6 && bl)) {
            this.valid = !this.valid;
            this.firePropertyChange(PROP_VALID, !this.valid, this.valid);
        }
        this.errorTextArea.setText("");
        this.errorTextArea.setRows(0);
        if (!this.valid) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.cbMakeRequired.isSelected() && !bl3) {
                arrayList.add(NbBundle.getBundle(ToolsPanel.class).getString("TP_ErrorMessage_MissedMake"));
            }
            if (this.cbCRequired.isSelected() && !bl5) {
                arrayList.add(NbBundle.getBundle(ToolsPanel.class).getString("TP_ErrorMessage_MissedCCompiler"));
            }
            if (this.cbCppRequired.isSelected() && !bl6) {
                arrayList.add(NbBundle.getBundle(ToolsPanel.class).getString("TP_ErrorMessage_MissedCppCompiler"));
            }
            if (this.cbGdbRequired.isSelected() && !bl4) {
                arrayList.add(NbBundle.getBundle(ToolsPanel.class).getString("TP_ErrorMessage_MissedDebugger"));
            }
            if (this.cbFortranRequired.isSelected() && !bl) {
                arrayList.add(NbBundle.getBundle(ToolsPanel.class).getString("TP_ErrorMessage_MissedFortranCompiler"));
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuilder.append((String)arrayList.get(i));
                if (i >= arrayList.size() - 1) continue;
                stringBuilder.append("\n");
            }
            this.errorTextArea.setRows(arrayList.size());
            this.errorTextArea.setText(stringBuilder.toString());
            this.validate();
            this.repaint();
        }
        if (new File(this.tfBaseDirectory.getText()).exists()) {
            this.btCVersion.setEnabled(true);
            this.btCppVersion.setEnabled(true);
            this.btFortranVersion.setEnabled(true);
            this.btMakeVersion.setEnabled(true);
            this.btGdbVersion.setEnabled(true);
            this.btVersions.setEnabled(true);
            this.tfMakePath.setEnabled(true);
            this.tfGdbPath.setEnabled(true);
        } else {
            this.btCVersion.setEnabled(false);
            this.btCppVersion.setEnabled(false);
            this.btFortranVersion.setEnabled(false);
            this.btMakeVersion.setEnabled(false);
            this.btGdbVersion.setEnabled(false);
            this.btVersions.setEnabled(false);
            this.tfMakePath.setEnabled(false);
            this.tfGdbPath.setEnabled(false);
        }
        return this.valid;
    }

    public boolean isChanged() {
        return this.changed;
    }

    String getToolVersion(Tool tool, JTextField jTextField) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tool.getDisplayName() + ": ");
        if (this.isPathFieldValid(jTextField)) {
            String string;
            String string2 = jTextField.getText();
            if (!IpeUtils.isPathAbsolute(string2)) {
                string2 = Path.findCommand(string2);
            }
            if ((string = this.postVersionInfo(tool.getFlavor(), string2)) != null) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append(ToolsPanel.getString("TOOL_VERSION_NOT_FOUND"));
            }
        } else {
            stringBuilder.append(ToolsPanel.getString("TOOL_NOT_FOUND"));
        }
        return stringBuilder.toString();
    }

    private String postVersionInfo(CompilerSet.CompilerFlavor compilerFlavor, String string) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.exists()) {
            try {
                String string3;
                FileObject fileObject = FileUtil.toFileObject((File)file.getCanonicalFile());
                if (fileObject != null && ((string3 = fileObject.getMIMEType()).startsWith("application/x-exe") || string3.equals("text/sh"))) {
                    VersionCommand versionCommand = new VersionCommand(compilerFlavor, string);
                    string2 = versionCommand.getVersion();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static void addCompilerSetChangeListener(ChangeListener changeListener) {
        listenerChanged.add(changeListener);
    }

    public static void removeCompilerSetChangeListener(ChangeListener changeListener) {
        listenerChanged.remove(changeListener);
    }

    public void fireCompilerSetChange() {
        ChangeEvent changeEvent = new ChangeEvent(this.currentCompilerSet);
        for (ChangeListener changeListener : listenerChanged) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public static void addCompilerSetModifiedListener(ChangeListener changeListener) {
        listenerModified.add(changeListener);
    }

    public static void removeCompilerSetModifiedListener(ChangeListener changeListener) {
        listenerModified.remove(changeListener);
    }

    public void fireCompilerSetModified() {
        ChangeEvent changeEvent = new ChangeEvent(this.currentCompilerSet);
        for (ChangeListener changeListener : listenerModified) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.btAdd) {
                this.addCompilerSet();
            } else if (object == this.btRemove) {
                this.removeCompilerSet();
            } else if (object == this.duplicateButton) {
                this.duplicateCompilerSet();
            } else if (object == this.btDown) {
                this.setSelectedAsDefault();
            } else if (object == this.btMakeVersion || object == this.btGdbVersion || object == this.btCVersion || object == this.btCppVersion || object == this.btFortranVersion) {
                // empty if block
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (!this.updating) {
            if (object instanceof JComboBox && itemEvent.getStateChange() == 1) {
                Object object2 = itemEvent.getItem();
                this.changed = true;
            } else if (object instanceof JCheckBox && !this.changingCompilerSet) {
                this.dataValid();
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.updating) {
            this.changed = true;
        }
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            String string2 = (String)document.getProperty("title");
            if (string2 == "make") {
                this.validateMakePathField();
            } else if (string2 == "gdb") {
                this.validateGdbPathField();
            } else if (string2 == "C") {
                this.validateCPathField();
            } else if (string2 == "C++") {
                this.validateCppPathField();
            } else if (string2 == "Fortran") {
                this.validateFortranPathField();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && listSelectionEvent.getSource() == this.lstDirlist) {
            boolean bl = this.model.showRequiredTools() ? this.lstDirlist.getSelectedIndex() >= 0 : this.csm.getCompilerSets().size() > 1 && this.lstDirlist.getSelectedIndex() >= 0;
            this.changeCompilerSet((CompilerSet)this.lstDirlist.getSelectedValue());
            this.btRemove.setEnabled(bl);
            this.duplicateButton.setEnabled(this.lstDirlist.getSelectedIndex() >= 0);
            this.btDown.setEnabled(this.lstDirlist.getSelectedIndex() >= 0 && !((CompilerSet)this.lstDirlist.getSelectedValue()).isDefault());
        }
    }

    private void initComponents() {
        this.lbDirlist = new JLabel();
        this.lbMakeCommand = new JLabel();
        this.tfMakePath = new JTextField();
        this.tfMakePath.getDocument().putProperty("title", "make");
        this.tfMakePath.getDocument().addDocumentListener(this);
        this.btMakeVersion = new JButton();
        this.btMakeVersion.addActionListener(this);
        this.lbGdbCommand = new JLabel();
        this.tfGdbPath = new JTextField();
        this.tfGdbPath.getDocument().putProperty("title", "gdb");
        this.tfGdbPath.getDocument().addDocumentListener(this);
        this.btGdbVersion = new JButton();
        this.btGdbVersion.addActionListener(this);
        this.lbCCommand = new JLabel();
        this.tfCPath = new JTextField();
        this.tfCPath.getDocument().putProperty("title", "C");
        this.tfCPath.getDocument().addDocumentListener(this);
        this.btCVersion = new JButton();
        this.btCVersion.addActionListener(this);
        this.lbCppCommand = new JLabel();
        this.tfCppPath = new JTextField();
        this.tfCppPath.getDocument().putProperty("title", "C++");
        this.tfCppPath.getDocument().addDocumentListener(this);
        this.btCppVersion = new JButton();
        this.btCppVersion.addActionListener(this);
        this.lbFortranCommand = new JLabel();
        this.tfFortranPath = new JTextField();
        this.tfFortranPath.getDocument().putProperty("title", "Fortran");
        this.tfFortranPath.getDocument().addDocumentListener(this);
        this.btFortranVersion = new JButton();
        this.btFortranVersion.addActionListener(this);
        this.lbCompilerCollection = new JLabel();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.cbMakeRequired = new JCheckBox();
        this.cbGdbRequired = new JCheckBox();
        this.cbGdbRequired.addItemListener(this);
        this.cbCRequired = new JCheckBox();
        this.cbCRequired.addItemListener(this);
        this.cbCppRequired = new JCheckBox();
        this.cbCppRequired.addItemListener(this);
        this.cbFortranRequired = new JCheckBox();
        this.cbFortranRequired.addItemListener(this);
        this.lbBaseDirectory = new JLabel();
        this.tfBaseDirectory = new JTextField();
        this.btBaseDirectory = new JButton();
        this.btVersions = new JButton();
        this.buttomPanel = new JPanel();
        this.errorScrollPane = new JScrollPane();
        this.errorTextArea = new JTextArea();
        this.btRestore = new JButton();
        this.ToolSetPanel = new JPanel();
        this.spDirlist = new JScrollPane(this.lstDirlist);
        this.lstDirlist = new JList();
        this.buttonPanel = new JPanel();
        this.btAdd = new JButton();
        this.btAdd.addActionListener(this);
        this.btRemove = new JButton();
        this.btRemove.addActionListener(this);
        this.duplicateButton = new JButton();
        this.duplicateButton.addActionListener(this);
        this.btDown = new JButton();
        this.btDown.addActionListener(this);
        this.cbFamily = new JComboBox();
        this.setMinimumSize(new Dimension(600, 400));
        this.setLayout(new GridBagLayout());
        this.lbDirlist.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_DirlistLabel").charAt(0));
        this.lbDirlist.setLabelFor(this.spDirlist);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle");
        this.lbDirlist.setText(resourceBundle.getString("LBL_DirlistLabel"));
        this.lbDirlist.setToolTipText(resourceBundle.getString("HINT_DirListLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 4);
        this.add((Component)this.lbDirlist, gridBagConstraints);
        this.lbDirlist.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_DirlistLabel"));
        this.lbDirlist.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_DirlistLabel"));
        this.lbMakeCommand.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_MakeCommand").charAt(0));
        this.lbMakeCommand.setLabelFor(this.tfMakePath);
        this.lbMakeCommand.setText(resourceBundle.getString("LBL_MakeCommand"));
        this.lbMakeCommand.setToolTipText(resourceBundle.getString("HINT_MakeCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 10, 0, 0);
        this.add((Component)this.lbMakeCommand, gridBagConstraints);
        this.lbMakeCommand.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_MakeCommand"));
        this.lbMakeCommand.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_MakeCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 2, 0, 0);
        this.add((Component)this.tfMakePath, gridBagConstraints);
        this.tfMakePath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.tfMakePath.AccessibleContext.accessibleDescription"));
        this.btMakeVersion.setText(resourceBundle.getString("LBL_MakeVersion"));
        this.btMakeVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btMakeVersionActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.add((Component)this.btMakeVersion, gridBagConstraints);
        this.btMakeVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btMakeVersion.AccessibleContext.accessibleDescription"));
        this.lbGdbCommand.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_GdbCommand").charAt(0));
        this.lbGdbCommand.setLabelFor(this.tfGdbPath);
        this.lbGdbCommand.setText(resourceBundle.getString("LBL_GdbCommand"));
        this.lbGdbCommand.setToolTipText(resourceBundle.getString("HINT_GdbCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbGdbCommand, gridBagConstraints);
        this.lbGdbCommand.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_GdbCommand"));
        this.lbGdbCommand.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_GdbCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfGdbPath, gridBagConstraints);
        this.tfGdbPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.tfGdbPath.AccessibleContext.accessibleDescription"));
        this.btGdbVersion.setText(resourceBundle.getString("LBL_GdbVersion"));
        this.btGdbVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btGdbVersionActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btGdbVersion, gridBagConstraints);
        this.btGdbVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btGdbVersion.AccessibleContext.accessibleDescription"));
        this.lbCCommand.setLabelFor(this.tfCPath);
        this.lbCCommand.setText(resourceBundle.getString("LBL_CCommand"));
        this.lbCCommand.setToolTipText(resourceBundle.getString("HINT_CCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 22, 0, 0);
        this.add((Component)this.lbCCommand, gridBagConstraints);
        this.lbCCommand.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CCommand"));
        this.lbCCommand.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CCommand"));
        this.tfCPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfCPath, gridBagConstraints);
        this.btCVersion.setText(resourceBundle.getString("LBL_CVersion"));
        this.btCVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btCVersionActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btCVersion, gridBagConstraints);
        this.btCVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btCVersion.AccessibleContext.accessibleDescription"));
        this.lbCppCommand.setLabelFor(this.tfCppPath);
        this.lbCppCommand.setText(resourceBundle.getString("LBL_CppCommand"));
        this.lbCppCommand.setToolTipText(resourceBundle.getString("HINT_CppCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 22, 0, 0);
        this.add((Component)this.lbCppCommand, gridBagConstraints);
        this.lbCppCommand.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CppCommand"));
        this.lbCppCommand.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CppCommand"));
        this.tfCppPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfCppPath, gridBagConstraints);
        this.btCppVersion.setText(resourceBundle.getString("LBL_CppVersion"));
        this.btCppVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btCppVersionActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btCppVersion, gridBagConstraints);
        this.btCppVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btCppVersion.AccessibleContext.accessibleDescription"));
        this.lbFortranCommand.setLabelFor(this.tfFortranPath);
        this.lbFortranCommand.setText(resourceBundle.getString("LBL_FortranCommand"));
        this.lbFortranCommand.setToolTipText(resourceBundle.getString("HINT_FortranCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 22, 0, 0);
        this.add((Component)this.lbFortranCommand, gridBagConstraints);
        this.lbFortranCommand.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_FortranCommand"));
        this.lbFortranCommand.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_FortranCommand"));
        this.tfFortranPath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.add((Component)this.tfFortranPath, gridBagConstraints);
        this.btFortranVersion.setText(resourceBundle.getString("LBL_FortranVersion"));
        this.btFortranVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btFortranVersionActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btFortranVersion, gridBagConstraints);
        this.btFortranVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btFortranVersion.AccessibleContext.accessibleDescription"));
        this.lbCompilerCollection.setLabelFor(this.cbFamily);
        this.lbCompilerCollection.setText(resourceBundle.getString("LBL_CompilerCollection"));
        this.lbCompilerCollection.setToolTipText(resourceBundle.getString("HINT_CompilerCollection"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.lbCompilerCollection, gridBagConstraints);
        this.lbCompilerCollection.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CompilerCollection"));
        this.lbCompilerCollection.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CompilerCollection"));
        this.jLabel1.setLabelFor(this.cbMakeRequired);
        this.jLabel1.setText(resourceBundle.getString("LBL_RequiredTools"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 10, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.cbMakeRequired.setSelected(true);
        this.cbMakeRequired.setText(resourceBundle.getString("LBL_RequiredMake"));
        this.cbMakeRequired.setEnabled(false);
        this.cbMakeRequired.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.cbMakeRequired, gridBagConstraints);
        this.cbGdbRequired.setText(resourceBundle.getString("LBL_RequiredGdb"));
        this.cbGdbRequired.setEnabled(false);
        this.cbGdbRequired.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.cbGdbRequired, gridBagConstraints);
        this.cbCRequired.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_CCompiler_CB").charAt(0));
        this.cbCRequired.setText(resourceBundle.getString("LBL_RequiredCompiler_C"));
        this.cbCRequired.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.cbCRequired, gridBagConstraints);
        this.cbCppRequired.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_CppCompiler_CB").charAt(0));
        this.cbCppRequired.setText(resourceBundle.getString("LBL_RequiredCompiler_Cpp"));
        this.cbCppRequired.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel1.add((Component)this.cbCppRequired, gridBagConstraints);
        this.cbFortranRequired.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_FortranCompiler_CB").charAt(0));
        this.cbFortranRequired.setText(resourceBundle.getString("LBL_RequiredCompiler_Fortran"));
        this.cbFortranRequired.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.jPanel1.add((Component)this.cbFortranRequired, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 2, 0, 6);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.lbBaseDirectory.setLabelFor(this.tfBaseDirectory);
        this.lbBaseDirectory.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lbBaseDirectory.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.lbBaseDirectory, gridBagConstraints);
        this.tfBaseDirectory.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 2, 0, 0);
        this.add((Component)this.tfBaseDirectory, gridBagConstraints);
        this.tfBaseDirectory.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.tfBaseDirectory.AccessibleContext.accessibleDescription"));
        this.btBaseDirectory.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btBaseDirectory.text"));
        this.btBaseDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btBaseDirectoryActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btBaseDirectory, gridBagConstraints);
        this.btBaseDirectory.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btBaseDirectory.AccessibleContext.accessibleDescription"));
        this.btVersions.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_Versions").charAt(0));
        this.btVersions.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btVersions.text"));
        this.btVersions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btVersionsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.add((Component)this.btVersions, gridBagConstraints);
        this.btVersions.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btVersions.AccessibleContext.accessibleDescription"));
        this.buttomPanel.setLayout(new GridBagLayout());
        this.errorScrollPane.setBorder(null);
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setForeground(new Color(255, 0, 0));
        this.errorTextArea.setLineWrap(true);
        this.errorTextArea.setRows(3);
        this.errorTextArea.setBorder(null);
        this.errorScrollPane.setViewportView(this.errorTextArea);
        this.errorTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.errorTextArea.AccessibleContext.accessibleName"));
        this.errorTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.errorTextArea.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.buttomPanel.add((Component)this.errorScrollPane, gridBagConstraints);
        this.btRestore.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_RestoreDefault_BT").charAt(0));
        this.btRestore.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btRestore.text"));
        this.btRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsPanel.this.btRestoreActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 6, 0, 7);
        this.buttomPanel.add((Component)this.btRestore, gridBagConstraints);
        this.btRestore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btRestore.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.buttomPanel, gridBagConstraints);
        this.ToolSetPanel.setLayout(new GridBagLayout());
        this.spDirlist.setMinimumSize(new Dimension(180, 20));
        this.spDirlist.setPreferredSize(new Dimension(180, 20));
        this.lstDirlist.setSelectionMode(0);
        this.lstDirlist.setAutoscrolls(false);
        this.lstDirlist.addListSelectionListener(this);
        this.spDirlist.setViewportView(this.lstDirlist);
        this.lstDirlist.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lstDirlist.AccessibleContext.accessibleName"));
        this.lstDirlist.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lstDirlist.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.ToolSetPanel.add((Component)this.spDirlist, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.btAdd.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_AddButton").charAt(0));
        this.btAdd.setText(resourceBundle.getString("LBL_AddButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.btAdd, gridBagConstraints);
        this.btAdd.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_AddButton"));
        this.btAdd.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_AddButton"));
        this.btRemove.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_RemoveButton").charAt(0));
        this.btRemove.setText(resourceBundle.getString("LBL_RemoveButton"));
        this.btRemove.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.btRemove, gridBagConstraints);
        this.btRemove.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_RemoveButton"));
        this.btRemove.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_RemoveButton"));
        this.duplicateButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_UpButton").charAt(0));
        this.duplicateButton.setText(resourceBundle.getString("LBL_UpButton"));
        this.duplicateButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.buttonPanel.add((Component)this.duplicateButton, gridBagConstraints);
        this.duplicateButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_UpButton"));
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_UpButton"));
        this.btDown.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_DownButton").charAt(0));
        this.btDown.setText(resourceBundle.getString("LBL_DownButton"));
        this.btDown.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.buttonPanel.add((Component)this.btDown, gridBagConstraints);
        this.btDown.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_DownButton"));
        this.btDown.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_DownButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.ToolSetPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.ToolSetPanel, gridBagConstraints);
        this.cbFamily.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.cbFamily, gridBagConstraints);
    }

    private void btVersionsActionPerformed(ActionEvent actionEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append(this.getToolVersion(this.currentCompilerSet.findTool(Tool.CCompiler), this.tfCPath) + "\n");
        stringBuilder.append(this.getToolVersion(this.currentCompilerSet.findTool(Tool.CCCompiler), this.tfCppPath) + "\n");
        stringBuilder.append(this.getToolVersion(this.currentCompilerSet.findTool(Tool.FortranCompiler), this.tfFortranPath) + "\n");
        stringBuilder.append(this.getToolVersion(this.currentCompilerSet.findTool(Tool.MakeTool), this.tfMakePath) + "\n");
        if (this.gdbEnabled) {
            stringBuilder.append(this.getToolVersion(this.currentCompilerSet.findTool(Tool.DebuggerTool), this.tfGdbPath) + "\n");
        }
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)stringBuilder.toString());
        message.setTitle(NbBundle.getMessage(VersionCommand.class, (String)"LBL_VersionInfo_Title"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private void btBaseDirectoryActionPerformed(ActionEvent actionEvent) {
        String string = null;
        string = this.tfBaseDirectory.getText().length() > 0 ? this.tfBaseDirectory.getText() : (FileChooser.getCurrectChooserFile() != null ? FileChooser.getCurrectChooserFile().getPath() : System.getProperty("user.home"));
        FileChooser fileChooser = new FileChooser(ToolsPanel.getString("SELECT_BASE_DIRECTORY_TITLE"), null, 1, null, string, true);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return;
        }
        String string2 = fileChooser.getSelectedFile().getPath();
        this.tfBaseDirectory.setText(string2);
        CompilerSet compilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        CompilerSet.CompilerFlavor compilerFlavor = (CompilerSet.CompilerFlavor)((Object)this.cbFamily.getSelectedItem());
        this.csm.reInitCompilerSet(compilerSet, string2);
        this.changed = true;
        this.update(false);
    }

    private boolean selectCompiler(JTextField jTextField, Tool tool) {
        String string = this.tfBaseDirectory.getText();
        FileChooser fileChooser = new FileChooser(ToolsPanel.getString("SELECT_TOOL_TITLE"), null, 0, null, string, false);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return false;
        }
        if (!new File(new File(this.tfBaseDirectory.getText()), fileChooser.getSelectedFile().getName()).exists()) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)ToolsPanel.getString("COMPILER_BASE_ERROR"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return false;
        }
        jTextField.setText(fileChooser.getSelectedFile().getPath());
        tool.setPath(jTextField.getText());
        this.fireCompilerSetChange();
        this.fireCompilerSetModified();
        return true;
    }

    private boolean selectTool(JTextField jTextField) {
        String string = this.tfBaseDirectory.getText();
        FileChooser fileChooser = new FileChooser(ToolsPanel.getString("SELECT_TOOL_TITLE"), null, 0, null, string, false);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return false;
        }
        jTextField.setText(fileChooser.getSelectedFile().getPath());
        return true;
    }

    private void btCVersionActionPerformed(ActionEvent actionEvent) {
        this.selectCompiler(this.tfCPath, this.currentCompilerSet.getTool(Tool.CCompiler));
    }

    private void btCppVersionActionPerformed(ActionEvent actionEvent) {
        this.selectCompiler(this.tfCppPath, this.currentCompilerSet.getTool(Tool.CCCompiler));
    }

    private void btFortranVersionActionPerformed(ActionEvent actionEvent) {
        this.selectCompiler(this.tfFortranPath, this.currentCompilerSet.getTool(Tool.FortranCompiler));
    }

    private void btMakeVersionActionPerformed(ActionEvent actionEvent) {
        this.selectTool(this.tfMakePath);
    }

    private void btGdbVersionActionPerformed(ActionEvent actionEvent) {
        this.selectTool(this.tfGdbPath);
    }

    private void btRestoreActionPerformed(ActionEvent actionEvent) {
        Object object;
        String string;
        CompilerSet compilerSet2;
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)ToolsPanel.getString("RESTORE_TXT"), ToolsPanel.getString("RESTORE_TITLE"), 2);
        Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (object2 != NotifyDescriptor.OK_OPTION) {
            return;
        }
        CompilerSetManager compilerSetManager = new CompilerSetManager();
        if (compilerSetManager.getCompilerSets().size() == 1 && compilerSetManager.getCompilerSets().get(0).getName() == "None") {
            compilerSetManager.remove(compilerSetManager.getCompilerSets().get(0));
        }
        List<CompilerSet> list = this.csm.getCompilerSets();
        for (CompilerSet compilerSet2 : list) {
            if (compilerSet2.isAutoGenerated()) continue;
            string = compilerSet2.getName();
            if (!string.equals(object = compilerSetManager.getUniqueCompilerSetName(string))) {
                compilerSet2.setName((String)object);
            }
            compilerSetManager.add(compilerSet2);
        }
        Object object3 = null;
        compilerSet2 = this.csm.getDefaultCompilerSet();
        if (compilerSet2 != null) {
            object3 = compilerSet2.getName();
        }
        string = null;
        object = (CompilerSet)this.lstDirlist.getSelectedValue();
        if (object != null) {
            string = ((CompilerSet)object).getName();
        }
        this.csm = compilerSetManager;
        CompilerSet compilerSet3 = this.csm.getCompilerSet((String)object3);
        if (compilerSet3 != null) {
            this.csm.setDefault(compilerSet3);
        }
        if (string != null) {
            object = this.csm.getCompilerSet(string);
        }
        this.changed = true;
        if (object != null) {
            this.update(false, (CompilerSet)object);
        } else {
            this.update(false);
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ToolsPanel.class, (String)string);
    }

    private static class NameOnlyDocument
    extends PlainDocument {
        private NameOnlyDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string.indexOf("/") == -1) {
                super.insertString(n, string, attributeSet);
            }
        }
    }

    class MyCellRenderer
    extends DefaultListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            CompilerSet compilerSet = (CompilerSet)object;
            if (compilerSet.isDefault()) {
                JLabel jLabel = (JLabel)component;
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            return component;
        }
    }
}

