/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.makewizard.EnterItemsPanel;
import org.netbeans.modules.cnd.makewizard.MakeVarName;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.StdLibFlags;
import org.netbeans.modules.cnd.makewizard.TargetData;
import org.openide.util.NbBundle;

public class UserLibsPanel
extends EnterItemsPanel {
    static final long serialVersionUID = 3971722083122307369L;
    private int key;
    private boolean initialized;
    private JPanel stdLibPanel = null;
    private JTextField stdLibsText;
    private JLabel stdLibsLabel = null;
    private boolean stdLibPanelAdded = false;

    UserLibsPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = new String(this.getString("LBL_UserLibsPanel"));
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
    }

    private void create() {
        this.create(this.getString("LBL_UserLibs"), this.getString("MNEM_UserLibs").charAt(0), 72);
        this.stdLibPanel = new JPanel();
        this.stdLibPanel.setLayout(new GridBagLayout());
        this.stdLibsLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.stdLibPanel.add((Component)this.stdLibsLabel, gridBagConstraints);
        this.stdLibsText = new JTextField();
        this.stdLibsLabel.setLabelFor(this.stdLibsText);
        this.stdLibsText.setEditable(false);
        this.stdLibsText.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.stdLibPanel.add((Component)this.stdLibsText, gridBagConstraints);
    }

    private void addStdLibPanel() {
        if (!this.stdLibPanelAdded) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets.top = 11;
            this.addComponent(this.stdLibPanel, gridBagConstraints);
            this.stdLibPanelAdded = true;
        }
    }

    private void removeStdLibPanel() {
        if (this.stdLibPanelAdded) {
            this.remove(this.stdLibPanel);
            this.stdLibPanelAdded = false;
        }
    }

    protected String getListLabel() {
        return this.getString("LBL_LibraryList");
    }

    protected char getListMnemonic() {
        return this.getString("MNEM_LibraryList").charAt(0);
    }

    protected String validateInput(String string) {
        if (string.charAt(0) == '-') {
            char c = string.charAt(1);
            if (c == 'L' || c == 'l' || c == 'B') {
                return string;
            }
            return null;
        }
        return string;
    }

    protected boolean checkErrorConditions(int n, LinkedList linkedList, boolean bl) {
        return n == 1 && linkedList.size() == 0;
    }

    protected EnterItemsPanel.ErrorInfo getErrorInfo() {
        return new EnterItemsPanel.ErrorInfo(this.getString("DLG_ULP_EmptyRE"), this.getString("MSG_NoFilesMatched"));
    }

    protected void addMultipleFiles(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            EnterItemsPanel.ListItem listItem;
            String string;
            if (!(objectArray[i] instanceof EnterItemsPanel.ListItem) || (string = (listItem = (EnterItemsPanel.ListItem)objectArray[i]).getName()).length() == 0 || string.charAt(0) == '-' || string.charAt(0) == '$' || string.indexOf(File.separator) >= 0 || string.endsWith(".a") || string.endsWith(".so") || string.endsWith(".dylib") || string.endsWith(".dll")) continue;
            listItem.setName("-l" + string);
        }
        super.addMultipleFiles(objectArray);
    }

    public void addNotify() {
        String[] stringArray;
        Object object;
        TargetData targetData = this.getMakefileData().getCurrentTarget();
        int n = targetData.getTargetType();
        this.key = targetData.getKey();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        if (n == 5) {
            // empty if block
        }
        if (n == 5) {
            object = new MakeVarName();
            ((MakeVarName)object).setTargetName(targetData.getName());
            stringArray = ((MakeVarName)object).makeRef("SYSLIBS_");
            if (targetData.getUserLibsList() == null) {
                targetData.setUserLibsList(new String[]{stringArray});
            }
            StdLibFlags stdLibFlags = targetData.getStdLibFlags();
            int n2 = this.getMakefileData().getMakefileOS();
            int n3 = this.getMakefileData().getToolset();
            String string = stdLibFlags.getSysLibFlags(n3, n2, this.getMakefileData().getCompilerFlags().is64Bit(), targetData);
            this.stdLibsText.setText(string);
            this.stdLibsText.setToolTipText(string);
            String string2 = NbBundle.getMessage(UserLibsPanel.class, (String)"LBL_SYSLIB", (Object)stringArray);
            this.stdLibsLabel.setText(string2);
            this.addStdLibPanel();
        } else {
            this.removeStdLibPanel();
        }
        object = (DefaultListModel)this.getList().getModel();
        ((DefaultListModel)object).removeAllElements();
        stringArray = targetData.getUserLibsList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                ((DefaultListModel)object).addElement(stringArray[i]);
            }
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        TargetData targetData = this.getMakefileData().getTarget(this.key);
        targetData.setUserLibsList(this.getListItems());
    }
}

