/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.ItemChooser;
import org.netbeans.modules.cnd.makewizard.MakefileData;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.TargetData;

public class TargetNamePanel
extends ItemChooser {
    private String label;
    private char mnemonic;
    private String tname;
    static final long serialVersionUID = 6653452210904639697L;
    private boolean initialized = false;

    TargetNamePanel(MakefileWizard makefileWizard) {
        super(makefileWizard, true);
        String string = this.getString("TITLE_TargetName");
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
    }

    public void validateData(ArrayList arrayList, int n) {
        TargetData targetData = this.getMakefileData().getTarget(n);
        String string = this.getMakefileData().getBaseDirectory(true);
        File file = null;
        File file2 = null;
        File file3 = null;
        String string2 = IpeUtils.expandPath(targetData.getName());
        String string3 = IpeUtils.expandPath(targetData.getOutputDirectory());
        if (string2.length() > 0) {
            File file4 = string2.startsWith(File.separator) ? new File(string2) : new File(string, string2);
            file = file4.getParentFile();
        }
        if (string3.length() > 0 && !string3.equals(string) && !string3.equals(string2)) {
            file2 = string3.startsWith(File.separator) ? new File(string3) : new File(string, string3);
            file3 = file2.getParentFile();
        }
        if (file != null && !file.getPath().equals(string) && file.exists() && !file.canWrite()) {
            this.warn(arrayList, WARN_BINDIR_NOT_WRITABLE, file.getPath(), string2);
        }
        if (file2 != null && !file2.equals(file)) {
            if (!file2.exists()) {
                if (file3 == null || !file3.canWrite()) {
                    this.warn(arrayList, WARN_CANNOT_CREATE_OUTPUT_DIR, file2.getPath());
                }
            } else if (!file2.canWrite()) {
                this.warn(arrayList, WARN_CANNOT_WRITE_TO_OUTPUT_DIR, file2.getPath());
            }
        }
    }

    private TargetData convertOrCreate(int n, ArrayList arrayList) {
        TargetData targetData = (TargetData)arrayList.get(0);
        if (targetData.getTargetType() != n) {
            for (int i = 0; i < arrayList.size(); ++i) {
                targetData = (TargetData)arrayList.get(i);
                if (!targetData.isConvertable(n)) continue;
                targetData.convert(n);
                if (i > 0) {
                    while (i > 0) {
                        arrayList.set(i, arrayList.get(i - 1));
                        --i;
                    }
                    arrayList.set(0, targetData);
                }
                this.setup(this.getMakefileData(), n, true);
                return targetData;
            }
            arrayList.add(1, arrayList.get(0));
            targetData = this.createTarget(n);
            arrayList.add(0, targetData);
        }
        return targetData;
    }

    private void setup(MakefileData makefileData, int n, boolean bl) {
        if (n == 1) {
            this.label = this.getString("LBL_ExecutableName");
            this.mnemonic = this.getString("MNEM_ExecutableName").charAt(0);
            this.tname = this.getString("DFLT_ExecutableName");
        } else if (n == 2) {
            this.label = this.getString("LBL_ArchiveName");
            this.mnemonic = this.getString("MNEM_ArchiveName").charAt(0);
            this.tname = this.getString("DFLT_ArchiveName");
        } else if (n == 3) {
            String string = makefileData.getMakefileOS() == 3 ? ".dll" : (makefileData.getMakefileOS() == 4 ? ".dylib" : ".so");
            this.label = this.getString("LBL_ShobjName");
            this.mnemonic = this.getString("MNEM_ShobjName").charAt(0);
            this.tname = this.getString("DFLT_ShobjName") + string;
        } else {
            throw new IllegalStateException();
        }
        if (bl) {
            this.getNameLabel().setText(this.label);
            this.getNameLabel().setDisplayedMnemonic(this.mnemonic);
        }
    }

    private TargetData createTarget(int n) {
        this.setup(this.getMakefileData(), n, true);
        String string = this.getMakefileData().defaultOutputDirectory();
        return new TargetData(n, this.tname, string, 0);
    }

    public void addNotify() {
        Object object;
        TargetData targetData;
        int n = this.getMakefileData().getMakefileType();
        if (!this.initialized) {
            this.setup(this.getMakefileData(), n, false);
            this.create(this.getString("LBL_TargetDirectory"), this.getString("MNEM_TargetDirectory").charAt(0), this.label, this.mnemonic);
            targetData = this.createTarget(n);
            targetData.setTargetName(this.tname);
            this.getMakefileData().getTargetList().add(targetData);
            this.initialized = true;
        } else {
            object = this.getMakefileData().getTargetList();
            targetData = (TargetData)((ArrayList)object).get(0);
            if (targetData.getTargetType() != n) {
                targetData = this.convertOrCreate(n, (ArrayList)object);
            }
        }
        MakefileWizard.getMakefileWizard().initDirPaths();
        MakefileWizard.getMakefileWizard().initMakefileName();
        object = targetData.getOutputDirectory();
        this.getText().setText(targetData.getTargetName());
        int n2 = ((String)object).lastIndexOf(47);
        if (n2 == -1) {
            this.getDirText().setText(this.getMakefileData().getBaseDirectory() + File.separator + targetData.getOutputDirectory());
        } else {
            this.getDirText().setText((String)object);
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        MakefileData makefileData = this.getMakefileData();
        TargetData targetData = (TargetData)makefileData.getTargetList().get(0);
        String string = this.getText().getText();
        String string2 = this.getDirText().getText();
        String string3 = makefileData.getBaseDirectory();
        try {
            if (string2.startsWith(string3) && (string2.length() == string3.length() || string2.charAt(string3.length()) == '/')) {
                if (!string2.substring(string3.length() + 1).equals(targetData.getOutputDirectory())) {
                    targetData.setOutputDirectory(string2.substring(string3.length() + 1));
                }
            } else {
                targetData.setOutputDirectory(string2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            targetData.setOutputDirectory(string2);
        }
        if (!string.equals(targetData.getTargetName())) {
            targetData.setTargetName(string);
            targetData.setName(string);
        }
    }
}

