/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.CompilerFlags;
import org.netbeans.modules.cnd.makewizard.MakefileData;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makewizard.OptionSource;
import org.netbeans.modules.cnd.makewizard.TargetData;
import org.openide.util.NbBundle;

public class MakefileReviewPanel
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = 6675031915575184904L;
    private JLabel reviewLabel;
    private JTextArea reviewText;
    private JScrollPane reviewSP;
    private String finishLabel;
    private int finishMnemonic;
    private StringBuffer summary;
    private boolean initialized;
    private boolean enableTextSelection = false;
    ActionListener finishButtonListener = null;

    MakefileReviewPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = new String(this.getString("LBL_MakefileReviewPanel"));
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string + this.getString("ACSD_MakefileReview"));
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new GridBagLayout());
        this.reviewLabel = new JLabel();
        this.reviewLabel.setText(NbBundle.getMessage(MakefileReviewPanel.class, (String)"LBL_Summary"));
        this.reviewLabel.setDisplayedMnemonic(NbBundle.getMessage(MakefileReviewPanel.class, (String)"MNEM_Summary").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.reviewLabel, gridBagConstraints);
        this.reviewText = new JTextArea();
        this.reviewText.setEditable(false);
        this.reviewText.getCaret().setVisible(false);
        this.reviewText.getCaret().setSelectionVisible(false);
        this.reviewText.setBackground(this.getBackground());
        this.reviewText.addFocusListener(this);
        this.reviewLabel.setLabelFor(this.reviewText);
        this.reviewSP = new JScrollPane(this.reviewText);
        this.reviewSP.getViewport().setBackground(this.reviewText.getBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.reviewSP, gridBagConstraints);
        if (IpeUtils.IfdefDiagnostics) {
            this.reviewText.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getModifiers();
                    if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 80) {
                        MakefileReviewPanel.this.getMakefileData().dump();
                    }
                }
            });
        }
    }

    private String getSummaryString() {
        MakefileData makefileData = this.getMakefileData();
        String string = makefileData.getBaseDirectory(true);
        String string2 = makefileData.getMakefileName();
        String string3 = this.getMakefileDirectory(string, string2);
        String string4 = this.getMakefileName(string2);
        this.summary = new StringBuffer(1024);
        this.append("LBL_MakefileSummaryDir", string3);
        this.append("LBL_MakefileSummaryName", string4);
        this.append("LBL_BuildInstructions");
        this.append("LBL_BuildInstruction1", string4, string3);
        this.append("LBL_BuildInstruction2", string4);
        this.append("LBL_MakefileSpecifics");
        if (makefileData.getTargetList().size() == 1 || makefileData.getMakefileType() < 4) {
            TargetData targetData = (TargetData)makefileData.getTargetList().get(0);
            if (targetData.isExecutable()) {
                this.append("LBL_SingleExe", targetData.getName());
            } else if (targetData.isArchive()) {
                this.append("LBL_SingleArchive", targetData.getName());
            } else if (targetData.isSharedLib()) {
                this.append("LBL_SingleSharedLib", targetData.getName());
            } else if (targetData.isMakeTarget()) {
                this.append("LBL_SingleMake", targetData.getName());
            } else if (targetData.isCustomTarget()) {
                this.append("LBL_SingleCustom", targetData.getName());
            } else if (IpeUtils.IfdefDiagnostics) {
                System.out.println("Error: Unknown target type in summary");
            }
            if (targetData.getSourcesList() == null) {
                this.append("LBL_SingleTargetSrcs", new Integer(0));
            } else if (targetData.getSourcesList().length == 1) {
                this.append("LBL_SingleTargetSrcs1");
            } else {
                this.append("LBL_SingleTargetSrcs", new Integer(targetData.getSourcesList().length));
            }
        } else {
            ArrayList arrayList = makefileData.getTargetList();
            this.append("LBL_MultiTarget");
            for (int i = 0; i < arrayList.size(); ++i) {
                TargetData targetData = (TargetData)arrayList.get(i);
                int n = targetData.getSourcesList() == null ? 0 : targetData.getSourcesList().length;
                if (targetData.isExecutable()) {
                    if (n == 1) {
                        this.append("LBL_MultiExe1", targetData.getName());
                        continue;
                    }
                    this.append("LBL_MultiExe", targetData.getName(), new Integer(n));
                    continue;
                }
                if (targetData.isArchive()) {
                    if (n == 1) {
                        this.append("LBL_MultiArchive1", targetData.getName());
                        continue;
                    }
                    this.append("LBL_MultiArchive", targetData.getName(), new Integer(n));
                    continue;
                }
                if (targetData.isSharedLib()) {
                    if (n == 1) {
                        this.append("LBL_MultiSharedLib1", targetData.getName());
                        continue;
                    }
                    this.append("LBL_MultiSharedLib", targetData.getName(), new Integer(n));
                    continue;
                }
                if (targetData.isMakeTarget()) {
                    this.append("LBL_MultiMake", targetData.getName());
                    continue;
                }
                if (targetData.isCustomTarget()) {
                    if (n == 1) {
                        this.append("LBL_MultiCustom1", targetData.getName());
                        continue;
                    }
                    this.append("LBL_MultiCustom", targetData.getName(), new Integer(n));
                    continue;
                }
                if (!IpeUtils.IfdefDiagnostics) continue;
                System.out.println("Error: Unknown target type in summary");
            }
        }
        if (this.isDebug() && !this.isOptimize()) {
            this.append("LBL_DebugCompile");
        } else if (this.isDebug() && this.isOptimize()) {
            this.append("LBL_DebugOptCompile");
        } else if (this.isOptimize()) {
            this.append("LBL_OptimizeCompile");
        } else if (IpeUtils.IfdefDiagnostics) {
            this.append("LBL_NoOptDebugCompile");
        }
        this.validateAllData();
        this.append("LBL_Finish");
        return this.summary.toString();
    }

    private String getMakefileDirectory(String string, String string2) {
        String string3;
        if (string2.charAt(0) != File.separatorChar) {
            string2 = string + File.separator + string2;
        }
        File file = new File(string2);
        try {
            string3 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return string2.substring(0, string2.lastIndexOf(File.separator) - 1);
        }
        return string3.substring(0, string3.lastIndexOf(File.separator));
    }

    private String getMakefileName(String string) {
        int n = string.lastIndexOf(File.separator);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    private boolean isDebug() {
        MakefileData makefileData = this.getMakefileData();
        CompilerFlags compilerFlags = makefileData.getCompilerFlags();
        if (makefileData.getMakefileType() < 4) {
            return compilerFlags.isSimpleDebug();
        }
        return compilerFlags.getOptionSource() == OptionSource.DEVELOPMENT;
    }

    private boolean isOptimize() {
        MakefileData makefileData = this.getMakefileData();
        CompilerFlags compilerFlags = makefileData.getCompilerFlags();
        if (makefileData.getMakefileType() < 4) {
            return compilerFlags.isSimpleOptimize();
        }
        if (compilerFlags.getOptionSource() == OptionSource.FINAL) {
            return compilerFlags.isFinalOptimize();
        }
        if (compilerFlags.getOptionSource() == OptionSource.DEVELOPMENT) {
            return !compilerFlags.isDevelDebug();
        }
        return false;
    }

    private void validateAllData() {
        ArrayList arrayList = MakefileWizard.getMakefileWizard().validateAllData();
        this.append("LBL_Warnings");
        if (arrayList.size() == 0) {
            this.append("LBL_NoWarnings");
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.append(arrayList.get(i));
            }
        }
    }

    public void addNotify() {
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        super.addNotify();
        this.reviewText.setText(this.getSummaryString());
        this.reviewText.setCaretPosition(0);
        MakefileWizard makefileWizard = MakefileWizard.getMakefileWizard();
        makefileWizard.getNextButton().setEnabled(false);
        makefileWizard.setFinishEnabled(true);
        JButton jButton = makefileWizard.getFinishButton();
        this.finishLabel = jButton.getText();
        this.finishMnemonic = jButton.getMnemonic();
        jButton.setText(makefileWizard.getFinishLabel());
        jButton.setMnemonic(makefileWizard.getFinishMnemonic());
        jButton.setEnabled(true);
        this.getRootPane().setDefaultButton(jButton);
        IpeUtils.requestFocus(jButton);
        this.enableTextSelection = false;
        if (this.finishButtonListener == null) {
            this.finishButtonListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MakefileReviewPanel.this.finishButtonListenerActionPerformed();
                }
            };
        }
        jButton.addActionListener(this.finishButtonListener);
    }

    public void removeNotify() {
        super.removeNotify();
        JButton jButton = MakefileWizard.getMakefileWizard().getFinishButton();
        jButton.setText(this.finishLabel);
        jButton.setMnemonic(this.finishMnemonic);
        this.getRootPane().setDefaultButton(MakefileWizard.getMakefileWizard().getNextButton());
        jButton.removeActionListener(this.finishButtonListener);
    }

    public void finishButtonListenerActionPerformed() {
        MakefileWizard makefileWizard = MakefileWizard.getMakefileWizard();
        makefileWizard.setFinishClosingEnabled(true);
    }

    private void append(Object object) {
        this.summary.append(object.toString());
    }

    private void append(String string) {
        this.summary.append(NbBundle.getBundle(MakefileReviewPanel.class).getString(string));
    }

    private void append(String string, Object object) {
        if (object instanceof Integer && (Integer)object == 1) {
            string = string + "1";
        }
        this.summary.append(NbBundle.getMessage(MakefileReviewPanel.class, (String)string, (Object)object));
    }

    private void append(String string, Object object, Object object2) {
        if (object2 instanceof Integer && (Integer)object2 == 1) {
            string = string + "1";
        }
        this.summary.append(NbBundle.getMessage(MakefileReviewPanel.class, (String)string, (Object)object, (Object)object2));
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

