/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.Format;
import org.netbeans.modules.cnd.loaders.CndAbstractDataLoader;
import org.netbeans.modules.cnd.loaders.ShellDataObject;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class ShellDataLoader
extends CndAbstractDataLoader {
    private static ShellDataLoader instance = null;
    static final long serialVersionUID = -7173746465817543299L;
    private static final String[] shellExtensions = new String[]{"bash", "csh", "ksh", "sh", "zsh", "bat", "cmd"};

    public ShellDataLoader() {
        super("org.netbeans.modules.cnd.loaders.ShellDataObject");
        instance = this;
        this.createExtentions(shellExtensions);
    }

    public static ShellDataLoader getInstance() {
        if (instance == null) {
            instance = (ShellDataLoader)SharedClassObject.findObject(ShellDataLoader.class, (boolean)true);
        }
        return instance;
    }

    protected String actionsContext() {
        return "Loaders/text/sh/Actions/";
    }

    protected String getMimeType() {
        return "text/sh";
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(ShellDataLoader.class, (String)"PROP_ShellDataLoader_Name");
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new ShellDataObject(fileObject, (MultiFileLoader)this);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new ShellFormat(multiDataObject, fileObject);
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        if (this.getExtensions().isRegistered(fileObject)) {
            return fileObject;
        }
        String string = fileObject.getMIMEType();
        if (string != null && string.equals("text/sh")) {
            return fileObject;
        }
        return null;
    }

    private static class ShellFormat
    extends CndAbstractDataLoader.CndFormat {
        public ShellFormat(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            String string2 = this.getFile().getExt();
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)string2);
            }
            FileObject fileObject2 = fileObject.createData(string, string2);
            Format format = this.createFormat(fileObject, string, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getFile().getInputStream()));
            try {
                FileLock fileLock = fileObject2.lock();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream(fileLock)));
                    try {
                        String string3;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            bufferedWriter.write(format.format(string3));
                            bufferedWriter.write("\n");
                        }
                    }
                    finally {
                        bufferedWriter.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
            finally {
                bufferedReader.close();
            }
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            this.setTemplate(fileObject2);
            return fileObject2;
        }

        private void setTemplate(FileObject fileObject) throws IOException {
            Object object = fileObject.getAttribute("template");
            if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                fileObject.setAttribute("template", null);
            }
        }
    }
}

