/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.builds;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.builds.ErrorExpression;
import org.netbeans.modules.cnd.builds.ErrorExpressionEditor;
import org.netbeans.modules.cnd.settings.MakeSettings;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class ErrorExpressionPanel
extends JPanel {
    private ErrorExpressionEditor editor;
    static final long serialVersionUID = -2763818133650482979L;
    private JPanel descriptionPanel;
    private JPanel buttonsPanel;
    private JScrollPane presetsScroll;
    private JLabel presetNameLabel;
    private JTextField presetNameField;
    private JLabel errorDescriptionLabel;
    private JTextField errorDescriptionField;
    private JLabel filePositionLabel;
    private JTextField filePositionField;
    private JLabel linePositionLabel;
    private JTextField linePositionField;
    private JLabel columnPositionLabel;
    private JTextField columnPositionField;
    private JLabel descriptionPositionLabel;
    private JTextField descriptionPositionField;
    private JButton addButton;
    private JButton removeButton;
    private JButton changeButton;
    private JList errorDescriptions;
    private ErrorExpression descriptions;
    private boolean internalListChange = false;

    public ErrorExpressionPanel(ErrorExpressionEditor errorExpressionEditor) {
        this.editor = errorExpressionEditor;
        this.descriptions = (ErrorExpression)errorExpressionEditor.getValue();
        this.initComponents();
        this.setBorder(new CompoundBorder(new EmptyBorder(new Insets(2, 2, 2, 2)), new TitledBorder(new EtchedBorder(), ErrorExpressionPanel.getString("CTL_Error_description_name"))));
        this.addButton.setText(ErrorExpressionPanel.getString("CTL_Add"));
        this.addButton.setToolTipText(ErrorExpressionPanel.getString("CTL_Add_tip"));
        this.removeButton.setText(ErrorExpressionPanel.getString("CTL_Remove"));
        this.removeButton.setToolTipText(ErrorExpressionPanel.getString("CTL_Remove_tip"));
        this.changeButton.setText(ErrorExpressionPanel.getString("CTL_Change"));
        this.changeButton.setToolTipText(ErrorExpressionPanel.getString("CTL_Change_tip"));
        this.presetNameLabel.setText(ErrorExpressionPanel.getString("CTL_Preset_label"));
        this.errorDescriptionLabel.setText(ErrorExpressionPanel.getString("CTL_Error_label"));
        this.filePositionLabel.setText(ErrorExpressionPanel.getString("CTL_File_label"));
        this.linePositionLabel.setText(ErrorExpressionPanel.getString("CTL_Line_label"));
        this.columnPositionLabel.setText(ErrorExpressionPanel.getString("CTL_Column_label"));
        this.descriptionPositionLabel.setText(ErrorExpressionPanel.getString("CTL_Description_label"));
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ErrorExpressionPanel.this.internalListChange) {
                    return;
                }
                int n = ErrorExpressionPanel.this.errorDescriptions.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                ErrorExpressionPanel.this.descriptions = ErrorExpressionPanel.this.editor.getExpressions()[n];
                ErrorExpressionPanel.this.updateFields();
                ErrorExpressionPanel.this.updateButtons();
            }
        };
        this.errorDescriptions.addListSelectionListener(listSelectionListener);
        this.updateList();
        this.updateFields();
        this.updateButtons();
        HelpCtx.setHelpIDString((JComponent)this, (String)ErrorExpressionPanel.class.getName());
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.descriptions;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        return dimension;
    }

    private void updateList() {
        ErrorExpression[] errorExpressionArray = this.editor.getExpressions();
        ErrorExpression errorExpression = this.descriptions;
        String[] stringArray = new String[errorExpressionArray.length];
        int n = -1;
        for (int i = 0; i < errorExpressionArray.length; ++i) {
            stringArray[i] = "";
        }
        this.internalListChange = true;
        this.errorDescriptions.setListData(stringArray);
        this.internalListChange = false;
        if (n != -1) {
            this.errorDescriptions.setSelectedIndex(n);
        }
    }

    private void updateFields() {
        ErrorExpression errorExpression = this.descriptions;
    }

    private void updateButtons() {
        boolean bl;
        boolean bl2 = bl = this.errorDescriptions.getSelectedIndex() != -1;
        if (bl) {
            bl = !this.isReadOnly(this.descriptions);
        }
        this.removeButton.setEnabled(bl);
        this.changeButton.setEnabled(bl);
        this.addButton.setEnabled(!"".equals(this.presetNameField.getText()));
    }

    private boolean isReadOnly(ErrorExpression errorExpression) {
        if (errorExpression.equals(MakeSettings.SUN_COMPILERS)) {
            return true;
        }
        return errorExpression.equals(MakeSettings.GNU_COMPILERS);
    }

    private void initComponents() {
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 0)));
        this.setLayout(new GridBagLayout());
        this.descriptionPanel = new JPanel();
        this.descriptionPanel.setLayout(new GridBagLayout());
        this.presetNameLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.descriptionPanel.add((Component)this.presetNameLabel, gridBagConstraints);
        this.presetNameField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.descriptionPanel.add((Component)this.presetNameField, gridBagConstraints);
        this.errorDescriptionLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.2;
        this.descriptionPanel.add((Component)this.errorDescriptionLabel, gridBagConstraints);
        this.errorDescriptionField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.descriptionPanel.add((Component)this.errorDescriptionField, gridBagConstraints);
        this.filePositionLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.2;
        this.descriptionPanel.add((Component)this.filePositionLabel, gridBagConstraints);
        this.filePositionField = new JTextField();
        this.filePositionField.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.insets = new Insets(2, 2, 2, 20);
        gridBagConstraints.anchor = 17;
        this.descriptionPanel.add((Component)this.filePositionField, gridBagConstraints);
        this.linePositionLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.2;
        this.descriptionPanel.add((Component)this.linePositionLabel, gridBagConstraints);
        this.linePositionField = new JTextField();
        this.linePositionField.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.insets = new Insets(2, 2, 2, 20);
        gridBagConstraints.anchor = 17;
        this.descriptionPanel.add((Component)this.linePositionField, gridBagConstraints);
        this.columnPositionLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.2;
        this.descriptionPanel.add((Component)this.columnPositionLabel, gridBagConstraints);
        this.columnPositionField = new JTextField();
        this.columnPositionField.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.insets = new Insets(2, 2, 2, 20);
        gridBagConstraints.anchor = 17;
        this.descriptionPanel.add((Component)this.columnPositionField, gridBagConstraints);
        this.descriptionPositionLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.2;
        this.descriptionPanel.add((Component)this.descriptionPositionLabel, gridBagConstraints);
        this.descriptionPositionField = new JTextField();
        this.descriptionPositionField.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.insets = new Insets(2, 2, 2, 20);
        gridBagConstraints.anchor = 17;
        this.descriptionPanel.add((Component)this.descriptionPositionField, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        this.add((Component)this.descriptionPanel, gridBagConstraints2);
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setBorder(new EmptyBorder(new Insets(0, 8, 0, 0)));
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.addButton = new JButton();
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorExpressionPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 5);
        gridBagConstraints3.anchor = 15;
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints3);
        this.removeButton = new JButton();
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorExpressionPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 5);
        gridBagConstraints3.anchor = 11;
        gridBagConstraints3.weighty = 1.0;
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints3);
        this.changeButton = new JButton();
        this.changeButton.setEnabled(false);
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorExpressionPanel.this.changeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 5);
        this.buttonsPanel.add((Component)this.changeButton, gridBagConstraints3);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        this.add((Component)this.buttonsPanel, gridBagConstraints2);
        this.presetsScroll = new JScrollPane();
        this.errorDescriptions = new JList();
        this.errorDescriptions.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ErrorExpressionPanel.this.errorDescriptionsMouseClicked(mouseEvent);
            }
        });
        this.presetsScroll.setViewportView(this.errorDescriptions);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.add((Component)this.presetsScroll, gridBagConstraints2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        ErrorExpressionEditor errorExpressionEditor = this.editor;
        synchronized (errorExpressionEditor) {
            Collection collection = this.editor.getExpressionsVector();
            int n = this.errorDescriptions.getSelectedIndex();
            collection.remove(this.descriptions);
            if (n >= collection.size()) {
                n = collection.size() - 1;
            }
            this.descriptions = n >= 0 ? this.editor.getExpressions()[n] : null;
            this.updateList();
        }
    }

    private void changeButtonActionPerformed(ActionEvent actionEvent) {
        if ("".equals(this.presetNameField.getText())) {
            return;
        }
        ErrorExpression errorExpression = this.descriptions;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            n = Integer.parseInt(this.filePositionField.getText());
            n2 = Integer.parseInt(this.linePositionField.getText());
            n3 = Integer.parseInt(this.columnPositionField.getText());
            n4 = Integer.parseInt(this.descriptionPositionField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        this.updateList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addButtonActionPerformed(ActionEvent actionEvent) {
        if ("".equals(this.presetNameField.getText())) {
            return;
        }
        ErrorExpression[] errorExpressionArray = this.editor.getExpressions();
        ErrorExpression errorExpression = null;
        try {
            errorExpression = new ErrorExpression(this.presetNameField.getText(), this.errorDescriptionField.getText(), Integer.parseInt(this.filePositionField.getText()), Integer.parseInt(this.linePositionField.getText()), Integer.parseInt(this.columnPositionField.getText()), Integer.parseInt(this.descriptionPositionField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        ErrorExpressionEditor errorExpressionEditor = this.editor;
        synchronized (errorExpressionEditor) {
            Collection collection = this.editor.getExpressionsVector();
            int n = this.errorDescriptions.getSelectedIndex();
            collection.add(errorExpression);
            this.descriptions = errorExpression;
            this.updateList();
        }
    }

    private void errorDescriptionsMouseClicked(MouseEvent mouseEvent) {
    }

    private static String getString(String string) {
        return NbBundle.getBundle(ErrorExpressionPanel.class).getString(string);
    }
}

