/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.utils.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppUtils {
    private static String cygwinBase;
    private static String mingwBase;
    private static String msysBase;

    public static String reformatWhitespaces(String string) {
        return CppUtils.reformatWhitespaces(string, "");
    }

    public static String reformatWhitespaces(String string, String string2) {
        return CppUtils.reformatWhitespaces(string, string2, "");
    }

    public static String reformatWhitespaces(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return string;
        }
        boolean bl = true;
        ArrayList<String> arrayList = CppUtils.tokenizeString(string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (String string4 : arrayList) {
            if (!bl) {
                stringBuilder.append(string3);
                stringBuilder.append(" ");
            }
            stringBuilder.append(string2);
            stringBuilder.append(string4);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static ArrayList<String> tokenizeString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(0);
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        char c = '\u0000';
        for (int i = 0; i <= string.length(); ++i) {
            boolean bl3;
            boolean bl4 = bl3 = i == string.length();
            if (bl3 || bl) {
                if (!bl3 && bl2) {
                    stringBuilder.append(string.charAt(i));
                    if (string.charAt(i) != c) continue;
                    bl2 = false;
                    continue;
                }
                if (bl3 || Character.isWhitespace(string.charAt(i))) {
                    if (stringBuilder.length() > 0) {
                        arrayList.add(stringBuilder.toString());
                    }
                    bl = false;
                    stringBuilder = new StringBuilder();
                    continue;
                }
                stringBuilder.append(string.charAt(i));
                if (string.charAt(i) != '\"' && string.charAt(i) != '`' && string.charAt(i) != '\'') continue;
                bl2 = true;
                c = string.charAt(i);
                continue;
            }
            if (Character.isWhitespace(string.charAt(i))) continue;
            stringBuilder.append(string.charAt(i));
            bl = true;
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public static String getCygwinBase() {
        if (cygwinBase == null) {
            File file = new File("C:/Windows/System32/reg.exe");
            if (file.exists()) {
                Iterator<String> iterator = new ArrayList<String>();
                iterator.add(file.getAbsolutePath());
                iterator.add("query");
                iterator.add("hklm\\software\\cygnus solutions\\cygwin\\mounts v2\\/");
                ProcessBuilder object = new ProcessBuilder((List<String>)((Object)iterator));
                object.redirectErrorStream(true);
                try {
                    String string;
                    Process process = object.start();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        int n;
                        if (!(string = string.trim()).startsWith("native") || (n = string.lastIndexOf(9)) == -1 || n >= string.length()) continue;
                        cygwinBase = string.substring(n + 1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (cygwinBase == null) {
                for (String string : Path.getPath()) {
                    if (!string.toLowerCase().contains("cygwin")) continue;
                    if (string.toLowerCase().endsWith("\\usr\\bin")) {
                        cygwinBase = string.substring(0, string.length() - 8);
                        break;
                    }
                    if (!string.toLowerCase().endsWith("\\bin")) continue;
                    cygwinBase = string.substring(0, string.length() - 4);
                    break;
                }
            }
            if (cygwinBase == null) {
                for (String string : Path.getPath()) {
                    if (!string.toLowerCase().endsWith("\\cygwin\\bin")) continue;
                    cygwinBase = string.substring(0, string.length() - 4);
                    break;
                }
            }
        }
        return cygwinBase;
    }

    public static String getMinGWBase() {
        if (mingwBase == null) {
            File file = new File("C:/Windows/System32/reg.exe");
            if (file.exists()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(file.getAbsolutePath());
                arrayList.add("query");
                arrayList.add("hklm\\software\\microsoft\\windows\\currentversion\\uninstall\\MinGW");
                ProcessBuilder object = new ProcessBuilder((List<String>)arrayList);
                object.redirectErrorStream(true);
                try {
                    String string;
                    Process process = object.start();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        int n;
                        if (!(string = string.trim()).startsWith("InstallLocation") || (n = string.lastIndexOf(9)) == -1 || n >= string.length()) continue;
                        mingwBase = string.substring(n + 1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (mingwBase == null) {
                for (String string : Path.getPath()) {
                    if (!string.toLowerCase().endsWith("\\mingw\\bin")) continue;
                    mingwBase = string.substring(0, string.length() - 4);
                    break;
                }
            }
        }
        return mingwBase;
    }

    public static String getMSysBase() {
        if (msysBase == null) {
            File file = new File("C:/Windows/System32/reg.exe");
            if (file.exists()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(file.getAbsolutePath());
                arrayList.add("query");
                arrayList.add("hklm\\software\\microsoft\\windows\\currentversion\\uninstall\\msys-1.0_is1");
                ProcessBuilder object = new ProcessBuilder((List<String>)arrayList);
                object.redirectErrorStream(true);
                try {
                    String string;
                    Process process = object.start();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        int n;
                        if (!(string = string.trim()).startsWith("Inno Setup: App Path") || (n = string.lastIndexOf(58)) == -1 || n >= string.length()) continue;
                        msysBase = string.substring(n - 1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (msysBase == null) {
                for (String string : Path.getPath()) {
                    if (!string.toLowerCase().endsWith("\\msys\\1.0\\bin")) continue;
                    msysBase = string.substring(0, string.length() - 4);
                    break;
                }
            }
        }
        return msysBase;
    }
}

