/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.execution;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.execution.NativeExecution;
import org.netbeans.modules.cnd.execution.OutputWindowWriter;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class NativeExecutor
implements Runnable {
    private ArrayList listeners = new ArrayList();
    private String runDir;
    private String executable;
    private String arguments;
    private String[] envp;
    private String tabName;
    private String actionName;
    private String rcfile;
    private boolean parseOutputForErrors;
    private boolean showInput;
    private NativeExecution nativeExecution;
    private boolean showHeader = true;
    private boolean showFooter = true;
    private InputOutput io;
    private PrintWriter out;
    private static ResourceBundle bundle = null;

    public NativeExecutor(String string, String string2, String string3, String[] stringArray, String string4, String string5, boolean bl) {
        this(string, string2, string3, stringArray, string4, string5, bl, false);
    }

    public NativeExecutor(String string, String string2, String string3, String[] stringArray, String string4, String string5, boolean bl, boolean bl2) {
        this.runDir = string;
        this.executable = string2;
        this.arguments = string3;
        this.envp = stringArray;
        this.tabName = string4;
        this.actionName = string5;
        this.parseOutputForErrors = bl;
        this.showInput = bl2;
    }

    public NativeExecutor(String string, String string2, String string3, String[] stringArray, String string4, String string5, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, string2, string3, stringArray, string4, string5, bl, bl2);
        this.showHeader = bl3;
        this.showFooter = bl4;
    }

    public ExecutorTask execute() throws IOException {
        return this.execute(this.getTab(this.tabName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute(InputOutput inputOutput) throws IOException {
        ExecutorTask executorTask;
        NativeExecutor nativeExecutor = this;
        synchronized (nativeExecutor) {
            this.io = inputOutput;
            inputOutput.select();
            executorTask = ExecutionEngine.getDefault().execute(this.tabName, (Runnable)this, InputOutput.NULL);
        }
        return executorTask;
    }

    private InputOutput getTab(String string) {
        return IOProvider.getDefault().getIO(string, true);
    }

    public InputOutput getTab() {
        return this.io;
    }

    public String getTabeName() {
        return this.tabName;
    }

    public void setExitValueOverride(String string) {
        this.rcfile = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        this.io.setFocusTaken(true);
        this.io.setErrVisible(false);
        this.io.setErrSeparated(false);
        if (this.showInput) {
            this.io.setInputVisible(true);
        }
        File file = new File(this.runDir);
        this.out = this.parseOutputForErrors ? new PrintWriter(new OutputWindowWriter(this.io.getOut(), FileUtil.toFileObject((File)file), this.parseOutputForErrors)) : this.io.getOut();
        this.executionStarted();
        int n = 0;
        try {
            this.nativeExecution = new NativeExecution();
            n = this.nativeExecution.executeCommand(file, this.executable, this.arguments, this.envp, this.out, this.showInput ? this.io.getIn() : null);
        }
        catch (ThreadDeath threadDeath) {
            StatusDisplayer.getDefault().setStatusText(NativeExecutor.getString("MSG_FailedStatus"));
            this.executionFinished(-1);
            this.out.close();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            StatusDisplayer.getDefault().setStatusText(NativeExecutor.getString("MSG_FailedStatus"));
            ErrorManager.getDefault().notify(throwable);
            n = -1;
        }
        finally {
            if (this.showInput) {
                this.io.setInputVisible(false);
                try {
                    this.io.getIn().close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (this.rcfile != null) {
            File file2 = null;
            try {
                file2 = new File(this.rcfile);
                if (file2.exists()) {
                    char[] cArray;
                    int n2;
                    FileReader fileReader = new FileReader(file2);
                    if (fileReader.ready() && (n2 = fileReader.read(cArray = new char[256])) > 0) {
                        n = Integer.valueOf(String.valueOf(cArray, 0, n2 - 1));
                    }
                    fileReader.close();
                    file2.delete();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (file2 != null && file2.exists()) {
                    file2.delete();
                }
            }
        }
        this.executionFinished(n);
        this.out.close();
    }

    public void stop() {
        this.nativeExecution.stop();
    }

    private void executionStarted() {
        if (this.showHeader) {
            String string = MessageFormat.format(NativeExecutor.getString("PRETEXT"), this.exePlusArgsQuoted(this.executable, this.arguments), this.runDir);
            this.out.println(string);
            this.out.println("");
        }
        this.fireExecutionStarted();
    }

    private void executionFinished(int n) {
        if (this.showFooter) {
            String string = MessageFormat.format(NativeExecutor.getString(n == 0 ? "SUCCESSFUL" : "FAILED"), this.actionName);
            String string2 = MessageFormat.format(NativeExecutor.getString("POSTTEXT"), string, "" + n);
            this.out.println("");
            this.out.println(string2);
            this.out.println("");
            StatusDisplayer.getDefault().setStatusText(string);
        }
        this.fireExecutionFinished(n);
    }

    public void addExecutionListener(ExecutionListener executionListener) {
        this.listeners.add(executionListener);
    }

    public void removeExecutionListener(ExecutionListener executionListener) {
        this.listeners.remove(this.listeners.indexOf(executionListener));
    }

    private void fireExecutionStarted() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ExecutionListener executionListener = (ExecutionListener)this.listeners.get(i);
            executionListener.executionStarted();
        }
    }

    private void fireExecutionFinished(int n) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ExecutionListener executionListener = (ExecutionListener)this.listeners.get(i);
            executionListener.executionFinished(n);
        }
    }

    private String exePlusArgsQuoted(String string, String string2) {
        String string3 = string;
        string3 = string2 == null || string2.length() == 0 ? "\"" + string3 + "\"" : "\"" + string3 + " " + string2 + "\"";
        return string3;
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(NativeExecutor.class);
        }
        return bundle.getString(string);
    }
}

