/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.css.model;

import java.awt.GraphicsEnvironment;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import org.netbeans.modules.visualweb.propertyeditors.css.model.CssStyleData;
import org.openide.util.NbBundle;

public class FontModel {
    public DefaultListModel getFontFamilySetList() {
        return new FontFamilySetList();
    }

    public DefaultListModel getFontList() {
        return new FontList();
    }

    public DefaultListModel getWebFontList() {
        return new WebFontList();
    }

    public DefaultListModel getFontFamilyList() {
        return new FontFamilyList();
    }

    public DefaultListModel getFontSizeList() {
        return new FontSizeList();
    }

    public DefaultComboBoxModel getFontSizeUnitList() {
        return new FontSizeUnitList();
    }

    public DefaultComboBoxModel getFontStyleList() {
        return new FontStyleList();
    }

    public DefaultComboBoxModel getFontSelectionList() {
        return new FontSelectionList();
    }

    public DefaultComboBoxModel getFontWeightList() {
        return new FontWeightList();
    }

    public DefaultComboBoxModel getFontVariantList() {
        return new FontVariantList();
    }

    public FontSize getFontSize(String string) {
        return new FontSize(string);
    }

    public class FontVariantList
    extends DefaultComboBoxModel {
        public FontVariantList() {
            this.addElement(CssStyleData.NOT_SET);
            this.addElement("small-caps");
        }
    }

    public class FontWeightList
    extends DefaultComboBoxModel {
        public FontWeightList() {
            this.addElement(CssStyleData.NOT_SET);
            this.addElement("normal");
            this.addElement("bold");
            this.addElement("bolder");
            this.addElement("lighter");
        }
    }

    public class FontStyleList
    extends DefaultComboBoxModel {
        public FontStyleList() {
            this.addElement(CssStyleData.NOT_SET);
            this.addElement("normal");
            this.addElement("italic");
            this.addElement("oblique");
        }
    }

    public class FontSizeUnitList
    extends DefaultComboBoxModel {
        public FontSizeUnitList() {
            this.addElement("px");
            this.addElement("pt");
            this.addElement("%");
            this.addElement("in");
            this.addElement("cm");
            this.addElement("mm");
            this.addElement("em");
            this.addElement("ex");
            this.addElement("pc");
        }
    }

    public class FontSizeList
    extends DefaultListModel {
        public FontSizeList() {
            this.addElement(CssStyleData.NOT_SET);
            this.addElement("8");
            this.addElement("10");
            this.addElement("12");
            this.addElement("14");
            this.addElement("18");
            this.addElement("24");
            this.addElement("36");
            this.addElement("XX-small");
            this.addElement("X-small");
            this.addElement("small");
            this.addElement("medium");
            this.addElement("large");
            this.addElement("X-large");
            this.addElement("XX-large");
            this.addElement("smaller");
            this.addElement("larger");
        }
    }

    public class FontFamilySetList
    extends DefaultListModel {
        public FontFamilySetList() {
            this.addElement(CssStyleData.NOT_SET);
            this.addElement("Arial,Helvetica,sans-serif");
            this.addElement("'Times New Roman',Times,serif");
            this.addElement("'Courier New',Courier,monospace");
            this.addElement("Georgia,'Times New Roman',times,serif");
            this.addElement("Verdana,Arial,Helvetica,sans-serif");
            this.addElement("Geneva,Arial,Helvetica,sans-serif");
            this.addElement("serif");
            this.addElement("sans-serif");
            this.addElement("monospace");
            this.addElement("cursive");
            this.addElement("fantasy");
        }
    }

    public class FontFamilyList
    extends DefaultListModel {
        public FontFamilyList() {
            this.addElement("serif");
            this.addElement("sans-serif");
            this.addElement("monospace");
            this.addElement("cursive");
            this.addElement("fantasy");
        }
    }

    public class WebFontList
    extends DefaultListModel {
        public WebFontList() {
            this.addElement("Arial Black");
            this.addElement("Cosmic Sans");
            this.addElement("Impact");
            this.addElement("Veranda");
            this.addElement("Webdings");
            this.addElement("Trebuchet");
            this.addElement("Georgia");
            this.addElement("Minion Web");
        }
    }

    public class FontList
    extends DefaultListModel {
        public FontList() {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addElement(stringArray[i]);
            }
        }
    }

    public class FontSelectionList
    extends DefaultComboBoxModel {
        public FontSelectionList() {
            this.addElement(NbBundle.getMessage(FontModel.class, (String)"FONTS"));
            this.addElement(NbBundle.getMessage(FontModel.class, (String)"FONT_FAMILIES"));
            this.addElement(NbBundle.getMessage(FontModel.class, (String)"WEB_FONTS"));
        }
    }

    public class FontSize {
        FontSizeUnitList unitList;
        String fontSizeUnit;
        String fontSize;

        public FontSize(String string) {
            this.unitList = new FontSizeUnitList();
            this.fontSizeUnit = null;
            this.fontSize = null;
            string = string.trim();
            for (int i = 0; i < this.unitList.getSize(); ++i) {
                String string2 = (String)this.unitList.getElementAt(i);
                if (!string.endsWith(string2)) continue;
                this.fontSizeUnit = string2;
                this.fontSize = string.replaceAll(string2, "");
            }
        }

        public String getUnit() {
            return this.fontSizeUnit;
        }

        public String getValue() {
            return this.fontSize;
        }
    }
}

