/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.css;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.visualweb.propertyeditors.css.StyleBuilderPanel;
import org.netbeans.modules.visualweb.propertyeditors.css.StyleEditor;
import org.netbeans.modules.visualweb.propertyeditors.css.model.CssStyleData;
import org.openide.util.NbBundle;

public class StyleEditorListPanel
extends JPanel {
    StyleBuilderPanel styleBuilderPanel = null;
    CssStyleData cssStyleData = null;
    List editorList = new ArrayList();
    private JList styleEditorList;

    public StyleEditorListPanel(StyleBuilderPanel styleBuilderPanel, CssStyleData cssStyleData) {
        this.cssStyleData = cssStyleData;
        this.styleBuilderPanel = styleBuilderPanel;
        this.initComponents();
        this.styleEditorList.setBackground(this.getBackground());
        this.styleEditorList.setModel(new StyleEditorListModel());
        this.styleEditorList.setCellRenderer(new StyleEditorListRenderer());
    }

    public void addEditor(StyleEditor styleEditor) {
        this.editorList.add(styleEditor);
    }

    public void setSelectedEditor(StyleEditor styleEditor) {
        int n = this.editorList.indexOf(styleEditor);
        if (n >= 0) {
            this.styleEditorList.setSelectedIndex(n);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.setSize(dimension.getWidth() + 20.0, dimension.getHeight());
        return dimension;
    }

    private void initComponents() {
        this.styleEditorList = new JList();
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(80, 200));
        this.setOpaque(false);
        this.styleEditorList.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.styleEditorList.setSelectionMode(0);
        this.styleEditorList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StyleEditorListPanel.this.styleEditorListValueChanged(listSelectionEvent);
            }
        });
        this.add((Component)this.styleEditorList, "North");
        this.styleEditorList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(StyleEditorListPanel.class, (String)"STYLE_EDITOR_LIST_ACCESSIBLE_NAME"));
        this.styleEditorList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StyleEditorListPanel.class, (String)"STYLE_EDITOR_LIST_ACCESSIBLE_DESC"));
    }

    private void styleEditorListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        StyleEditor styleEditor = (StyleEditor)jList.getSelectedValue();
        this.styleBuilderPanel.setEditorPanel(styleEditor);
    }

    class StyleEditorListRenderer
    extends DefaultListCellRenderer {
        StyleEditorListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Serializable serializable;
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
                serializable = jList.getSelectionBackground().darker();
                this.setBorder(new LineBorder((Color)serializable, 1, true));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
                this.setBorder(null);
            }
            serializable = (StyleEditor)object;
            this.setText(((StyleEditor)serializable).getDisplayName());
            return this;
        }
    }

    class StyleEditorListModel
    extends AbstractListModel {
        StyleEditorListModel() {
        }

        public int getSize() {
            return StyleEditorListPanel.this.editorList.size();
        }

        public Object getElementAt(int n) {
            return StyleEditorListPanel.this.editorList.get(n);
        }
    }
}

