/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors;

import com.sun.rave.propertyeditors.domains.Domain;
import com.sun.rave.propertyeditors.domains.EditableDomain;
import com.sun.rave.propertyeditors.domains.Element;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.visualweb.propertyeditors.EditElementDialog;
import org.netbeans.modules.visualweb.propertyeditors.PropertyPanelBase;
import org.netbeans.modules.visualweb.propertyeditors.SelectOneDomainEditor;

public class SelectOneDomainPanel
extends PropertyPanelBase {
    static ResourceBundle bundle = ResourceBundle.getBundle(SelectOneDomainPanel.class.getPackage().getName() + ".Bundle");
    protected Domain domain;
    protected Element element;
    private DefaultListModel listModel;
    private JPanel buttonPanel;
    private JButton deleteButton;
    private JList domainList;
    private JScrollPane domainScrollPane;
    private JButton editButton;
    private JLabel listLabel;
    private JButton newButton;

    public SelectOneDomainPanel(SelectOneDomainEditor selectOneDomainEditor) {
        super(selectOneDomainEditor);
        int n;
        this.domain = selectOneDomainEditor.getDomain();
        this.element = selectOneDomainEditor.getElement();
        assert (this.domain != null);
        this.listModel = new DefaultListModel();
        Element[] elementArray = this.domain.getElements();
        for (n = 0; n < elementArray.length; ++n) {
            this.listModel.addElement(elementArray[n].getLabel());
        }
        this.initComponents();
        if (this.domain instanceof EditableDomain) {
            this.buttonPanel.setVisible(true);
        } else {
            this.buttonPanel.setVisible(false);
        }
        if (this.element != null) {
            for (n = 0; n < elementArray.length && !this.element.equals((Object)elementArray[n]); ++n) {
            }
            if (n < elementArray.length) {
                this.domainList.setSelectedIndex(n);
                this.domainList.ensureIndexIsVisible(n);
            }
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
        ListEventListener listEventListener = new ListEventListener(this.domainList);
        this.domainList.addListSelectionListener(listEventListener);
        this.domainList.addKeyListener(listEventListener);
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (this.element == null) {
            return null;
        }
        return this.element.getValue();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    private void initComponents() {
        String string = this.domain.getDisplayName();
        String string2 = string == null ? bundle.getString("SelectOneDomainPanel.list.label.default") : MessageFormat.format(bundle.getString("SelectOneDomainPanel.list.label"), string);
        this.listLabel = new JLabel();
        this.domainScrollPane = new JScrollPane();
        this.domainList = new JList(this.listModel);
        this.buttonPanel = new JPanel();
        this.newButton = new JButton();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.listLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle").getString("SelectOneDomainPanel.list.label.mnemonic").charAt(0));
        this.listLabel.setLabelFor(this.domainList);
        this.listLabel.setText(string2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 11);
        this.add((Component)this.listLabel, gridBagConstraints);
        this.domainList.setMinimumSize(new Dimension(64, 64));
        this.domainList.setVisibleRowCount(this.getLabelRowCount());
        this.domainScrollPane.setViewportView(this.domainList);
        this.domainList.getAccessibleContext().setAccessibleName(bundle.getString("SelectOneDomainPanel.list.accessibleName"));
        this.domainList.getAccessibleContext().setAccessibleDescription(bundle.getString("SelectOneDomainPanel.list.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 11);
        this.add((Component)this.domainScrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(0, 6, 5));
        this.newButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle").getString("SelectOneDomainPanel.button.new.mnemonic").charAt(0));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle");
        this.newButton.setText(resourceBundle.getString("SelectOneDomainPanel.button.new"));
        this.newButton.setActionCommand("new");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectOneDomainPanel.this.handleButtonAction(actionEvent);
            }
        });
        this.buttonPanel.add(this.newButton);
        this.newButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("SelectOneDomainPanel.button.new.accessibleName"));
        this.newButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("SelectOneDomainPanel.button.new.accessibleDescription"));
        this.editButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle").getString("SelectOneDomainPanel.button.edit.mnemonic").charAt(0));
        this.editButton.setText(resourceBundle.getString("SelectOneDomainPanel.button.edit"));
        this.editButton.setActionCommand("edit");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectOneDomainPanel.this.handleButtonAction(actionEvent);
            }
        });
        this.buttonPanel.add(this.editButton);
        this.editButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("SelectOneDomainPanel.button.edit.accessibleName"));
        this.editButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("SelectOneDomainPanel.button.edit.accessibleDescription"));
        this.deleteButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle").getString("SelectOneDomainPanel.button.delete.mnemonic").charAt(0));
        this.deleteButton.setText(resourceBundle.getString("SelectOneDomainPanel.button.delete"));
        this.deleteButton.setActionCommand("delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectOneDomainPanel.this.handleButtonAction(actionEvent);
            }
        });
        this.buttonPanel.add(this.deleteButton);
        this.deleteButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("SelectOneDomainPanel.button.delete.accessibleName"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("SelectOneDomainPanel.button.delete.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 5, 0, 0);
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void handleButtonAction(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        EditableDomain editableDomain = (EditableDomain)this.domain;
        if (string.equals("new")) {
            Element element = new EditElementDialog(editableDomain).showDialog(this);
            if (element != null) {
                editableDomain.addElement(element);
                this.listModel.addElement(element.getLabel());
                this.domainList.setSelectedIndex(editableDomain.getSize() - 1);
            }
        } else if (string.equals("edit")) {
            Element element;
            Element element2;
            int n2 = this.domainList.getSelectedIndex();
            if (n2 >= 0 && n2 < this.domain.getSize() && (element2 = new EditElementDialog(element = editableDomain.getElementAt(n2), editableDomain).showDialog(this)) != null && !element2.equals((Object)element)) {
                editableDomain.setElementAt(n2, element2);
                this.listModel.set(n2, element2.getLabel());
            }
        } else if (string.equals("delete") && (n = this.domainList.getSelectedIndex()) >= 0 && n < this.domain.getSize()) {
            editableDomain.removeElementAt(n);
            this.listModel.remove(n);
            if (n == this.listModel.getSize()) {
                --n;
            }
            this.domainList.setSelectedIndex(n);
        }
    }

    private int getLabelColumnCount() {
        int n = 8;
        Element[] elementArray = this.domain.getElements();
        for (int i = 0; i < elementArray.length; ++i) {
            if (elementArray[i].getLabel().length() <= n) continue;
            n = elementArray[i].getLabel().length();
        }
        return n;
    }

    private int getLabelRowCount() {
        return this.domain.getSize() < 16 ? this.domain.getSize() : 16;
    }

    class ListEventListener
    implements KeyListener,
    ListSelectionListener {
        static final long BUFFER_ERASE_DELAY = 350L;
        JList list;
        StringBuffer keyStrokeBuffer;
        Timer keyStrokeTimer;
        TimerTask bufferEraseTask;

        ListEventListener(JList jList) {
            this.list = jList;
            this.keyStrokeBuffer = new StringBuffer(16);
            this.keyStrokeTimer = new Timer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (!Character.isISOControl(c)) {
                StringBuffer stringBuffer = this.keyStrokeBuffer;
                synchronized (stringBuffer) {
                    if (this.bufferEraseTask != null) {
                        this.bufferEraseTask.cancel();
                    }
                    this.keyStrokeBuffer.append(c);
                    this.bufferEraseTask = new TimerTask(){

                        public void run() {
                            ListEventListener.this.keyStrokeBuffer.setLength(0);
                        }
                    };
                    this.repositionSelectedItem(this.keyStrokeBuffer.toString());
                    this.keyStrokeTimer.schedule(this.bufferEraseTask, 350L);
                }
            }
        }

        private void repositionSelectedItem(String string) {
            int n;
            int n2 = this.list.getSelectedIndex() - 1;
            ListModel listModel = this.list.getModel();
            if (n2 >= 0) {
                for (n = n2 + 1; n < listModel.getSize(); ++n) {
                    if (!((String)listModel.getElementAt(n)).regionMatches(true, 0, string, 0, string.length())) continue;
                    this.list.setSelectedIndex(n);
                    this.list.ensureIndexIsVisible(n);
                    return;
                }
            }
            for (n = 0; n < listModel.getSize(); ++n) {
                if (!((String)listModel.getElementAt(n)).regionMatches(true, 0, string, 0, string.length())) continue;
                this.list.setSelectedIndex(n);
                this.list.ensureIndexIsVisible(n);
                return;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = ((JList)listSelectionEvent.getSource()).getSelectedIndex();
            SelectOneDomainPanel.this.element = SelectOneDomainPanel.this.domain.getElementAt(n);
            SelectOneDomainPanel.this.editButton.setEnabled(true);
            SelectOneDomainPanel.this.deleteButton.setEnabled(true);
        }
    }
}

