/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors;

import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.propertyeditors.resolver.PropertyEditorResolver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import javax.swing.JPanel;
import org.netbeans.modules.visualweb.propertyeditors.PropertyEditorBase;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.Lookup;

public abstract class PropertyPanelBase
extends JPanel {
    private static Lookup.Result propertyEditorResolverLookupResult;
    PropertyEditorBase propertyEditor;
    PanelSubmissionListener panelSubmissionListener;

    public static PropertyPanelBase createPropertyPanel(DesignProperty designProperty) {
        PropertyDescriptor propertyDescriptor = designProperty.getPropertyDescriptor();
        Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
        if (clazz == null) {
            return null;
        }
        try {
            PropertyEditorResolver propertyEditorResolver;
            Object object = null;
            Object object2 = PropertyPanelBase.getPropertyEditorResolvers();
            int n = ((PropertyEditorResolver[])object2).length;
            for (int i = 0; i < n && (object = (propertyEditorResolver = object2[i]).getEditor(propertyDescriptor)) == null; ++i) {
            }
            if (object == null) {
                object = (PropertyEditor)clazz.newInstance();
            }
            if (PropertyEditorBase.class.isAssignableFrom(object.getClass())) {
                ((PropertyEditorBase)object).setDesignProperty(designProperty);
            }
            object.setValue(designProperty.getValue());
            object2 = object.getCustomEditor();
            if (PropertyPanelBase.class.isAssignableFrom(object2.getClass())) {
                return (PropertyPanelBase)object2;
            }
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    private static PropertyEditorResolver[] getPropertyEditorResolvers() {
        Collection collection;
        if (propertyEditorResolverLookupResult == null) {
            collection = new Lookup.Template(PropertyEditorResolver.class);
            Lookup lookup = Lookup.getDefault();
            propertyEditorResolverLookupResult = lookup.lookup((Lookup.Template)collection);
        }
        collection = propertyEditorResolverLookupResult.allInstances();
        return collection.toArray(new PropertyEditorResolver[collection.size()]);
    }

    public PropertyPanelBase(PropertyEditorBase propertyEditorBase) {
        PropertyEnv propertyEnv = propertyEditorBase.getEnv();
        if (propertyEnv != null) {
            propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            this.panelSubmissionListener = new PanelSubmissionListener(propertyEditorBase);
            propertyEnv.addVetoableChangeListener((VetoableChangeListener)this.panelSubmissionListener);
            this.propertyEditor = propertyEditorBase;
        }
    }

    public abstract Object getPropertyValue();

    protected void finalize() throws Throwable {
        if (this.panelSubmissionListener != null) {
            this.propertyEditor.getEnv().removeVetoableChangeListener((VetoableChangeListener)this.panelSubmissionListener);
        }
        super.finalize();
    }

    class PanelSubmissionListener
    implements VetoableChangeListener {
        PropertyEditorBase propertyEditor;

        PanelSubmissionListener(PropertyEditorBase propertyEditorBase) {
            this.propertyEditor = propertyEditorBase;
        }

        public final void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("state".equals(propertyChangeEvent.getPropertyName())) {
                this.propertyEditor.setValue(PropertyPanelBase.this.getPropertyValue());
                this.propertyEditor.firePropertyChange();
                this.propertyEditor.getEnv().setState(PropertyEnv.STATE_VALID);
            }
        }
    }
}

