/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.AbstractPropertyEditor;
import com.sun.jsfcl.std.property.SingleChoiceListPanel;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;

public abstract class SingleChoiceListPropertyEditor
extends AbstractPropertyEditor {
    protected static final Object CHOICE_NOT_FOUND_MARKER = new Object();
    protected static final int MAX_CHOICE_COUNT_FOR_TAGS = 8;
    protected List choices;
    protected Object valueChoice;

    public void attachToNewDesignProperty() {
        super.attachToNewDesignProperty();
        this.initializeValueChoice();
    }

    public String getAsText() {
        return this.getStringForChoice(this.getValueChoice());
    }

    protected Object getChoiceForString(String string) {
        Object object;
        if (string != null) {
            string.trim();
        }
        if ((object = this.getChoiceForStringImp(string)) == CHOICE_NOT_FOUND_MARKER) {
            object = this.getChoiceForStringNotFound(string);
        }
        return object;
    }

    protected Object getChoiceForStringImp(String string) {
        if (string == null) {
            string = "";
        }
        for (Object e : this.getChoices()) {
            String string2 = this.getStringForChoice(e);
            if (!string.equalsIgnoreCase(string2)) continue;
            return e;
        }
        return CHOICE_NOT_FOUND_MARKER;
    }

    protected Object getChoiceForStringNotFound(String string) {
        return string;
    }

    public List getChoices() {
        if (this.choices == null) {
            this.choices = this.getChoicesImp();
        }
        return this.choices;
    }

    protected abstract List getChoicesImp();

    public Component getCustomEditor() {
        return new SingleChoiceListPanel(this, this.getDesignProperty());
    }

    public String getJavaInitializationString() {
        return SingleChoiceListPropertyEditor.stringToJavaSourceString(this.getAsText());
    }

    protected String getStringForChoice(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public String[] getTags() {
        List list = this.getChoices();
        if (list.size() > 8) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = this.getStringForChoice(iterator.next());
            ++n;
        }
        return stringArray;
    }

    public Object getValueChoice() {
        return this.valueChoice;
    }

    protected Object getValueForChoice(Object object) {
        return this.getStringForChoice(object);
    }

    protected void initializeValueChoice() {
        this.valueChoice = this.getChoiceForString((String)this.getValue());
    }

    public boolean isPaintable() {
        if (this.wantsAbilityToRefreshChoices()) {
            this.refreshChoices();
        }
        return super.isPaintable();
    }

    protected boolean isUnsetMarker(Object object) {
        return object == null || "".equals(object);
    }

    public void refreshChoices() {
        this.choices = null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Object object = this.getChoiceForString(string);
        this.setValueChoice(object);
    }

    public void setValueChoice(Object object) {
        this.valueChoice = object;
        this.setValue(this.getValueForChoice(object));
        if (this.isUnsetMarker(object)) {
            this.unsetProperty();
        }
    }

    public boolean supportsCustomEditor() {
        return this.getChoices().size() > 8;
    }

    protected boolean wantsAbilityToRefreshChoices() {
        return false;
    }
}

