/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.AbstractPropertyEditor;
import com.sun.jsfcl.std.property.LocalizedMessageRuntimeException;
import com.sun.jsfcl.util.ComponentBundle;
import com.sun.rave.designtime.DesignProperty;
import org.openide.ErrorManager;

public abstract class NumberPropertyEditor
extends AbstractPropertyEditor {
    protected boolean isValueString;
    protected static final ComponentBundle bundle = ComponentBundle.getBundle(NumberPropertyEditor.class);
    public static final String MIN_VALUE_KEY = "minValue";
    public static final String MAX_VALUE_KEY = "maxValue";
    public static final String UNSET_VALUE_KEY = "unsetValue";
    public static final String MIN_VALUE_PROP_KEY = "minValueProperty";
    public static final String MAX_VALUE_PROP_KEY = "maxValueProperty";
    public static final String UNSET_VALUE_PROP_KEY = "unsetValueProperty";
    Comparable minValue = null;
    Comparable maxValue = null;
    Comparable unsetValue = null;
    String minValueProperty = null;
    String maxValueProperty = null;
    String unsetValueProperty = null;

    public void attachToNewDesignProperty() {
        Object object;
        super.attachToNewDesignProperty();
        this.isValueString = this.getDesignProperty().getPropertyDescriptor().getPropertyType() == String.class;
        ErrorManager errorManager = ErrorManager.getDefault();
        String string = "jsfcl.NumberPropertyEditor: The Property Descriptor for " + this.getDesignProperty().getPropertyDescriptor().getName() + " has incorrect value for ";
        try {
            object = this.getDesignProperty().getPropertyDescriptor().getValue(MIN_VALUE_KEY);
            if (object != null) {
                this.minValue = (Comparable)object;
            }
        }
        catch (ClassCastException classCastException) {
            errorManager.log(65536, string + MIN_VALUE_KEY);
        }
        try {
            object = this.getDesignProperty().getPropertyDescriptor().getValue(MAX_VALUE_KEY);
            if (object != null) {
                this.maxValue = (Comparable)object;
            }
        }
        catch (ClassCastException classCastException) {
            errorManager.log(65536, string + MAX_VALUE_KEY);
        }
        try {
            object = this.getDesignProperty().getPropertyDescriptor().getValue(UNSET_VALUE_KEY);
            if (object != null) {
                this.unsetValue = (Comparable)object;
            }
        }
        catch (ClassCastException classCastException) {
            errorManager.log(65536, string + UNSET_VALUE_KEY);
        }
        try {
            object = this.getDesignProperty().getPropertyDescriptor().getValue(MIN_VALUE_PROP_KEY);
            if (object != null) {
                this.minValueProperty = (String)object;
            }
        }
        catch (ClassCastException classCastException) {
            errorManager.log(65536, string + MIN_VALUE_PROP_KEY);
        }
        try {
            object = this.getDesignProperty().getPropertyDescriptor().getValue(MAX_VALUE_PROP_KEY);
            if (object != null) {
                this.maxValueProperty = (String)object;
            }
        }
        catch (ClassCastException classCastException) {
            errorManager.log(65536, string + MAX_VALUE_PROP_KEY);
        }
        try {
            object = this.getDesignProperty().getPropertyDescriptor().getValue(UNSET_VALUE_PROP_KEY);
            if (object != null) {
                this.unsetValueProperty = (String)object;
            }
        }
        catch (ClassCastException classCastException) {
            errorManager.log(65536, string + UNSET_VALUE_PROP_KEY);
        }
    }

    public Object getUnsetValue() {
        try {
            DesignProperty designProperty;
            if (this.unsetValueProperty != null && (designProperty = this.liveProperty.getDesignBean().getProperty(this.unsetValueProperty)) != null) {
                return (Comparable)designProperty.getValue();
            }
        }
        catch (ClassCastException classCastException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.log(65536, "jsfcl.NumberPropertyEditor:  value of " + this.getDesignProperty().getPropertyDescriptor().getName() + " is not of Comparable type");
        }
        return this.unsetValue;
    }

    public String getAsText() {
        Object object = this.getValue();
        if (object == null || object.equals(this.getUnsetValue())) {
            return "";
        }
        return object.toString();
    }

    public String getJavaInitializationString() {
        Object object = this.getValue();
        String string = object != null ? object.toString() : "0";
        String string2 = this.getJavaInitializationStringSuffix();
        if (string2 != null) {
            string = string + string2;
        }
        return string;
    }

    public String getJavaInitializationStringSuffix() {
        return null;
    }

    public abstract Object parseString(String var1) throws NumberFormatException;

    public void setAsText(String string) throws IllegalArgumentException {
        string = string.trim();
        Object object = this.getUnsetValue();
        boolean bl = true;
        if (string.length() > 0) {
            try {
                object = this.parseString(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = bundle.getMessage("valueInvalid", this.getDesignProperty().getPropertyDescriptor().getName());
                throw new LocalizedMessageRuntimeException(string2, numberFormatException);
            }
            this.checkRange(object);
            bl = false;
        }
        if (this.isValueString) {
            if (object == null) {
                this.setValue(null);
            } else {
                this.setValue(String.valueOf(object));
            }
        } else {
            this.setValue(object);
        }
        if (bl) {
            this.unsetProperty();
        }
    }

    public void checkRange(Object object) throws IllegalArgumentException {
        Comparable comparable;
        DesignProperty designProperty;
        Comparable comparable2 = this.minValue;
        Comparable comparable3 = this.maxValue;
        String string = null;
        ErrorManager errorManager = ErrorManager.getDefault();
        try {
            if (this.minValueProperty != null && (designProperty = this.liveProperty.getDesignBean().getProperty(this.minValueProperty)) != null && (comparable2 = (Comparable)designProperty.getValue()).compareTo(comparable = (Comparable)designProperty.getPropertyDescriptor().getValue(UNSET_VALUE_KEY)) == 0) {
                comparable2 = this.minValue;
            }
        }
        catch (ClassCastException classCastException) {
            errorManager.log(65536, "jsfcl.NumberPropertyEditor:  value of " + this.getDesignProperty().getPropertyDescriptor().getName() + " is not of Comparable type");
        }
        try {
            if (this.maxValueProperty != null && (designProperty = this.liveProperty.getDesignBean().getProperty(this.maxValueProperty)) != null && (comparable3 = (Comparable)designProperty.getValue()).compareTo(comparable = (Comparable)designProperty.getPropertyDescriptor().getValue(UNSET_VALUE_KEY)) == 0) {
                comparable3 = this.maxValue;
            }
        }
        catch (ClassCastException classCastException) {
            errorManager.log(65536, "jsfcl.NumberPropertyEditor:  value of " + this.getDesignProperty().getPropertyDescriptor().getName() + " is not of Comparable type");
        }
        int n = comparable2.compareTo(object);
        if (n > 0) {
            string = bundle.getMessage("valueHigher", this.getDesignProperty().getPropertyDescriptor().getName(), comparable2);
            throw new IllegalArgumentException(string);
        }
        n = comparable3.compareTo(object);
        if (n < 0) {
            string = bundle.getMessage("valueLower", this.getDesignProperty().getPropertyDescriptor().getName(), comparable3);
            throw new IllegalArgumentException(string);
        }
    }
}

