/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.AbstractPropertyEditor;
import com.sun.jsfcl.std.property.ChooseOneReferenceDataPanel;
import com.sun.jsfcl.std.property.LocalizedMessageRuntimeException;
import com.sun.jsfcl.std.reference.CompositeReferenceData;
import com.sun.jsfcl.std.reference.ReferenceDataItem;
import com.sun.jsfcl.std.reference.ReferenceDataManager;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

public class ChooseOneReferenceDataPropertyEditor
extends AbstractPropertyEditor
implements ExPropertyEditor {
    public static final String REFERENCE_DATA_NAME = "referenceDataDefiner";
    protected static final int MAX_CHOICE_COUNT_FOR_TAGS = 8;
    protected CompositeReferenceData compositeReferenceData;
    protected long lastRefreshTime;
    protected ReferenceDataItem valueReferenceDataItem;
    private PropertyEnv propertyEnv;

    public void attachToNewDesignProperty() {
        super.attachToNewDesignProperty();
        this.compositeReferenceData = this.getCompositeReferenceDataImp();
        this.setValue(this.getDesignProperty().getValue());
    }

    public String getAsText() {
        return this.getStringForItem(this.valueReferenceDataItem);
    }

    public CompositeReferenceData getCompositeReferenceDataImp() {
        String string = (String)this.getDesignProperty().getPropertyDescriptor().getValue(REFERENCE_DATA_NAME);
        if (string == null) {
            throw new RuntimeException("Property named: " + this.getDesignProperty().getPropertyDescriptor().getDisplayName() + " has no " + REFERENCE_DATA_NAME + "specified !!!");
        }
        CompositeReferenceData compositeReferenceData = ReferenceDataManager.getInstance().getCompositeReferenceData(string, this.getProject(), this.getDesignProperty());
        if (compositeReferenceData == null) {
            throw new RuntimeException("Property named: " + this.getDesignProperty().getPropertyDescriptor().getDisplayName() + " got null for reference data named: " + string);
        }
        return compositeReferenceData;
    }

    public Component getCustomEditor() {
        return new ChooseOneReferenceDataPanel(this, this.getDesignProperty());
    }

    public ReferenceDataItem getItemByName(String string) {
        if (string == null) {
            return this.getItemByValue(null);
        }
        string = string.trim();
        for (ReferenceDataItem referenceDataItem : this.getItems()) {
            if (!string.equals(referenceDataItem.getName())) continue;
            return referenceDataItem;
        }
        if (this.getCompositeReferenceData().canAddRemoveItems()) {
            ReferenceDataItem referenceDataItem = this.getCompositeReferenceData().getDefiner().newItem(string, string, false, true);
            this.getCompositeReferenceData().add(referenceDataItem);
            return referenceDataItem;
        }
        return null;
    }

    public ReferenceDataItem getItemByValue(Object object) {
        for (ReferenceDataItem referenceDataItem : this.getItems()) {
            if (!(object == null ? referenceDataItem.getValue() == null : object.equals(referenceDataItem.getValue()))) continue;
            return referenceDataItem;
        }
        return null;
    }

    public List getItems() {
        return this.getCompositeReferenceData().getItemsSorted();
    }

    public CompositeReferenceData getCompositeReferenceData() {
        return this.compositeReferenceData;
    }

    public String getJavaInitializationString() {
        if (this.valueReferenceDataItem == null || this.valueReferenceDataItem.isUnsetMarker()) {
            return null;
        }
        if (this.valueReferenceDataItem.getJavaInitializationString() != null) {
            return this.valueReferenceDataItem.getJavaInitializationString();
        }
        if (this.valueReferenceDataItem.getValue() == null) {
            return null;
        }
        if (this.valueReferenceDataItem.getValue() instanceof String) {
            return ChooseOneReferenceDataPropertyEditor.stringToJavaSourceString((String)this.valueReferenceDataItem.getValue());
        }
        throw new RuntimeException("Badly setup reference data item: " + this.getCompositeReferenceData().getName() + ":" + this.valueReferenceDataItem.getName());
    }

    protected String getStringForItem(ReferenceDataItem referenceDataItem) {
        if (referenceDataItem == null) {
            return "";
        }
        String string = this.getCompositeReferenceData().isValueAString() ? (String)referenceDataItem.getValue() : referenceDataItem.getName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String[] getTags() {
        if (this.getCompositeReferenceData().canAddRemoveItems()) {
            return null;
        }
        List list = this.getItems();
        if (list.size() > 8) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = ((ReferenceDataItem)iterator.next()).getName();
            ++n;
        }
        return stringArray;
    }

    public ReferenceDataItem getValueReferenceDataItem() {
        return this.valueReferenceDataItem;
    }

    public boolean isPaintable() {
        if (System.currentTimeMillis() - this.lastRefreshTime > 10000L) {
            this.refreshItems();
            this.lastRefreshTime = System.currentTimeMillis();
        }
        return super.isPaintable();
    }

    public void refreshItems() {
        this.getCompositeReferenceData().invalidateDesignContextRelatedCaches();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.valueReferenceDataItem = this.getItemByName(string);
        if (this.valueReferenceDataItem == null) {
            super.setValue(null);
            throw new LocalizedMessageRuntimeException("Unknown value: \"" + string + "\"");
        }
        super.setValue(this.valueReferenceDataItem.getValue());
    }

    public void setValue(Object object) {
        this.setValueImp(object);
        super.setValue(object);
    }

    public void setValueImp(Object object) {
        this.valueReferenceDataItem = this.getItemByValue(object);
    }

    public boolean supportsCustomEditor() {
        if (this.getCompositeReferenceData().canAddRemoveItems()) {
            return true;
        }
        return this.getItems().size() > 8;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.propertyEnv = propertyEnv;
    }

    public PropertyEnv getEnv() {
        return this.propertyEnv;
    }
}

