/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.modules.vmd.api.codegen.CodeClassLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeGlobalLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodePresenter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaCodeGenerator {
    private static final JavaCodeGenerator DEFAULT = new JavaCodeGenerator();
    public static final String VMD_FIELDS_SECTION_ID = "fields";
    public static final String VMD_METHODS_SECTION_ID = "methods";
    private final WeakHashMap<StyledDocument, HashMap<String, String>> userCodes = new WeakHashMap();
    private final HashMap<StyledDocument, ArrayList<String>> usedMultiSectionIDs = new HashMap();

    public static JavaCodeGenerator getDefault() {
        return DEFAULT;
    }

    private JavaCodeGenerator() {
    }

    public void updateUserCodesFromEditor(final StyledDocument styledDocument) {
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

            public void run() {
                JavaCodeGenerator.this.updateUserCodesFromEditorCore(styledDocument);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCode(final StyledDocument styledDocument, DesignDocument designDocument) {
        final Collection collection = DocumentSupport.gatherAllPresentersOfClass((DesignDocument)designDocument, CodePresenter.class);
        try {
            NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

                public void run() {
                    JavaCodeGenerator.this.generateCodeCore(collection, styledDocument);
                }
            });
        }
        finally {
            this.usedMultiSectionIDs.remove(styledDocument);
        }
        Collection collection2 = DocumentSupport.filterPresentersForClass((Collection)collection, CodeGlobalLevelPresenter.class);
        for (CodeGlobalLevelPresenter codeGlobalLevelPresenter : collection2) {
            codeGlobalLevelPresenter.performGlobalGeneration(styledDocument);
        }
    }

    private void generateCodeCore(Collection<CodePresenter> collection, StyledDocument styledDocument) {
        Collection collection2 = DocumentSupport.filterPresentersForClass(collection, CodeClassLevelPresenter.class);
        MultiGuardedSection multiGuardedSection = MultiGuardedSection.create(styledDocument, VMD_FIELDS_SECTION_ID);
        assert (multiGuardedSection != null);
        multiGuardedSection.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Fields \">\n");
        for (CodeClassLevelPresenter codeClassLevelPresenter : collection2) {
            codeClassLevelPresenter.generateFieldSectionCode(multiGuardedSection);
        }
        multiGuardedSection.getWriter().write("//</editor-fold>\n");
        multiGuardedSection.getWriter().commit();
        multiGuardedSection.close();
        multiGuardedSection = MultiGuardedSection.create(styledDocument, VMD_METHODS_SECTION_ID);
        multiGuardedSection.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Methods \">\n");
        for (CodeClassLevelPresenter codeClassLevelPresenter : collection2) {
            codeClassLevelPresenter.generateMethodSectionCode(multiGuardedSection);
        }
        multiGuardedSection.getWriter().write("//</editor-fold>\n");
        multiGuardedSection.getWriter().commit();
        multiGuardedSection.close();
        for (CodeClassLevelPresenter codeClassLevelPresenter : collection2) {
            codeClassLevelPresenter.generateClassBodyCode(styledDocument);
        }
        this.removeUnusedSections(styledDocument);
    }

    private HashMap<String, String> getEditableUserCodes(StyledDocument styledDocument) {
        assert (styledDocument != null);
        HashMap<String, String> hashMap = this.userCodes.get(styledDocument);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.userCodes.put(styledDocument, hashMap);
        }
        return hashMap;
    }

    String getUserCode(StyledDocument styledDocument, String string, String string2) {
        HashMap<String, String> hashMap = this.getEditableUserCodes(styledDocument);
        return hashMap.get(string + "|" + string2);
    }

    public void putUserCode(StyledDocument styledDocument, String string, String string2, String string3) {
        HashMap<String, String> hashMap = this.getEditableUserCodes(styledDocument);
        hashMap.put(string + "|" + string2, string3);
    }

    private void updateUserCodesFromEditorCore(StyledDocument styledDocument) {
        for (GuardedSection guardedSection : GuardedSectionManager.getInstance((StyledDocument)styledDocument).getGuardedSections()) {
            Object[] objectArray;
            GuardedSection guardedSection2;
            if (!MultiGuardedSection.isPartOfMultiGuardedSection(guardedSection) || (guardedSection2 = MultiGuardedSection.findNextPartOfMultiGuardedSectionAfter(styledDocument, objectArray = MultiGuardedSection.parsePartOfMultiGuardedSection(guardedSection))) == null) continue;
            try {
                int n = guardedSection.getEndPosition().getOffset() + 1;
                int n2 = guardedSection2.getStartPosition().getOffset();
                String string = styledDocument.getText(n, n2 - n);
                this.putUserCode(styledDocument, (String)objectArray[0], (String)objectArray[2], string);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
    }

    private void removeUnusedSections(StyledDocument styledDocument) {
        Iterable iterable = GuardedSectionManager.getInstance((StyledDocument)styledDocument).getGuardedSections();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GuardedSection object : iterable) {
            Object[] objectArray;
            String string;
            if (!MultiGuardedSection.isPartOfMultiGuardedSection(object) || this.isMultiSectionUsed(styledDocument, object) || arrayList.contains(string = (String)(objectArray = MultiGuardedSection.parsePartOfMultiGuardedSection(object))[0])) continue;
            arrayList.add(string);
        }
        for (String string : arrayList) {
            MultiGuardedSection.remove(styledDocument, string);
        }
    }

    private boolean isMultiSectionUsed(StyledDocument styledDocument, GuardedSection guardedSection) {
        ArrayList<String> arrayList = this.usedMultiSectionIDs.get(styledDocument);
        return arrayList != null && arrayList.contains(MultiGuardedSection.parsePartOfMultiGuardedSection(guardedSection)[0]);
    }

    void registerUsedMultiGuardedSection(StyledDocument styledDocument, MultiGuardedSection multiGuardedSection) {
        ArrayList<String> arrayList = this.usedMultiSectionIDs.get(styledDocument);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.usedMultiSectionIDs.put(styledDocument, arrayList);
        }
        arrayList.add(multiGuardedSection.getMultiGuardedID());
    }
}

