/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.util;

import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class HgProxySettings {
    private static final String PROXY_HTTP_HOST = "proxyHttpHost";
    private static final String PROXY_HTTP_PORT = "proxyHttpPort";
    private static final String PROXY_HTTPS_HOST = "proxyHttpsHost";
    private static final String PROXY_HTTPS_PORT = "proxyHttpsPort";
    private static final String NOT_PROXY_HOSTS = "proxyNonProxyHosts";
    private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    private static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    private static final String PROXY_TYPE = "proxyType";
    private static final String DIRECT_CONNECTION = "0";
    private static final String AUTO_DETECT_PROXY = "1";
    private static final String MANUAL_SET_PROXY = "2";
    private String username;
    private String password;
    private String notProxyHosts;
    private boolean useAuth;
    private String httpHost;
    private String httpPort;
    private String httpsHost;
    private String httpsPort;
    private String proxyType;
    private String toString = null;

    public HgProxySettings() {
        this.init();
    }

    private void init() {
        Preferences preferences = NbPreferences.root().node("org/netbeans/core");
        this.proxyType = preferences.get(PROXY_TYPE, "");
        if (this.proxyType.equals(DIRECT_CONNECTION)) {
            this.useAuth = false;
            this.username = "";
            this.password = "";
            this.notProxyHosts = "";
            this.httpHost = "";
            this.httpPort = "";
            this.httpsHost = "";
            this.httpsPort = "";
        } else if (this.isManualSetProxy()) {
            this.useAuth = preferences.getBoolean(USE_PROXY_AUTHENTICATION, false);
            this.username = preferences.get(PROXY_AUTHENTICATION_USERNAME, "");
            this.password = preferences.get(PROXY_AUTHENTICATION_PASSWORD, "");
            this.notProxyHosts = preferences.get(NOT_PROXY_HOSTS, "").replace("|", " ,");
            this.httpHost = preferences.get(PROXY_HTTP_HOST, "");
            this.httpPort = preferences.get(PROXY_HTTP_PORT, "");
            this.httpsHost = preferences.get(PROXY_HTTPS_HOST, "");
            this.httpsPort = preferences.get(PROXY_HTTPS_PORT, "");
        } else {
            this.useAuth = false;
            this.username = "";
            this.password = "";
            this.notProxyHosts = System.getProperty("http.nonProxyHosts", "");
            this.httpHost = System.getProperty("http.proxyHost", "");
            this.httpPort = System.getProperty("http.proxyPort", "");
            this.httpsHost = System.getProperty("https.proxyHost", "");
            this.httpsPort = System.getProperty("https.proxyPort", "");
        }
    }

    public boolean isDirect() {
        return this.proxyType.equals(DIRECT_CONNECTION);
    }

    public boolean isManualSetProxy() {
        return this.proxyType.equals(MANUAL_SET_PROXY);
    }

    public boolean hasAuth() {
        return this.useAuth;
    }

    public String getHttpHost() {
        return this.httpHost;
    }

    public int getHttpPort() {
        if (this.httpPort.equals("")) {
            return 8080;
        }
        return Integer.parseInt(this.httpPort);
    }

    public String getHttpsHost() {
        return this.httpsHost;
    }

    public int getHttpsPort() {
        if (this.httpsPort.equals("")) {
            return 443;
        }
        return Integer.parseInt(this.httpsPort);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNotProxyHosts() {
        return this.notProxyHosts;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof HgProxySettings)) {
            return false;
        }
        HgProxySettings hgProxySettings = (HgProxySettings)object;
        return hgProxySettings.httpHost.equals(this.httpHost) && hgProxySettings.httpPort.equals(this.httpPort) && hgProxySettings.httpsHost.equals(this.httpsHost) && hgProxySettings.httpsPort.equals(this.httpsPort) && hgProxySettings.notProxyHosts.equals(this.notProxyHosts) && hgProxySettings.password.equals(this.password) && hgProxySettings.proxyType.equals(this.proxyType) && hgProxySettings.username.equals(this.username) && hgProxySettings.useAuth == this.useAuth;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append(this.httpHost);
            stringBuffer.append(",");
            stringBuffer.append(this.httpPort);
            stringBuffer.append(",");
            stringBuffer.append(this.httpsHost);
            stringBuffer.append(",");
            stringBuffer.append(this.httpsPort);
            stringBuffer.append(",");
            stringBuffer.append(this.notProxyHosts);
            stringBuffer.append(",");
            stringBuffer.append(this.password);
            stringBuffer.append(",");
            stringBuffer.append(this.proxyType);
            stringBuffer.append(",");
            stringBuffer.append(this.username);
            stringBuffer.append(",");
            stringBuffer.append(this.useAuth);
            stringBuffer.append("]");
            this.toString = stringBuffer.toString();
        }
        return this.toString;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

