/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.update;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.update.ConflictResolvedAction;
import org.netbeans.modules.mercurial.ui.update.RevertModifications;
import org.netbeans.modules.mercurial.ui.update.UpdateAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevertModificationsAction
extends ContextAction {
    private final VCSContext context;
    private static String HG_TIP = "tip";

    public RevertModificationsAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    @Override
    public void performAction(ActionEvent actionEvent) {
        RevertModificationsAction.revert(this.context);
    }

    public static void revert(VCSContext vCSContext) {
        final File[] fileArray = vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]);
        final File file = HgUtils.getRootFile(vCSContext);
        if (file == null) {
            return;
        }
        String string = null;
        RevertModifications revertModifications = new RevertModifications(file, fileArray);
        if (!revertModifications.showDialog()) {
            return;
        }
        string = revertModifications.getSelectionRevision();
        if (string == null) {
            string = HG_TIP;
        }
        final String string2 = string;
        final boolean bl = revertModifications.isBackupRequested();
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                RevertModificationsAction.performRevert(file, string2, fileArray, bl, this.getLogger());
            }
        };
        hgProgressSupport.start(requestProcessor, file.getAbsolutePath(), NbBundle.getMessage(UpdateAction.class, (String)"MSG_Revert_Progress"));
    }

    public static void performRevert(File file, String string, File file2, boolean bl, OutputLogger outputLogger) {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file2);
        RevertModificationsAction.performRevert(file, string, arrayList, bl, outputLogger);
    }

    public static void performRevert(File file, String string, File[] fileArray, boolean bl, OutputLogger outputLogger) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : fileArray) {
            arrayList.add(file2);
        }
        RevertModificationsAction.performRevert(file, string, arrayList, bl, outputLogger);
    }

    public static void performRevert(File file, String string, List<File> list, boolean bl, OutputLogger outputLogger) {
        Object object;
        try {
            outputLogger.outputInRed(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_TITLE_SEP"));
            if (string != null && NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_Revision_Default").startsWith(string)) {
                outputLogger.output(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_NOTHING"));
                outputLogger.outputInRed(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_DONE"));
                outputLogger.outputInRed("");
                return;
            }
            outputLogger.output(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_REVISION_STR", (Object)string));
            for (File object22 : list) {
                outputLogger.output(object22.getAbsolutePath());
            }
            outputLogger.output("");
            HgCommand.doRevert(file, list, string, bl, outputLogger);
            object = Mercurial.getInstance().getFileStatusCache();
            File[] exception = ((FileStatusCache)object).listFiles(list.toArray(new File[0]), 64);
            if (exception.length != 0) {
                ConflictResolvedAction.conflictResolved(file, exception);
            }
        }
        catch (HgException hgException) {
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
        }
        if (string == null) {
            for (File file2 : list) {
                HgUtils.forceStatusRefresh(file2);
            }
        } else {
            HgUtils.forceStatusRefresh(list.get(0));
        }
        object = FileUtil.toFileObject((File)file);
        try {
            object.getFileSystem().refresh(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        outputLogger.outputInRed(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_DONE"));
        outputLogger.outputInRed("");
    }

    @Override
    public boolean isEnabled() {
        Set set;
        Set set2 = set = this.context != null ? this.context.getRootFiles() : null;
        return HgUtils.getRootFile(this.context) != null && set != null && set.size() != 0;
    }
}

