/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.update;

import java.awt.event.ActionEvent;
import java.io.File;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.update.ResolveConflictsExecutor;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ResolveConflictsAction
extends ContextAction {
    private final VCSContext context;

    public ResolveConflictsAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        ResolveConflictsAction.resolve(this.context);
    }

    public static void resolve(VCSContext vCSContext) {
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        File[] fileArray = fileStatusCache.listFiles(vCSContext, 64);
        ResolveConflictsAction.resolveConflicts(fileArray);
    }

    public boolean isEnabled() {
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        return fileStatusCache.containsFileOfStatus(this.context, 64);
    }

    static void resolveConflicts(File[] fileArray) {
        if (fileArray.length == 0) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_NoConflictsFound"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        } else {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                ResolveConflictsExecutor resolveConflictsExecutor = new ResolveConflictsExecutor(file);
                resolveConflictsExecutor.exec();
            }
        }
    }
}

