/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.push;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.ui.pull.PullAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgRepositoryContextCache;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PushAction
extends ContextAction {
    private final VCSContext context;

    public PushAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE_SEP"));
            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_NOT_SUPPORTED_INVIEW_INFO"));
            outputLogger.output("");
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            outputLogger.closeLog();
            return;
        }
        PushAction.push(this.context);
    }

    public boolean isEnabled() {
        Set set;
        Set set2 = set = this.context != null ? this.context.getRootFiles() : null;
        return HgUtils.getRootFile(this.context) != null && set != null && set.size() != 0;
    }

    public static void push(final VCSContext vCSContext) {
        final File file = HgUtils.getRootFile(vCSContext);
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(string);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                PushAction.getDefaultAndPerformPush(vCSContext, file, this.getLogger());
            }
        };
        hgProgressSupport.start(requestProcessor, string, NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_PROGRESS"));
    }

    static void getDefaultAndPerformPush(VCSContext vCSContext, File file, OutputLogger outputLogger) {
        String string = HgRepositoryContextCache.getPushDefault(vCSContext);
        if (string == null) {
            string = HgRepositoryContextCache.getPullDefault(vCSContext);
        }
        if (string == null) {
            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE_SEP"));
            outputLogger.output(NbBundle.getMessage(PushAction.class, (String)"MSG_NO_DEFAULT_PUSH_SET_MSG"));
            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
            outputLogger.output("");
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(PushAction.class, (String)"MSG_NO_DEFAULT_PUSH_SET"), NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE"), 1);
            return;
        }
        String string2 = string;
        String string3 = HgProjectUtils.getProjectName(file);
        String string4 = HgProjectUtils.getProjectName(new File(string2));
        PushAction.performPush(file, string2, string3, string4, outputLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void performPush(File file, String string, String string2, String string3, OutputLogger outputLogger) {
        block35: {
            block34: {
                block33: {
                    block32: {
                        try {
                            try {
                                boolean bl;
                                boolean bl2;
                                File file2;
                                block38: {
                                    boolean bl3;
                                    block40: {
                                        block39: {
                                            List<String> list;
                                            block37: {
                                                block36: {
                                                    outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE"));
                                                    outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE_SEP"));
                                                    list = HgCommand.doOutgoing(file, string, outputLogger);
                                                    if (list == null) break block36;
                                                    if (!list.isEmpty()) break block37;
                                                }
                                                Object var14_7 = null;
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
                                                outputLogger.output("");
                                                return;
                                            }
                                            file2 = new File(string);
                                            bl2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file2)) != null;
                                            bl = HgCommand.isNoChanges(list.get(list.size() - 1));
                                            if (bl2 && !bl && !PullAction.confirmWithLocalChanges(file2, PushAction.class, "MSG_PUSH_LOCALMODS_CONFIRM_TITLE", "MSG_PUSH_LOCALMODS_CONFIRM_QUERY", list, outputLogger)) {
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_LOCALMODS_CANCEL"));
                                                outputLogger.output("");
                                                break block32;
                                            }
                                            List<String> list2 = bl ? list : HgCommand.doPush(file, string, outputLogger);
                                            if (!list2.isEmpty() && HgCommand.isErrorAbortPush(list2.get(list2.size() - 1))) {
                                                outputLogger.output(list2);
                                                outputLogger.output("");
                                                HgUtils.warningDialog(PushAction.class, "MSG_PUSH_ERROR_TITLE", "MSG_PUSH_ERROR_QUERY");
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_ERROR_CANCELED"));
                                                break block33;
                                            }
                                            if (list2 == null || list2.isEmpty()) break block38;
                                            if (!HgCommand.isNoChanges(list.get(list.size() - 1))) {
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_CHANGESETS_TO_PUSH"));
                                                for (String string4 : list) {
                                                    if (string4.indexOf("changeset:") == 0) {
                                                        outputLogger.outputInRed(string4);
                                                        continue;
                                                    }
                                                    if (string4.equals("")) continue;
                                                    outputLogger.output(HgUtils.replaceHttpPassword(string4));
                                                }
                                                outputLogger.output("");
                                            }
                                            outputLogger.output(HgUtils.replaceHttpPassword(list2));
                                            if (string3 == null) {
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TO_NONAME", (Object)(bl2 ? HgUtils.stripDoubleSlash(string) : HgUtils.replaceHttpPassword(string))));
                                            } else {
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TO", (Object)string3, (Object)(bl2 ? HgUtils.stripDoubleSlash(string) : HgUtils.replaceHttpPassword(string))));
                                            }
                                            if (string2 == null) {
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_FROM_NONAME", (Object)file));
                                            } else {
                                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_FROM", (Object)string2, (Object)file));
                                            }
                                            boolean bl4 = false;
                                            if (bl2) {
                                                bl4 = HgCommand.isHeadsCreated(list2.get(list2.size() - 1));
                                            }
                                            bl3 = false;
                                            if (bl4) break block39;
                                            if (bl) {
                                                break block34;
                                            }
                                            if (bl2) {
                                                list2 = HgCommand.doUpdateAll(file2, false, null, false);
                                                outputLogger.output(list2);
                                                if (string3 != null) {
                                                    outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_UPDATE_DONE", (Object)string3, (Object)HgUtils.stripDoubleSlash(string)));
                                                } else {
                                                    outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_UPDATE_DONE_NONAME", (Object)HgUtils.stripDoubleSlash(string)));
                                                }
                                                boolean bl5 = HgCommand.isMergeAbortUncommittedMsg(list2.get(list2.size() - 1));
                                                if (bl5) {
                                                    bl3 = HgUtils.confirmDialog(PushAction.class, "MSG_PUSH_MERGE_CONFIRM_TITLE", "MSG_PUSH_MERGE_UNCOMMITTED_CONFIRM_QUERY");
                                                }
                                            }
                                            break block40;
                                        }
                                        bl3 = HgUtils.confirmDialog(PushAction.class, "MSG_PUSH_MERGE_CONFIRM_TITLE", "MSG_PUSH_MERGE_CONFIRM_QUERY");
                                    }
                                    if (bl3) {
                                        outputLogger.output("");
                                        outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_MERGE_DO"));
                                        MergeAction.doMergeAction(file2, null, outputLogger);
                                    } else {
                                        List<String> list = HgCommand.getHeadRevisions(string);
                                        if (list != null && list.size() > 1) {
                                            MergeAction.printMergeWarning(list, outputLogger);
                                        }
                                    }
                                }
                                if (bl2 && !bl) {
                                    HgUtils.forceStatusRefresh(file2);
                                    FileObject fileObject = FileUtil.toFileObject((File)file2);
                                    try {
                                        fileObject.getFileSystem().refresh(true);
                                    }
                                    catch (Exception exception) {
                                    }
                                }
                                break block35;
                            }
                            catch (HgException hgException) {
                                NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                                Object var14_12 = null;
                                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
                                outputLogger.output("");
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_13 = null;
                            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
                            outputLogger.output("");
                            throw throwable;
                        }
                    }
                    Object var14_8 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
                    outputLogger.output("");
                    return;
                }
                Object var14_9 = null;
                outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
                outputLogger.output("");
                return;
            }
            Object var14_10 = null;
            outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
            outputLogger.output("");
            return;
        }
        Object var14_11 = null;
        outputLogger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
        outputLogger.output("");
    }
}

