/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.merge;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.merge.MergeRevisions;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeAction
extends ContextAction {
    private final VCSContext context;
    private static final int MULTIPLE_AUTOMERGE_HEAD_LIMIT = 2;

    public MergeAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    @Override
    public boolean isEnabled() {
        Set set;
        Set set2 = set = this.context != null ? this.context.getRootFiles() : null;
        return HgUtils.getRootFile(this.context) != null && set != null && set.size() != 0;
    }

    @Override
    public void performAction(ActionEvent actionEvent) {
        final File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE_SEP"));
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NOT_SUPPORTED_INVIEW_INFO"));
            outputLogger.output("");
            outputLogger.closeLog();
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            return;
        }
        String string = file.getAbsolutePath();
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(string);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                OutputLogger outputLogger = this.getLogger();
                try {
                    List<String> list = HgCommand.getHeadRevisions(file);
                    String string = null;
                    if (list.size() <= 1) {
                        outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"));
                        outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE_SEP"));
                        outputLogger.output(NbBundle.getMessage(MergeAction.class, (String)"MSG_NOTHING_TO_MERGE"));
                        outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE"));
                        outputLogger.output("");
                        JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_NOTHING_TO_MERGE"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"), 1);
                        return;
                    }
                    if (list.size() > 2) {
                        MergeRevisions mergeRevisions = new MergeRevisions(file);
                        if (!mergeRevisions.showDialog()) {
                            return;
                        }
                        string = mergeRevisions.getSelectionRevision();
                    }
                    outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"));
                    outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE_SEP"));
                    MergeAction.doMergeAction(file, string, outputLogger);
                    HgUtils.forceStatusRefreshProject(MergeAction.this.context);
                    outputLogger.output("");
                }
                catch (HgException hgException) {
                    NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                }
            }
        };
        hgProgressSupport.start(requestProcessor, string, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_PROGRESS"));
    }

    public static boolean doMergeAction(File file, String string, OutputLogger outputLogger) throws HgException {
        List<String> list = HgCommand.doMerge(file, string);
        Boolean bl = false;
        Boolean bl2 = false;
        if (list != null && !list.isEmpty()) {
            outputLogger.output(list);
            for (String string2 : list) {
                if (HgCommand.isMergeAbortUncommittedMsg(string2)) {
                    bl2 = true;
                    outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_FAILED"));
                    JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_UNCOMMITTED"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"), 2);
                    break;
                }
                if (HgCommand.isMergeAbortMultipleHeadsMsg(string2)) {
                    bl2 = true;
                    outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_FAILED"));
                    break;
                }
                if (HgCommand.isMergeConflictMsg(string2)) {
                    bl = true;
                    String string3 = null;
                    if (Utilities.isWindows()) {
                        string3 = string2.substring("merging".length(), string2.length() - "failed!".length()).trim().replace("/", "\\");
                        string3 = file.getAbsolutePath() + File.separator + string3;
                    } else {
                        string3 = string2.substring("conflicts detected in ".length());
                    }
                    outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_CONFLICT", (Object)string3));
                    HgCommand.createConflictFile(string3);
                }
                if (!HgCommand.isMergeUnavailableMsg(string2)) continue;
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_UNAVAILABLE"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"), 2);
                outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_INFO"));
                outputLogger.outputLink(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_INFO_URL"));
            }
            if (bl.booleanValue()) {
                outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE_CONFLICTS"));
            }
            if (!bl2.booleanValue() && !bl.booleanValue()) {
                outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE"));
            }
        }
        return true;
    }

    public static void printMergeWarning(List<String> list, OutputLogger outputLogger) {
        if (list == null || list.isEmpty() || list.size() <= 1) {
            return;
        }
        if (list.size() == 2) {
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_WARN_NEEDED", list));
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DO_NEEDED"));
        } else {
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_WARN_MULTIPLE_HEADS", (Object)list.size(), list));
            outputLogger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE_MULTIPLE_HEADS"));
        }
    }
}

