/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessageChangedPath;

public class HgLogMessage {
    private char mod = (char)77;
    private char add = (char)65;
    private char del = (char)82;
    private char copy = (char)67;
    private List<HgLogMessageChangedPath> mpaths;
    private List<HgLogMessageChangedPath> apaths;
    private List<HgLogMessageChangedPath> dpaths;
    private List<HgLogMessageChangedPath> cpaths;
    private String rev;
    private String author;
    private String desc;
    private Date date;
    private String id;
    private String timeZoneOffset;

    public HgLogMessage(String string) {
    }

    public HgLogMessage(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        this.rev = string;
        this.author = string2;
        this.desc = string3;
        String[] stringArray = string4.split(" ");
        this.date = new Date(Long.parseLong(stringArray[0]) * 1000L);
        this.id = string5;
        this.mpaths = new ArrayList<HgLogMessageChangedPath>();
        this.apaths = new ArrayList<HgLogMessageChangedPath>();
        this.dpaths = new ArrayList<HgLogMessageChangedPath>();
        this.cpaths = new ArrayList<HgLogMessageChangedPath>();
        if (string6 != null && !string6.equals("")) {
            for (String string10 : stringArray = string6.split(" ")) {
                this.mpaths.add(new HgLogMessageChangedPath(string10, this.mod));
                this.logCopied(string10);
            }
        }
        if (string7 != null && !string7.equals("")) {
            for (String string10 : stringArray = string7.split(" ")) {
                this.apaths.add(new HgLogMessageChangedPath(string10, this.add));
                this.logCopied(string10);
            }
        }
        if (string8 != null && !string8.equals("")) {
            for (String string10 : stringArray = string8.split(" ")) {
                this.dpaths.add(new HgLogMessageChangedPath(string10, this.del));
                this.logCopied(string10);
            }
        }
        if (string9 != null && !string9.equals("")) {
            for (String string10 : stringArray = string9.split(" ")) {
                this.cpaths.add(new HgLogMessageChangedPath(string10, this.copy));
                this.logCopied(string10);
            }
        }
    }

    private void logCopied(String string) {
        FileStatus fileStatus;
        File file = new File(string);
        FileInformation fileInformation = Mercurial.getInstance().getFileStatusCache().getStatus(file);
        FileStatus fileStatus2 = fileStatus = fileInformation != null ? fileInformation.getStatus(file) : null;
        if (fileStatus != null && fileStatus.isCopied()) {
            OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed("*** Copied: " + string + " : " + fileStatus.getFile() != null ? fileStatus.getFile().getAbsolutePath() : "no filepath");
            outputLogger.closeLog();
        }
    }

    public HgLogMessageChangedPath[] getChangedPaths() {
        ArrayList<HgLogMessageChangedPath> arrayList = new ArrayList<HgLogMessageChangedPath>();
        if (!this.mpaths.isEmpty()) {
            arrayList.addAll(this.mpaths);
        }
        if (!this.apaths.isEmpty()) {
            arrayList.addAll(this.apaths);
        }
        if (!this.dpaths.isEmpty()) {
            arrayList.addAll(this.dpaths);
        }
        if (!this.cpaths.isEmpty()) {
            arrayList.addAll(this.cpaths);
        }
        return arrayList.toArray(new HgLogMessageChangedPath[0]);
    }

    public String getRevision() {
        return this.rev;
    }

    public long getRevisionAsLong() {
        long l;
        try {
            l = Long.parseLong(this.rev);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
        return l;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCSetShortID() {
        return this.id;
    }

    public String getMessage() {
        return this.desc;
    }

    public String getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(String string) {
        this.timeZoneOffset = string;
    }

    public String toString() {
        String string = null;
        string = "rev: " + this.rev + "\nauthor: " + this.author + "\ndesc: " + this.desc + "\ndate: " + this.date + "\nid: " + this.id + "\nfm: " + this.mpaths + "\nfa: " + this.apaths + "\nfd: " + this.dpaths + "\nfc: " + this.cpaths;
        return string;
    }
}

