/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mercurial.ui.diff.ExportDiffPanel;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ExportDiff
implements PropertyChangeListener {
    private ExportDiffPanel panel;
    private JButton okButton;
    private JButton cancelButton;
    private final DocumentListener listener;
    private RepositoryRevision repoRev;
    private File fileToDiff;

    public ExportDiff(File file, RepositoryRevision repositoryRevision, File[] fileArray, File file2) {
        this.fileToDiff = file2;
        this.repoRev = repositoryRevision;
        this.panel = new ExportDiffPanel(file, repositoryRevision, fileArray, file2);
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(ExportDiff.class, (String)"CTL_ExportForm_Action_Export"));
        this.okButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportDiff.class, (String)"ACSN_ExportForm_Action_Export"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportDiff.class, (String)"ACSD_ExportForm_Action_Export"));
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(ExportDiff.class, (String)"CTL_ExportForm_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportDiff.class, (String)"ACSN_ExportForm_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportDiff.class, (String)"ACSD_ExportForm_Action_Cancel"));
        this.listener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ExportDiff.this.nameChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ExportDiff.this.nameChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ExportDiff.this.nameChange();
            }
        };
        this.panel.outputFileTextField.getDocument().addDocumentListener(this.listener);
    }

    public ExportDiff(File file, RepositoryRevision repositoryRevision, File[] fileArray) {
        this(file, repositoryRevision, fileArray, null);
    }

    public ExportDiff(File file, File[] fileArray) {
        this(file, null, fileArray, null);
    }

    public boolean showDialog() {
        DialogDescriptor dialogDescriptor = this.fileToDiff != null ? new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ExportDiff.class, (String)"CTL_ExportFileDialog")) : new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ExportDiff.class, (String)"CTL_ExportDialog"));
        dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        if (this.fileToDiff != null) {
            dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportDiff.class, (String)"ACSD_ExportFileDialog"));
        } else {
            dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportDiff.class, (String)"ACSD_ExportDialog"));
        }
        dialog.setVisible(true);
        dialog.setResizable(false);
        boolean bl = dialogDescriptor.getValue() == this.okButton;
        return bl;
    }

    private void nameChange() {
        if (this.panel.outputFileTextField.getText().trim().length() > 0) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.okButton != null) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.okButton.setEnabled(bl);
        }
    }

    public String getOutputFileName() {
        if (this.panel == null) {
            return null;
        }
        return this.panel.getOutputFileName().trim();
    }

    public String getSelectionRevision() {
        if (this.panel == null) {
            return null;
        }
        return this.panel.getSelectedRevision();
    }
}

