/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.clone;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.clone.CloneAction;
import org.netbeans.modules.mercurial.ui.clone.CloneCompletedPanel;
import org.netbeans.modules.mercurial.ui.clone.ProjectUtilities;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CloneCompleted
implements ActionListener {
    private final File workingFolder;
    private final boolean openProject;
    private CloneCompletedPanel panel;
    private Dialog dialog;
    private Project projectToBeOpened;

    public CloneCompleted(File file) {
        this.openProject = true;
        this.workingFolder = file;
    }

    public void scanForProjects(HgProgressSupport hgProgressSupport) {
        List<Object> list = new LinkedList();
        File file = FileUtil.normalizeFile((File)this.workingFolder);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            list = ProjectUtilities.scanForProjects(fileObject);
        }
        this.panel = new CloneCompletedPanel();
        this.panel.openButton.addActionListener(this);
        this.panel.createButton.addActionListener(this);
        this.panel.closeButton.addActionListener(this);
        this.panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.panel.againCheckBox.setVisible(!this.openProject);
        String string = NbBundle.getMessage(CloneAction.class, (String)"BK3008");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, string);
        dialogDescriptor.setModal(true);
        this.panel.remove(this.panel.openButton);
        this.panel.remove(this.panel.createButton);
        this.panel.remove(this.panel.closeButton);
        Object[] objectArray = null;
        if (list.size() > 1) {
            String string2 = NbBundle.getMessage(CloneAction.class, (String)"BK3009", (Object)new Integer(list.size()));
            this.panel.jLabel1.setText(string2);
            objectArray = new Object[]{this.panel.openButton, this.panel.closeButton};
        } else if (list.size() == 1) {
            Project project;
            this.projectToBeOpened = project = (Project)list.iterator().next();
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
            String string3 = projectInformation.getDisplayName();
            String string4 = NbBundle.getMessage(CloneAction.class, (String)"BK3011", (Object)string3);
            this.panel.jLabel1.setText(string4);
            this.panel.openButton.setText(NbBundle.getMessage(CloneAction.class, (String)"BK3012"));
            objectArray = new Object[]{this.panel.openButton, this.panel.closeButton};
        } else {
            String string5 = NbBundle.getMessage(CloneAction.class, (String)"BK3010");
            this.panel.jLabel1.setText(string5);
            objectArray = new Object[]{this.panel.createButton, this.panel.closeButton};
        }
        dialogDescriptor.setMessageType(1);
        dialogDescriptor.setOptions(objectArray);
        dialogDescriptor.setClosingOptions(objectArray);
        dialogDescriptor.setHelpCtx(new HelpCtx(CloneCompletedPanel.class));
        this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CloneAction.class, (String)"ACSD_CloneCompleted_Dialog"));
        if (hgProgressSupport != null && hgProgressSupport.isCanceled()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CloneCompleted.this.dialog.setVisible(true);
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.dialog.setVisible(false);
        if (this.panel.openButton.equals(object)) {
            if (this.projectToBeOpened == null) {
                JFileChooser jFileChooser = ProjectChooser.projectChooser();
                jFileChooser.setCurrentDirectory(this.workingFolder);
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.showOpenDialog(this.dialog);
                File[] fileArray = jFileChooser.getSelectedFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file = fileArray[i];
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) continue;
                    try {
                        if (fileObject == null) continue;
                        Project project = ProjectManager.getDefault().findProject(fileObject);
                        this.openProject(project);
                        continue;
                    }
                    catch (IOException iOException) {
                        Throwable throwable = new Throwable(NbBundle.getMessage(CloneAction.class, (String)"BK1014", (Object)fileObject));
                        iOException.initCause(throwable);
                        Mercurial.LOG.log(Level.INFO, null, iOException);
                    }
                }
            } else {
                this.openProject(this.projectToBeOpened);
            }
        } else if (this.panel.createButton.equals(object)) {
            ProjectUtilities.newProjectWizard(this.workingFolder);
        }
    }

    private void openProject(Project project) {
        if (project == null) {
            return;
        }
        Project[] projectArray = new Project[]{project};
        OpenProjects.getDefault().open(projectArray, false);
        OpenProjects.getDefault().setMainProject(project);
        ProjectUtilities.selectAndExpandProject(project);
    }
}

