/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.awt.Image;
import java.io.File;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.MergeMenu;
import org.netbeans.modules.mercurial.RecoverMenu;
import org.netbeans.modules.mercurial.ShareMenu;
import org.netbeans.modules.mercurial.ShowMenu;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.annotate.AnnotateAction;
import org.netbeans.modules.mercurial.ui.clone.CloneAction;
import org.netbeans.modules.mercurial.ui.clone.CloneExternalAction;
import org.netbeans.modules.mercurial.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.ui.create.CreateAction;
import org.netbeans.modules.mercurial.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.ui.diff.ExportDiffAction;
import org.netbeans.modules.mercurial.ui.diff.ImportDiffAction;
import org.netbeans.modules.mercurial.ui.ignore.IgnoreAction;
import org.netbeans.modules.mercurial.ui.log.IncomingAction;
import org.netbeans.modules.mercurial.ui.log.LogAction;
import org.netbeans.modules.mercurial.ui.log.OutAction;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.ui.properties.PropertiesAction;
import org.netbeans.modules.mercurial.ui.pull.FetchAction;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.ui.update.ConflictResolvedAction;
import org.netbeans.modules.mercurial.ui.update.ResolveConflictsAction;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.ui.update.UpdateAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class MercurialAnnotator
extends VCSAnnotator {
    private static final int INITIAL_ACTION_ARRAY_LENGTH = 25;
    private static MessageFormat uptodateFormat = MercurialAnnotator.getFormat("uptodateFormat");
    private static MessageFormat newLocallyFormat = MercurialAnnotator.getFormat("newLocallyFormat");
    private static MessageFormat addedLocallyFormat = MercurialAnnotator.getFormat("addedLocallyFormat");
    private static MessageFormat modifiedLocallyFormat = MercurialAnnotator.getFormat("modifiedLocallyFormat");
    private static MessageFormat removedLocallyFormat = MercurialAnnotator.getFormat("removedLocallyFormat");
    private static MessageFormat deletedLocallyFormat = MercurialAnnotator.getFormat("deletedLocallyFormat");
    private static MessageFormat excludedFormat = MercurialAnnotator.getFormat("excludedFormat");
    private static MessageFormat conflictFormat = MercurialAnnotator.getFormat("conflictFormat");
    private static final int STATUS_TEXT_ANNOTABLE = 6494;
    private static final Pattern lessThan = Pattern.compile("<");
    private static final int STATUS_BADGEABLE = 28;
    public static String ANNOTATION_REVISION = "revision";
    public static String ANNOTATION_STATUS = "status";
    public static String ANNOTATION_FOLDER = "folder";
    public static String[] LABELS = new String[]{ANNOTATION_REVISION, ANNOTATION_STATUS, ANNOTATION_FOLDER};
    private FileStatusCache cache;
    private MessageFormat format;
    private String emptyFormat;
    private Boolean needRevisionForFormat;
    private File folderToScan;
    private ConcurrentLinkedQueue<File> dirsToScan = new ConcurrentLinkedQueue();
    private RequestProcessor.Task scanTask;
    private static final RequestProcessor rp = new RequestProcessor("MercurialAnnotateScan", 1, true);

    public MercurialAnnotator() {
        this.cache = Mercurial.getInstance().getFileStatusCache();
        this.scanTask = rp.create((Runnable)new ScanTask());
        this.initDefaults();
    }

    private void initDefaults() {
        Field[] fieldArray = MercurialAnnotator.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            if (!string.endsWith("Format")) continue;
            this.initDefaultColor(string.substring(0, string.length() - 6));
        }
        this.refresh();
    }

    public void refresh() {
        String string = HgModuleConfig.getDefault().getAnnotationFormat();
        if (string != null && !string.trim().equals("")) {
            this.needRevisionForFormat = MercurialAnnotator.isRevisionInAnnotationFormat(string);
            string = string.replaceAll("\\{revision\\}", "\\{0\\}");
            string = string.replaceAll("\\{status\\}", "\\{1\\}");
            string = string.replaceAll("\\{folder\\}", "\\{2\\}");
            this.format = new MessageFormat(string);
            this.emptyFormat = this.format.format(new String[]{"", "", ""}, new StringBuffer(), (FieldPosition)null).toString().trim();
        }
    }

    public static boolean isRevisionInAnnotationFormat(String string) {
        return string.indexOf("{revision}") != -1;
    }

    private void initDefaultColor(String string) {
        String string2 = System.getProperty("hg.color." + string);
        if (string2 == null) {
            return;
        }
        this.setAnnotationColor(string, string2);
    }

    private void setAnnotationColor(String string, String string2) {
        try {
            Field field = MercurialAnnotator.class.getDeclaredField(string + "Format");
            MessageFormat messageFormat = new MessageFormat("<font color=\"" + string2 + "\">{0}</font><font color=\"#999999\">{1}</font>");
            field.set(null, messageFormat);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid color name");
        }
    }

    private static MessageFormat getFormat(String string) {
        String string2 = NbBundle.getMessage(MercurialAnnotator.class, (String)string);
        return new MessageFormat(string2);
    }

    public String annotateName(String string, VCSContext vCSContext) {
        int n = 6622;
        FileInformation fileInformation = null;
        File file = null;
        boolean bl = false;
        for (File file2 : vCSContext.getRootFiles()) {
            int n2;
            FileInformation fileInformation2 = this.cache.getCachedStatus(file2, true);
            if (fileInformation2 == null) {
                File file3 = file2.getParentFile();
                Mercurial.LOG.log(Level.FINE, "null cached status for: {0} {1} {2}", new Object[]{file2, this.folderToScan, file3});
                this.folderToScan = file3;
                this.reScheduleScan(1000);
                fileInformation2 = new FileInformation(8, false);
            }
            if (((n2 = fileInformation2.getStatus()) & n) == 0 || !this.isMoreImportant(fileInformation2, fileInformation)) continue;
            fileInformation = fileInformation2;
            file = file2;
            bl = file2.isDirectory();
        }
        if (!bl && vCSContext.getRootFiles().size() > 1) {
            boolean bl2 = bl = !Utils.shareCommonDataObject((File[])vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]));
        }
        if (fileInformation == null) {
            return null;
        }
        return bl ? this.annotateFolderNameHtml(string, fileInformation, file) : this.annotateNameHtml(string, fileInformation, file);
    }

    public Image annotateIcon(Image image, VCSContext vCSContext) {
        Object object;
        boolean bl = false;
        for (Object object2 : vCSContext.getRootFiles()) {
            if (!((File)object2).isDirectory()) continue;
            bl = true;
            break;
        }
        if (!bl && vCSContext.getRootFiles().size() > 1) {
            boolean bl2 = bl = !Utils.shareCommonDataObject((File[])vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]));
        }
        if (!bl) {
            return null;
        }
        boolean bl3 = false;
        for (File file : vCSContext.getRootFiles()) {
            object = this.cache.getCachedStatus(file, true);
            if (object == null || (((FileInformation)object).getStatus() & 0x1C) == 0) continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            return null;
        }
        boolean bl4 = true;
        boolean bl5 = false;
        object = this.cache.getAllModifiedFiles();
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>();
        for (File file : object.keySet()) {
            FileInformation fileInformation = (FileInformation)object.get(file);
            if ((fileInformation.getStatus() & 0x19D4) == 0) continue;
            hashMap.put(file, fileInformation);
        }
        for (File file : vCSContext.getRootFiles()) {
            int n;
            FileInformation fileInformation;
            if (VersioningSupport.isFlat((File)file)) {
                for (File file2 : hashMap.keySet()) {
                    if (!file2.getParentFile().equals(file) || (fileInformation = (FileInformation)hashMap.get(file2)).isDirectory()) continue;
                    n = fileInformation.getStatus();
                    if (n == 64) {
                        Image image2 = Utilities.loadImage((String)"org/netbeans/modules/mercurial/resources/icons/conflicts-badge.png", (boolean)true);
                        return Utilities.mergeImages((Image)image, (Image)image2, (int)16, (int)9);
                    }
                    bl5 = true;
                    bl4 &= this.isExcludedFromCommit(file2.getAbsolutePath());
                }
                continue;
            }
            for (File file2 : hashMap.keySet()) {
                if (!Utils.isAncestorOrEqual((File)file, (File)file2) || ((n = (fileInformation = (FileInformation)hashMap.get(file2)).getStatus()) == 4 || n == 4096) && file.equals(file2)) continue;
                if (n == 64) {
                    Image image3 = Utilities.loadImage((String)"org/netbeans/modules/mercurial/resources/icons/conflicts-badge.png", (boolean)true);
                    return Utilities.mergeImages((Image)image, (Image)image3, (int)16, (int)9);
                }
                bl5 = true;
                bl4 &= this.isExcludedFromCommit(file2.getAbsolutePath());
            }
        }
        if (bl5 && !bl4) {
            Image image4 = Utilities.loadImage((String)"org/netbeans/modules/mercurial/resources/icons/modified-badge.png", (boolean)true);
            return Utilities.mergeImages((Image)image, (Image)image4, (int)16, (int)9);
        }
        return null;
    }

    public Action[] getActions(VCSContext vCSContext, VCSAnnotator.ActionDestination actionDestination) {
        ResourceBundle resourceBundle = NbBundle.getBundle(MercurialAnnotator.class);
        Node[] nodeArray = vCSContext.getElements().lookupAll(Node.class).toArray(new Node[0]);
        File[] fileArray = vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]);
        File file = HgUtils.getRootFile(vCSContext);
        boolean bl = file == null;
        boolean bl2 = this.onlyFolders(fileArray);
        boolean bl3 = MercurialAnnotator.onlyProjects(nodeArray);
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>(25);
        if (actionDestination == VCSAnnotator.ActionDestination.MainMenu) {
            ContextAction contextAction;
            arrayList.add(new CreateAction(resourceBundle.getString("CTL_MenuItem_Create"), vCSContext));
            arrayList.add(null);
            arrayList.add(new StatusAction(resourceBundle.getString("CTL_PopupMenuItem_Status"), vCSContext));
            arrayList.add(new DiffAction(resourceBundle.getString("CTL_PopupMenuItem_Diff"), vCSContext));
            arrayList.add(new UpdateAction(resourceBundle.getString("CTL_PopupMenuItem_Update"), vCSContext));
            arrayList.add(new CommitAction(resourceBundle.getString("CTL_PopupMenuItem_Commit"), vCSContext));
            arrayList.add(null);
            arrayList.add(new ExportDiffAction(resourceBundle.getString("CTL_PopupMenuItem_ExportDiff"), vCSContext));
            arrayList.add(new ImportDiffAction(resourceBundle.getString("CTL_PopupMenuItem_ImportDiff"), vCSContext));
            arrayList.add(null);
            if (file != null) {
                arrayList.add(new CloneAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_CloneLocal", (Object)file.getName()), vCSContext));
            }
            arrayList.add(new CloneExternalAction(resourceBundle.getString("CTL_PopupMenuItem_CloneOther"), vCSContext));
            arrayList.add(new FetchAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_FetchLocal"), vCSContext));
            arrayList.add(new ShareMenu(vCSContext));
            arrayList.add(new MergeMenu(vCSContext, false));
            arrayList.add(null);
            arrayList.add(new LogAction(resourceBundle.getString("CTL_PopupMenuItem_Log"), vCSContext));
            if (!bl3 && !bl2) {
                contextAction = new AnnotateAction(resourceBundle.getString("CTL_PopupMenuItem_ShowAnnotations"), vCSContext);
                if (contextAction.visible(nodeArray)) {
                    arrayList.add(new ShowMenu(vCSContext, true, true));
                } else {
                    arrayList.add(new ShowMenu(vCSContext, true, false));
                }
            } else {
                arrayList.add(new ShowMenu(vCSContext, false, false));
            }
            arrayList.add(null);
            arrayList.add(new RevertModificationsAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_Revert"), vCSContext));
            arrayList.add(new RecoverMenu(vCSContext));
            if (!bl3 && !bl2) {
                contextAction = new IgnoreAction(resourceBundle.getString("CTL_PopupMenuItem_Ignore"), vCSContext);
                arrayList.add(contextAction);
            }
            arrayList.add(null);
            arrayList.add(new PropertiesAction(resourceBundle.getString("CTL_PopupMenuItem_Properties"), vCSContext));
        } else if (bl) {
            arrayList.add(new CreateAction(resourceBundle.getString("CTL_PopupMenuItem_Create"), vCSContext));
        } else {
            ContextAction contextAction;
            arrayList.add(new StatusAction(resourceBundle.getString("CTL_PopupMenuItem_Status"), vCSContext));
            arrayList.add(new DiffAction(resourceBundle.getString("CTL_PopupMenuItem_Diff"), vCSContext));
            arrayList.add(new UpdateAction(resourceBundle.getString("CTL_PopupMenuItem_Update"), vCSContext));
            arrayList.add(new CommitAction(resourceBundle.getString("CTL_PopupMenuItem_Commit"), vCSContext));
            arrayList.add(null);
            arrayList.add(new MergeAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_Merge"), vCSContext));
            arrayList.add(new ResolveConflictsAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_Resolve"), vCSContext));
            if (!bl3 && !bl2) {
                arrayList.add(new ConflictResolvedAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_MarkResolved"), vCSContext));
            }
            arrayList.add(null);
            if (!bl3 && !bl2) {
                contextAction = new AnnotateAction(resourceBundle.getString("CTL_PopupMenuItem_ShowAnnotations"), vCSContext);
                if (contextAction.visible(nodeArray)) {
                    contextAction = new AnnotateAction(resourceBundle.getString("CTL_PopupMenuItem_HideAnnotations"), vCSContext);
                }
                arrayList.add(contextAction);
            }
            arrayList.add(new LogAction(resourceBundle.getString("CTL_PopupMenuItem_Log"), vCSContext));
            arrayList.add(new IncomingAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_ShowIncoming"), vCSContext));
            arrayList.add(new OutAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_ShowOut"), vCSContext));
            arrayList.add(null);
            arrayList.add(new RevertModificationsAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_Revert"), vCSContext));
            if (!bl3 && !bl2) {
                contextAction = new IgnoreAction(resourceBundle.getString("CTL_PopupMenuItem_Ignore"), vCSContext);
                arrayList.add(contextAction);
            }
            arrayList.add(null);
            arrayList.add(new PropertiesAction(resourceBundle.getString("CTL_PopupMenuItem_Properties"), vCSContext));
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private String formatAnnotation(FileInformation fileInformation, File file) {
        String string;
        Object[] objectArray;
        Object object;
        String string2 = "";
        int n = fileInformation.getStatus();
        if (n != 8) {
            string2 = fileInformation.getShortStatusText();
        }
        String string3 = "";
        String string4 = "";
        if (this.needRevisionForFormat.booleanValue() && (n & 2) == 0) {
            try {
                object = Mercurial.getInstance().getTopmostManagedParent(file);
                objectArray = HgCommand.getLastRevision((File)object, file);
                if (objectArray != null) {
                    string3 = objectArray;
                }
            }
            catch (HgException hgException) {
                objectArray = new NotifyDescriptor.Exception((Throwable)hgException);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)objectArray);
            }
        }
        if ((object = null) == null) {
            object = "";
        }
        if ((string = this.format.format(objectArray = new Object[]{string3, string2, object}, new StringBuffer(), (FieldPosition)null).toString().trim()).equals(this.emptyFormat)) {
            return "";
        }
        return " " + string;
    }

    public String annotateNameHtml(File file, FileInformation fileInformation) {
        return this.annotateNameHtml(file.getName(), fileInformation, file);
    }

    public String annotateNameHtml(String string, FileInformation fileInformation, File file) {
        String string2;
        string = this.htmlEncode(string);
        boolean bl = VersioningSupport.getPreferences().getBoolean("textAnnotationsVisible", false);
        int n = fileInformation.getStatus();
        if (bl && file != null && (n & 0x195E) != 0) {
            if (this.format != null) {
                string2 = this.formatAnnotation(fileInformation, file);
            } else {
                String string3;
                String string4 = null;
                string2 = n == 8 && string4 == null ? "" : (n == 8 ? " [" + string4 + "]" : (string4 == null ? (!(string3 = fileInformation.getShortStatusText()).equals("") ? " [" + fileInformation.getShortStatusText() + "]" : "") : " [" + fileInformation.getShortStatusText() + "; " + string4 + "]"));
            }
        } else {
            string2 = "";
        }
        if (string2.length() > 0) {
            string2 = NbBundle.getMessage(MercurialAnnotator.class, (String)"textAnnotation", (Object)string2);
        }
        if (0 != (n & 2)) {
            return excludedFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x800)) {
            return deletedLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x100)) {
            return removedLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 4)) {
            return newLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x1000)) {
            return addedLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x10)) {
            return modifiedLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 8)) {
            return uptodateFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x40)) {
            return conflictFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 1)) {
            return string;
        }
        if (n == 0) {
            return string;
        }
        throw new IllegalArgumentException("Uncomparable status: " + n);
    }

    private String htmlEncode(String string) {
        if (string.indexOf(60) == -1) {
            return string;
        }
        return lessThan.matcher(string).replaceAll("&lt;");
    }

    private String annotateFolderNameHtml(String string, FileInformation fileInformation, File file) {
        String string2 = this.htmlEncode(string);
        if (fileInformation.getStatus() == 2) {
            return excludedFormat.format(new Object[]{string2, ""});
        }
        String string3 = file.getName();
        if (string3.equals(string)) {
            return uptodateFormat.format(new Object[]{string2, ""});
        }
        string3 = null;
        File file2 = Mercurial.getInstance().getTopmostManagedParent(file);
        if (file2 != null && file2.equals(file) && !file2.getName().equals(string)) {
            string3 = file2.getName();
        }
        if (string3 != null) {
            return uptodateFormat.format(new Object[]{string2, " [" + string3 + "]"});
        }
        return uptodateFormat.format(new Object[]{string2, ""});
    }

    private boolean isMoreImportant(FileInformation fileInformation, FileInformation fileInformation2) {
        if (fileInformation2 == null) {
            return true;
        }
        if (fileInformation == null) {
            return false;
        }
        return MercurialAnnotator.getComparableStatus(fileInformation.getStatus()) < MercurialAnnotator.getComparableStatus(fileInformation2.getStatus());
    }

    public static int getComparableStatus(int n) {
        if (0 != (n & 0x40)) {
            return 0;
        }
        if (0 != (n & 0x80)) {
            return 1;
        }
        if (0 != (n & 0x800)) {
            return 10;
        }
        if (0 != (n & 0x100)) {
            return 11;
        }
        if (0 != (n & 4)) {
            return 12;
        }
        if (0 != (n & 0x1000)) {
            return 13;
        }
        if (0 != (n & 0x10)) {
            return 14;
        }
        if (0 != (n & 0x400)) {
            return 30;
        }
        if (0 != (n & 0x200)) {
            return 31;
        }
        if (0 != (n & 0x20)) {
            return 32;
        }
        if (0 != (n & 8)) {
            return 50;
        }
        if (0 != (n & 2)) {
            return 100;
        }
        if (0 != (n & 1)) {
            return 101;
        }
        if (n == 0) {
            return 102;
        }
        throw new IllegalArgumentException("Uncomparable status: " + n);
    }

    private boolean isExcludedFromCommit(String string) {
        return false;
    }

    private boolean isNothingVersioned(File[] fileArray) {
        for (File file : fileArray) {
            if ((this.cache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyProjects(Node[] nodeArray) {
        if (nodeArray == null) {
            return false;
        }
        for (Node node : nodeArray) {
            if (node.getLookup().lookup(Project.class) != null) continue;
            return false;
        }
        return true;
    }

    private boolean onlyFolders(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                return false;
            }
            if (fileArray[i].exists() || this.cache.getStatus(fileArray[i]).isDirectory()) continue;
            return false;
        }
        return true;
    }

    private void reScheduleScan(int n) {
        File file = this.dirsToScan.peek();
        if (!this.folderToScan.equals(file) && !this.dirsToScan.offer(this.folderToScan)) {
            Mercurial.LOG.log(Level.FINE, "reScheduleScan failed to add to dirsToScan queue: {0} ", this.folderToScan);
        }
        this.scanTask.schedule(n);
    }

    private class ScanTask
    implements Runnable {
        private ScanTask() {
        }

        public void run() {
            Thread.interrupted();
            File file = (File)MercurialAnnotator.this.dirsToScan.poll();
            if (file != null) {
                MercurialAnnotator.this.cache.getScannedFiles(file, null);
                file = (File)MercurialAnnotator.this.dirsToScan.peek();
                if (file != null) {
                    MercurialAnnotator.this.scanTask.schedule(1000);
                }
            }
        }
    }
}

