/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.MercurialAnnotator;
import org.netbeans.modules.mercurial.MercurialInterceptor;
import org.netbeans.modules.mercurial.MercurialVCS;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.VersionsCache;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class Mercurial {
    public static final int HG_FETCH_20_REVISIONS = 20;
    public static final int HG_FETCH_50_REVISIONS = 50;
    public static final int HG_FETCH_ALL_REVISIONS = -1;
    public static final int HG_NUMBER_FETCH_OPTIONS = 3;
    public static final int HG_NUMBER_TO_FETCH_DEFAULT = 7;
    public static final int HG_MAX_REVISION_COMBO_SIZE = 10;
    public static final String MERCURIAL_OUTPUT_TAB_TITLE = NbBundle.getMessage(Mercurial.class, (String)"CTL_Mercurial_DisplayName");
    public static final String CHANGESET_STR = "changeset:";
    static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    public static final String PROP_CHANGESET_CHANGED = "changesetChanged";
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.mercurial");
    private static final int STATUS_DIFFABLE = 1272;
    private static final String MERCURIAL_SUPPORTED_VERSION_093 = "0.9.3";
    private static final String MERCURIAL_SUPPORTED_VERSION_094 = "0.9.4";
    private static final String MERCURIAL_SUPPORTED_VERSION_095 = "0.9.5";
    private static final String MERCURIAL_SUPPORTED_VERSION_100 = "1.0";
    private static Mercurial instance;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private MercurialAnnotator mercurialAnnotator;
    private MercurialInterceptor mercurialInterceptor;
    private FileStatusCache fileStatusCache;
    private HashMap<String, RequestProcessor> processorsToUrl;
    private boolean goodVersion;
    private String version;
    private String runVersion;
    private boolean checkedVersion;

    public static synchronized Mercurial getInstance() {
        if (instance == null) {
            instance = new Mercurial();
            instance.init();
        }
        return instance;
    }

    private Mercurial() {
    }

    private void init() {
        this.checkedVersion = false;
        this.setDefaultPath();
        this.fileStatusCache = new FileStatusCache();
        this.mercurialAnnotator = new MercurialAnnotator();
        this.mercurialInterceptor = new MercurialInterceptor();
        this.checkVersion();
    }

    private void setDefaultPath() {
        String string;
        String string2;
        if (System.getProperty("os.name").equals("Mac OS X")) {
            String string3 = HgModuleConfig.getDefault().getExecutableBinaryPath();
            if (string3 == null || string3.length() == 0) {
                String[] stringArray = new String[]{"/Library/Frameworks/Python.framework/Versions/Current/bin", "/usr/bin", "/usr/local/bin", "/opt/local/bin/", "/sw/bin"};
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!HgModuleConfig.getDefault().isExecPathValid(stringArray[i]).booleanValue()) continue;
                    HgModuleConfig.getDefault().setExecutableBinaryPath(stringArray[i]);
                    break;
                }
            }
        } else if (Utilities.isWindows() && ((string2 = HgModuleConfig.getDefault().getExecutableBinaryPath()) == null || string2.length() == 0) && (string = HgUtils.findInUserPath("hg.exe")) != null && !string.equals("")) {
            HgModuleConfig.getDefault().setExecutableBinaryPath(string);
        }
    }

    private void checkVersion() {
        this.version = HgCommand.getHgVersion();
        LOG.log(Level.FINE, "version: {0}", this.version);
        if (this.version != null) {
            boolean bl = this.goodVersion = this.version.startsWith(MERCURIAL_SUPPORTED_VERSION_093) || this.version.startsWith(MERCURIAL_SUPPORTED_VERSION_094) || this.version.startsWith(MERCURIAL_SUPPORTED_VERSION_095) || this.version.startsWith(MERCURIAL_SUPPORTED_VERSION_100);
            if (!this.goodVersion) {
                Preferences preferences = HgModuleConfig.getDefault().getPreferences();
                this.runVersion = preferences.get("runVersion", null);
                if (this.runVersion != null && this.runVersion.equals(this.version)) {
                    this.goodVersion = true;
                }
            }
        } else {
            this.goodVersion = false;
        }
    }

    public void checkVersionNotify() {
        if (this.version != null && !this.goodVersion) {
            if (this.runVersion == null || !this.runVersion.equals(this.version)) {
                Preferences preferences = HgModuleConfig.getDefault().getPreferences();
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(Mercurial.class, (String)"MSG_VERSION_CONFIRM_QUERY", (Object)this.version));
                confirmation.setTitle(NbBundle.getMessage(Mercurial.class, (String)"MSG_VERSION_CONFIRM"));
                confirmation.setMessageType(2);
                confirmation.setOptionType(0);
                Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                OutputLogger outputLogger = this.getLogger(MERCURIAL_OUTPUT_TAB_TITLE);
                if (object == NotifyDescriptor.YES_OPTION) {
                    this.goodVersion = true;
                    preferences.put("runVersion", this.version);
                    outputLogger.outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_USING_VERSION_MSG", (Object)this.version));
                } else {
                    preferences.remove("runVersion");
                    outputLogger.outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_NOT_USING_VERSION_MSG", (Object)this.version));
                }
                outputLogger.closeLog();
            } else {
                this.goodVersion = true;
            }
        } else if (this.version == null) {
            Preferences preferences = HgModuleConfig.getDefault().getPreferences();
            preferences.remove("runVersion");
            OutputLogger outputLogger = this.getLogger(MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_VERSION_NONE_OUTPUT_MSG"));
            HgUtils.warningDialog(Mercurial.class, "MSG_VERSION_NONE_TITLE", "MSG_VERSION_NONE_MSG");
            outputLogger.closeLog();
        }
    }

    public MercurialAnnotator getMercurialAnnotator() {
        return this.mercurialAnnotator;
    }

    MercurialInterceptor getMercurialInterceptor() {
        return this.mercurialInterceptor;
    }

    public FileStatusCache getFileStatusCache() {
        return this.fileStatusCache;
    }

    public boolean isAdministrative(File file) {
        String string = file.getName();
        return this.isAdministrative(string) && file.isDirectory();
    }

    public boolean isAdministrative(String string) {
        return string.equals(".hg");
    }

    public boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof MercurialVCS && !HgUtils.isPartOfMercurialMetadata(file);
    }

    public File getTopmostManagedParent(File file) {
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            while (file != null) {
                if (this.isAdministrative(file)) {
                    file = file.getParentFile();
                    break;
                }
                file = file.getParentFile();
            }
        }
        File file2 = null;
        while (file != null && !Utils.isScanForbidden((File)file)) {
            if (new File(file, ".hg").canWrite()) {
                file2 = file;
                break;
            }
            file = file.getParentFile();
        }
        return file2;
    }

    public HgFileNode[] getNodes(VCSContext vCSContext, int n) {
        File[] fileArray = this.fileStatusCache.listFiles(vCSContext, n);
        HgFileNode[] hgFileNodeArray = new HgFileNode[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            hgFileNodeArray[i] = new HgFileNode(fileArray[i]);
        }
        return hgFileNodeArray;
    }

    public String getMimeType(File file) {
        String string;
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            string = "content/unknown";
        } else {
            string = fileObject.getMIMEType();
            if ("content/unknown".equals(string)) {
                string = "text/plain";
            }
        }
        if ((this.fileStatusCache.getStatus(file).getStatus() & 0x1DF8) == 0) {
            return HgUtils.isFileContentBinary(file) ? "application/octet-stream" : string;
        }
        return string;
    }

    public boolean isGoodVersion() {
        return this.goodVersion;
    }

    public boolean isGoodVersionAndNotify() {
        if (!this.checkedVersion) {
            this.checkVersionNotify();
            this.checkedVersion = true;
        }
        return this.goodVersion;
    }

    public void versionedFilesChanged() {
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    public void changesetChanged(File file) {
        this.support.firePropertyChange(PROP_CHANGESET_CHANGED, file, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void getOriginalFile(File file, File file2) {
        FileInformation fileInformation = this.fileStatusCache.getStatus(file);
        LOG.log(Level.FINE, "getOriginalFile: {0} {1}", new Object[]{file, fileInformation});
        if ((fileInformation.getStatus() & 0x4F8) == 0) {
            return;
        }
        try {
            File file3 = VersionsCache.getInstance().getFileRevision(file, "BASE");
            if (file3 == null) {
                return;
            }
            Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(file2), (InputStream)new FileInputStream(file3));
            file3.delete();
        }
        catch (IOException iOException) {
            Logger.getLogger(Mercurial.class.getName()).log(Level.INFO, "Unable to get original file", iOException);
        }
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor((String)null);
    }

    public RequestProcessor getRequestProcessor(File file) {
        return this.getRequestProcessor(file.getAbsolutePath());
    }

    public RequestProcessor getRequestProcessor(String string) {
        String string2;
        RequestProcessor requestProcessor;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((requestProcessor = this.processorsToUrl.get(string2 = string != null ? string : "ANY_URL")) == null) {
            requestProcessor = new RequestProcessor("Mercurial - " + string2, 1, true);
            this.processorsToUrl.put(string2, requestProcessor);
        }
        return requestProcessor;
    }

    public void clearRequestProcessor(String string) {
        if (this.processorsToUrl != null & string != null) {
            this.processorsToUrl.remove(string);
        }
    }

    public OutputLogger getLogger(String string) {
        return OutputLogger.getLogger(string);
    }
}

