/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.modules.mercurial.HgMail;
import org.netbeans.modules.mercurial.MercurialAnnotator;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.ui.repository.RepositoryConnection;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgModuleConfig {
    public static final String PROP_IGNORED_FILEPATTERNS = "ignoredFilePatterns";
    public static final String PROP_COMMIT_EXCLUSIONS = "commitExclusions";
    public static final String PROP_DEFAULT_VALUES = "defaultValues";
    public static final String PROP_RUN_VERSION = "runVersion";
    public static final String KEY_EXECUTABLE_BINARY = "hgExecBinary";
    public static final String KEY_EXPORT_FILENAME = "hgExportFilename";
    public static final String KEY_EXPORT_FOLDER = "hgExportFolder";
    public static final String KEY_IMPORT_FOLDER = "hgImportFolder";
    public static final String KEY_ANNOTATION_FORMAT = "annotationFormat";
    public static final String SAVE_PASSWORD = "savePassword";
    public static final String KEY_BACKUP_ON_REVERTMODS = "backupOnRevert";
    public static final String KEY_SHOW_HITORY_MERGES = "showHistoryMerges";
    private static final String RECENT_URL = "repository.recentURL";
    private static final String SHOW_CLONE_COMPLETED = "cloneCompleted.showCloneCompleted";
    private static final String SET_MAIN_PROJECT = "cloneCompleted.setMainProject";
    private static final String URL_EXP = "annotator.urlExp";
    private static final String ANNOTATION_EXP = "annotator.annotationExp";
    public static final String TEXT_ANNOTATIONS_FORMAT_DEFAULT = "{DEFAULT}";
    private static final String DEFAULT_EXPORT_FILENAME = "%b_%r_%h";
    private static final HgModuleConfig INSTANCE = new HgModuleConfig();
    private static String userName;
    private Set<String> exclusions;
    private TableSorter importTableSorter;
    private TableSorter commitTableSorter;

    public static HgModuleConfig getDefault() {
        return INSTANCE;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(HgModuleConfig.class);
    }

    public boolean getShowCloneCompleted() {
        return this.getPreferences().getBoolean(SHOW_CLONE_COMPLETED, true);
    }

    public boolean getSetMainProject() {
        return this.getPreferences().getBoolean(SET_MAIN_PROJECT, true);
    }

    public Pattern[] getIgnoredFilePatterns() {
        return HgModuleConfig.getDefaultFilePatterns();
    }

    public boolean isExcludedFromCommit(String string) {
        return this.getCommitExclusions().contains(string);
    }

    public void addExclusionPaths(Collection<String> collection) {
        Set<String> set = this.getCommitExclusions();
        if (set.addAll(collection)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(set));
        }
    }

    public void removeExclusionPaths(Collection<String> collection) {
        Set<String> set = this.getCommitExclusions();
        if (set.removeAll(collection)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(set));
        }
    }

    public String getExecutableBinaryPath() {
        return this.getPreferences().get(KEY_EXECUTABLE_BINARY, "");
    }

    public boolean getBackupOnRevertModifications() {
        return this.getPreferences().getBoolean(KEY_BACKUP_ON_REVERTMODS, true);
    }

    public void setBackupOnRevertModifications(boolean bl) {
        this.getPreferences().putBoolean(KEY_BACKUP_ON_REVERTMODS, bl);
    }

    public boolean getShowHistoryMerges() {
        return this.getPreferences().getBoolean(KEY_SHOW_HITORY_MERGES, true);
    }

    public void setShowHistoryMerges(boolean bl) {
        this.getPreferences().putBoolean(KEY_SHOW_HITORY_MERGES, bl);
    }

    public void setExecutableBinaryPath(String string) {
        if (Utilities.isWindows() && string.endsWith("hg.exe")) {
            string = string.substring(0, string.length() - "hg.exe".length());
        } else if (string.endsWith("hg")) {
            string = string.substring(0, string.length() - "hg".length());
        }
        this.getPreferences().put(KEY_EXECUTABLE_BINARY, string);
    }

    public String getExportFolder() {
        return this.getPreferences().get(KEY_EXPORT_FOLDER, System.getProperty("user.home"));
    }

    public void setExportFolder(String string) {
        this.getPreferences().put(KEY_EXPORT_FOLDER, string);
    }

    public String getImportFolder() {
        return this.getPreferences().get(KEY_IMPORT_FOLDER, System.getProperty("user.home"));
    }

    public void setImportFolder(String string) {
        this.getPreferences().put(KEY_IMPORT_FOLDER, string);
    }

    public String getExportFilename() {
        String string = this.getPreferences().get(KEY_EXPORT_FILENAME, "");
        if (string.trim().length() == 0) {
            string = DEFAULT_EXPORT_FILENAME;
        }
        return string;
    }

    public void setExportFilename(String string) {
        this.getPreferences().put(KEY_EXPORT_FILENAME, string);
    }

    public String getUserName() {
        userName = HgConfigFiles.getInstance().getUserName();
        if (userName.length() == 0) {
            String string;
            String string2 = System.getProperty("user.name");
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                string = "localhost";
            }
            userName = string2 + "@" + string + ".zzz";
        }
        return userName;
    }

    public void addHgkExtension() {
        HgConfigFiles.getInstance().setProperty("hgext.hgk", "");
    }

    public void setUserName(String string) {
        HgConfigFiles.getInstance().setUserName(string);
    }

    public Boolean isUserNameValid(String string) {
        if (userName == null) {
            this.getUserName();
        }
        if (string.equals(userName)) {
            return true;
        }
        if (string.length() == 0) {
            return true;
        }
        return HgMail.isUserNameValid(string);
    }

    public Boolean isExecPathValid(String string) {
        if (string.length() == 0) {
            return true;
        }
        File file = new File(string, "hg");
        if (file.exists() && file.isFile()) {
            return true;
        }
        file = new File(string, "hg.exe");
        return file.exists() && file.isFile();
    }

    public Properties getProperties(File file) {
        Properties properties = new Properties();
        HgConfigFiles hgConfigFiles = new HgConfigFiles(file);
        String string = hgConfigFiles.getUserName(false);
        if (string.length() == 0) {
            string = this.getUserName();
        }
        if (string.length() > 0) {
            properties.setProperty("username", string);
        } else {
            properties.setProperty("username", "");
        }
        string = hgConfigFiles.getDefaultPull(false);
        if (string.length() > 0) {
            properties.setProperty("default-pull", string);
        } else {
            properties.setProperty("default-pull", "");
        }
        string = hgConfigFiles.getDefaultPush(false);
        if (string.length() > 0) {
            properties.setProperty("default-push", string);
        } else {
            properties.setProperty("default-push", "");
        }
        return properties;
    }

    public void clearProperties(File file, String string) {
        this.getHgConfigFiles(file).clearProperties(string);
    }

    public void removeProperty(File file, String string, String string2) {
        this.getHgConfigFiles(file).removeProperty(string, string2);
    }

    public void setProperty(File file, String string, String string2) {
        this.getHgConfigFiles(file).setProperty(string, string2);
    }

    public void setProperty(File file, String string, String string2, String string3, boolean bl) {
        this.getHgConfigFiles(file).setProperty(string, string2, string3, bl);
    }

    public void setProperty(File file, String string, String string2, String string3) {
        this.getHgConfigFiles(file).setProperty(string, string2, string3);
    }

    public Properties getProperties(File file, String string) {
        return this.getHgConfigFiles(file).getProperties(string);
    }

    private HgConfigFiles getHgConfigFiles(File file) {
        if (file == null) {
            return HgConfigFiles.getInstance();
        }
        return new HgConfigFiles(file);
    }

    public String getAnnotationFormat() {
        return this.getPreferences().get(KEY_ANNOTATION_FORMAT, this.getDefaultAnnotationFormat());
    }

    public String getDefaultAnnotationFormat() {
        return "[{" + MercurialAnnotator.ANNOTATION_STATUS + "} {" + MercurialAnnotator.ANNOTATION_FOLDER + "}]";
    }

    public void setAnnotationFormat(String string) {
        this.getPreferences().put(KEY_ANNOTATION_FORMAT, string);
    }

    public boolean getSavePassword() {
        return this.getPreferences().getBoolean(SAVE_PASSWORD, true);
    }

    public void setSavePassword(boolean bl) {
        this.getPreferences().putBoolean(SAVE_PASSWORD, bl);
    }

    public void setShowCloneCompleted(boolean bl) {
        this.getPreferences().putBoolean(SHOW_CLONE_COMPLETED, bl);
    }

    public void setSetMainProject(boolean bl) {
        this.getPreferences().putBoolean(SET_MAIN_PROJECT, bl);
    }

    public RepositoryConnection getRepositoryConnection(String string) {
        List<RepositoryConnection> list = this.getRecentUrls();
        for (RepositoryConnection repositoryConnection : list) {
            if (!string.equals(repositoryConnection.getUrl())) continue;
            return repositoryConnection;
        }
        return null;
    }

    public void insertRecentUrl(RepositoryConnection repositoryConnection) {
        Preferences preferences = this.getPreferences();
        List list = Utils.getStringList((Preferences)preferences, (String)RECENT_URL);
        for (String string : list) {
            RepositoryConnection repositoryConnection2 = RepositoryConnection.parse(string);
            if (!repositoryConnection2.equals(repositoryConnection)) continue;
            Utils.removeFromArray((Preferences)preferences, (String)RECENT_URL, (String)string);
        }
        Utils.insert((Preferences)preferences, (String)RECENT_URL, (String)RepositoryConnection.getString(repositoryConnection), (int)-1);
    }

    public void setRecentUrls(List<RepositoryConnection> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = 0;
        Object object = list.iterator();
        while (object.hasNext()) {
            ++n;
            RepositoryConnection repositoryConnection = object.next();
            arrayList.add(RepositoryConnection.getString(repositoryConnection));
        }
        object = this.getPreferences();
        Utils.put((Preferences)object, (String)RECENT_URL, arrayList);
    }

    public List<RepositoryConnection> getRecentUrls() {
        Preferences preferences = this.getPreferences();
        List list = Utils.getStringList((Preferences)preferences, (String)RECENT_URL);
        ArrayList<RepositoryConnection> arrayList = new ArrayList<RepositoryConnection>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RepositoryConnection repositoryConnection = RepositoryConnection.parse((String)iterator.next());
            arrayList.add(repositoryConnection);
        }
        return arrayList;
    }

    public TableSorter getImportTableSorter() {
        return this.importTableSorter;
    }

    public void setImportTableSorter(TableSorter tableSorter) {
        this.importTableSorter = tableSorter;
    }

    public TableSorter getCommitTableSorter() {
        return this.commitTableSorter;
    }

    public void setCommitTableSorter(TableSorter tableSorter) {
        this.commitTableSorter = tableSorter;
    }

    private synchronized Set<String> getCommitExclusions() {
        if (this.exclusions == null) {
            this.exclusions = new HashSet<String>(Utils.getStringList((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS));
        }
        return this.exclusions;
    }

    private static Pattern[] getDefaultFilePatterns() {
        return new Pattern[]{Pattern.compile("cvslog\\..*"), Pattern.compile("\\.make\\.state"), Pattern.compile("\\.nse_depinfo"), Pattern.compile(".*~"), Pattern.compile("#.*"), Pattern.compile("\\.#.*"), Pattern.compile(",.*"), Pattern.compile("_\\$.*"), Pattern.compile(".*\\$"), Pattern.compile(".*\\.old"), Pattern.compile(".*\\.bak"), Pattern.compile(".*\\.BAK"), Pattern.compile(".*\\.orig"), Pattern.compile(".*\\.rej"), Pattern.compile(".*\\.del-.*"), Pattern.compile(".*\\.a"), Pattern.compile(".*\\.olb"), Pattern.compile(".*\\.o"), Pattern.compile(".*\\.obj"), Pattern.compile(".*\\.so"), Pattern.compile(".*\\.exe"), Pattern.compile(".*\\.Z"), Pattern.compile(".*\\.elc"), Pattern.compile(".*\\.ln")};
    }
}

