/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.util.logging.Level;
import javax.swing.JButton;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ExceptionHandler {
    public static final int EX_UNKNOWN = 0;
    public static final int EX_ACTION_CANCELED_BY_USER = 2;
    public static final int EX_NO_REPOSITORY = 4;
    public static final int EX_ALREADY_TRACKED = 8;
    public static final int EX_NOT_TRACKED = 16;
    public static final int EX_CANNOT_READ_COMMIT_MSG = 32;
    public static final int EX_UNABLE_EXECUTE_CMD = 64;
    static final String ACTION_CANCELED_BY_USER = NbBundle.getMessage(ExceptionHandler.class, (String)"MSG_ActionCanceledByUser");
    private final HgException exception;
    private final int exceptionMask;

    public ExceptionHandler(HgException hgException) {
        this.exception = hgException;
        this.exceptionMask = ExceptionHandler.getMask(hgException.getMessage());
    }

    protected int getExceptionMask() {
        return this.exceptionMask;
    }

    protected HgException getException() {
        return this.exception;
    }

    private static int getMask(String string) {
        if (string == null || string.trim().equals("")) {
            return 0;
        }
        if (ExceptionHandler.isCancelledAction(string = string.toLowerCase())) {
            return 2;
        }
        if (ExceptionHandler.isNoRepository(string)) {
            return 4;
        }
        if (ExceptionHandler.isNotTracked(string)) {
            return 16;
        }
        if (ExceptionHandler.isCannotReadCommitMsg(string)) {
            return 32;
        }
        if (ExceptionHandler.isUnableExecuteCmd(string)) {
            return 64;
        }
        if (ExceptionHandler.isAlreadyTracked(string)) {
            return 8;
        }
        return 0;
    }

    private static boolean isCancelledAction(String string) {
        return string.equals(ACTION_CANCELED_BY_USER);
    }

    public static boolean isNoRepository(String string) {
        return (string = string.toLowerCase()).indexOf("abort: There is no Mercurial repository here") > -1;
    }

    public static boolean isUpdateSpansBranches(String string) {
        return (string = string.toLowerCase()).indexOf("abort: update spans branches") > -1;
    }

    public static boolean isAlreadyTracked(String string) {
        return string.indexOf(" already tracked!") > -1;
    }

    public static boolean isNotTracked(String string) {
        return string.indexOf(" not tracked!") > -1;
    }

    public static boolean isCannotReadCommitMsg(String string) {
        return string.indexOf("abort: can't read commit message") > -1;
    }

    public static boolean isUnableExecuteCmd(String string) {
        return string.indexOf("unable to execute hg command") > -1;
    }

    public static boolean isUnableClone(String string) {
        return string.indexOf("abort: destination ") > -1;
    }

    public static boolean isNotFound(String string) {
        return string.indexOf("not found!") > -1;
    }

    public static boolean isNoChangeNeeded(String string) {
        return string.indexOf("no change needed") > -1;
    }

    public void notifyException() {
        if (ExceptionHandler.isCancelledAction(this.exception.getMessage())) {
            this.cancelledAction();
            return;
        }
        Mercurial.LOG.log(Level.INFO, null, this.exception);
    }

    public void notifyException(boolean bl) {
        if (!bl) {
            this.cancelledAction();
            return;
        }
        Mercurial.LOG.log(Level.INFO, null, this.exception);
    }

    public static String parseExceptionMessage(HgException hgException) {
        String string = hgException.getMessage();
        int n = string.lastIndexOf("hg: ");
        if (n > -1) {
            string = string.substring(n);
        }
        return string;
    }

    private void cancelledAction() {
        JButton jButton = new JButton(NbBundle.getMessage(ExceptionHandler.class, (String)"CTL_Action_OK"));
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)ACTION_CANCELED_BY_USER, NbBundle.getMessage(ExceptionHandler.class, (String)"CTL_ActionCanceled_Title"), -1, 2, new Object[]{jButton}, (Object)jButton);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }
}

