/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.treeeditor.newtype;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.api.property.PropertyUtil;
import org.netbeans.modules.xml.wsdl.ui.view.OperationConfigurationPanel;
import org.netbeans.modules.xml.wsdl.ui.view.PartAndElementOrTypeTableModel;
import org.netbeans.modules.xml.wsdl.ui.view.common.CommonMessagePanel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.openide.DialogDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class OperationPanel
extends JPanel {
    private Project mProject;
    private WSDLModel mModel;
    private DialogDescriptor mDD;
    private List<String> existingMessages = new ArrayList<String>();
    String mErrorMessage = null;
    private String mWarningMessage;
    private PortType mPortType;
    private CommonMessagePanel commonMessagePanel1;
    private OperationConfigurationPanel operationConfigurationPanel1;

    public OperationPanel() {
        this.initComponents();
    }

    public OperationPanel(Project project, PortType portType) {
        this.mProject = project;
        this.mPortType = portType;
        this.mModel = portType.getModel();
        this.initComponents();
        this.initGUI();
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.mDD = dialogDescriptor;
    }

    private void initComponents() {
        this.operationConfigurationPanel1 = new OperationConfigurationPanel(this.mProject, true, this.mModel, false);
        this.commonMessagePanel1 = new CommonMessagePanel();
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.operationConfigurationPanel1, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(96, 96, 96).add((Component)this.commonMessagePanel1, -1, 414, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.operationConfigurationPanel1, -1, -1, Short.MAX_VALUE).add(17, 17, 17).add((Component)this.commonMessagePanel1, -2, -1, -2).add(60, 60, 60)));
    }

    public OperationConfigurationPanel getOperationConfigurationPanel() {
        return this.operationConfigurationPanel1;
    }

    private void initGUI() {
        Object object;
        ModelSource modelSource = this.mModel.getModelSource();
        FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            String string;
            object = fileObject.getName();
            NameGenerator nameGenerator = NameGenerator.getInstance();
            String string2 = string = (String)object + NbBundle.getMessage(OperationPanel.class, (String)"LBL_Operation_suffix");
            if (nameGenerator.isOperationExists(string, this.mPortType)) {
                string = nameGenerator.generateUniqueOperationName(string2, this.mPortType);
            }
            this.operationConfigurationPanel1.setOperationName(string);
            String[] stringArray = PropertyUtil.getAllMessages(this.mModel);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.existingMessages.add(stringArray[i]);
                }
            }
            String string3 = NameGenerator.getInstance().generateUniqueInputMessageName(string, this.mModel);
            String string4 = NameGenerator.getInstance().generateUniqueOutputMessageName(string, this.mModel);
            MessageNameTextChangeListener messageNameTextChangeListener = new MessageNameTextChangeListener();
            this.operationConfigurationPanel1.setInputMessages(stringArray, string3, messageNameTextChangeListener);
            this.operationConfigurationPanel1.setOutputMessages(stringArray, string4, messageNameTextChangeListener);
            this.operationConfigurationPanel1.setFaultMessages(stringArray, null, messageNameTextChangeListener);
        }
        object = new OperationNameTextChangeListener();
        this.operationConfigurationPanel1.getOperationNameTextField().getDocument().addDocumentListener((DocumentListener)object);
        this.operationConfigurationPanel1.addPropertyChangeListener("FAULT_PARTS_LISTENER", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                OperationPanel.this.validateAll();
            }
        });
    }

    private boolean isValidName(String string) {
        try {
            boolean bl = Utils.isValidNCName((String)string);
            this.mErrorMessage = !bl ? NbBundle.getMessage(OperationPanel.class, (String)"ERR_MSG_INVALID_NAME", (Object)string) : null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.mErrorMessage == null;
    }

    private void validateAll() {
        boolean bl = this.isValidName(this.operationConfigurationPanel1.getOperationNameTextField().getText());
        if (!bl) {
            this.updateMessagePanel();
            return;
        }
        boolean bl2 = this.isValidInputMessage();
        if (!bl2) {
            this.updateMessagePanel();
            return;
        }
        boolean bl3 = this.isValidOutputMessage();
        if (!bl3) {
            this.updateMessagePanel();
            return;
        }
        boolean bl4 = this.isValidFaultMessage();
        if (!bl4) {
            this.updateMessagePanel();
            return;
        }
        this.mErrorMessage = null;
        this.mWarningMessage = null;
        this.updateMessagePanel();
    }

    private boolean isValidInputMessage() {
        boolean bl = true;
        String string = this.operationConfigurationPanel1.getInputMessageName();
        if (string != null && !this.isExistingMessage(string)) {
            bl = this.isValidName(string);
        }
        return bl;
    }

    private boolean isValidOutputMessage() {
        boolean bl = true;
        String string = this.operationConfigurationPanel1.getOutputMessageName();
        if (string != null && !this.isExistingMessage(string)) {
            bl = this.isValidName(string);
        }
        return bl;
    }

    private boolean isValidFaultMessage() {
        List<PartAndElementOrTypeTableModel.PartAndElementOrType> list;
        boolean bl = true;
        String string = this.operationConfigurationPanel1.getFaultMessageName();
        if (string != null && !this.isExistingMessage(string)) {
            bl = this.isValidName(string);
        }
        if ((list = this.operationConfigurationPanel1.getFaultMessageParts()) != null && list.isEmpty()) {
            if (!bl) {
                this.mErrorMessage = null;
                bl = true;
            }
            if (string != null && string.length() > 0) {
                this.mWarningMessage = NbBundle.getMessage(OperationPanel.class, (String)"WARNING_NO_PARTS_IN_FAULT", (Object)string);
                bl = false;
            }
        }
        return bl;
    }

    private boolean isExistingMessage(String string) {
        return this.existingMessages.contains(string);
    }

    private void updateMessagePanel() {
        if (this.mErrorMessage != null) {
            this.commonMessagePanel1.setErrorMessage(this.mErrorMessage);
            if (this.mDD != null) {
                this.mDD.setValid(false);
            }
        } else {
            if (this.mWarningMessage != null) {
                this.commonMessagePanel1.setWarningMessage(this.mWarningMessage);
            } else {
                this.commonMessagePanel1.setMessage("");
            }
            if (this.mDD != null) {
                this.mDD.setValid(true);
            }
        }
    }

    class MessageNameTextChangeListener
    implements DocumentListener {
        MessageNameTextChangeListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            OperationPanel.this.validateAll();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            OperationPanel.this.validateAll();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            OperationPanel.this.validateAll();
        }
    }

    class OperationNameTextChangeListener
    implements DocumentListener {
        OperationNameTextChangeListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            OperationPanel.this.validateAll();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            OperationPanel.this.validateAll();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            OperationPanel.this.validateAll();
        }
    }
}

