/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.treeeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.UIUtilities;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.DefinitionsNode;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.ExtensibilityElementNode;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.NodesFactory;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class TreeEditorView
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider,
PropertyChangeListener {
    private static final long serialVersionUID = -6844839168489591934L;
    private ExplorerManager explorerManager;
    private transient Lookup lookup;
    private WSDLModel mModel;
    private BeanTreeView btv;

    public TreeEditorView(WSDLModel wSDLModel) {
        this.mModel = wSDLModel;
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.btv = new BeanTreeView();
        this.btv.setRootVisible(true);
        this.btv.setSelectionMode(4);
        this.btv.setPopupAllowed(true);
        this.add((Component)this.btv, "Center");
        this.explorerManager = new ExplorerManager();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)false));
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)actionMap);
        this.populateRootNode(this.mModel.getDefinitions());
        Node node = this.explorerManager.getRootContext();
        this.btv.expandNode(node);
        Utility.expandNodes((TreeView)this.btv, 1, node);
        try {
            this.explorerManager.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private void populateRootNode(Definitions definitions) {
        if (definitions != null) {
            Node node = NodesFactory.getInstance().create((WSDLComponent)definitions);
            this.explorerManager.setRootContext(node);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TopComponent topComponent;
        Node[] nodeArray;
        if (propertyChangeEvent.getPropertyName().equals("selectedNodes") && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length > 0 && (topComponent = this.findParentTopComponent()) != null) {
            topComponent.setActivatedNodes(nodeArray);
        }
    }

    private TopComponent findParentTopComponent() {
        return (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
    }

    public void showComponent(WSDLComponent wSDLComponent) {
        List<Node> list = UIUtilities.findPathFromRoot(this.getExplorerManager().getRootContext(), wSDLComponent);
        if (list == null || list.isEmpty()) {
            return;
        }
        Node node = list.get(list.size() - 1);
        try {
            this.getExplorerManager().setExploredContextAndSelection(node, new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void showComponent(SchemaComponent schemaComponent) {
        List<Node> list = UIUtilities.findPathFromRoot(this.getExplorerManager().getRootContext(), schemaComponent, this.mModel);
        if (list == null || list.isEmpty()) {
            return;
        }
        Node node = list.get(list.size() - 1);
        try {
            this.getExplorerManager().setExploredContextAndSelection(node, new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.btv != null) {
            this.btv.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        if (this.btv != null) {
            return this.btv.requestFocusInWindow();
        }
        return bl;
    }

    public void addNotify() {
        super.addNotify();
        this.initGUI();
    }

    public void removeNotify() {
        super.removeNotify();
        this.explorerManager.setRootContext(Node.EMPTY);
        this.explorerManager.setExploredContext(Node.EMPTY, new Node[0]);
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        this.removeAll();
        this.btv = null;
    }

    public void refreshNodes() {
        Node node = this.explorerManager.getRootContext();
        DefinitionsNode definitionsNode = (DefinitionsNode)node.getLookup().lookup(DefinitionsNode.class);
        this.refreshNodes(node);
    }

    private void refreshNodes(Node node) {
        Children children;
        ExtensibilityElementNode extensibilityElementNode = (ExtensibilityElementNode)node.getLookup().lookup(ExtensibilityElementNode.class);
        if (extensibilityElementNode != null) {
            extensibilityElementNode.refresh();
        }
        if ((children = node.getChildren()) != null) {
            for (Node node2 : children.getNodes()) {
                this.refreshNodes(node2);
            }
        }
    }
}

