/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.ActionHelper;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions.WidgetEditCookie;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.border.FilledBorder;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.ButtonWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.DnDHandler;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.ImageLabelWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.MessageWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartnerScene;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.StubWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetConstants;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetFactory;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetFilterNode;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetHelper;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.MessageFolderNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class MessagesWidget
extends Widget
implements ActionListener,
DnDHandler,
PopupMenuProvider {
    private final WSDLModel model;
    private ImageLabelWidget headerLabel;
    private Widget headerWidget;
    private ButtonWidget addMessageButton;
    private Widget buttons;
    private final Widget contentWidget;
    private MessageHitPointWidget messageHitPoint;
    private int messageHitPointIndex = -1;
    private StubWidget stubWidget;
    private Node componentNode;
    public static final Border MAIN_BORDER = new FilledBorder(1, 1, 8, 8, new Color(0x888888), Color.WHITE);
    private static final Image IMAGE = Utilities.loadImage((String)"org/netbeans/modules/xml/wsdl/ui/view/resources/message.png");

    public MessagesWidget(Scene scene, WSDLModel wSDLModel) {
        super(scene);
        this.model = wSDLModel;
        this.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)15));
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.stubWidget = new StubWidget(scene, NbBundle.getMessage(MessagesWidget.class, (String)"LBL_MessagesWidget_ThereAreNoMessages"));
        this.stubWidget.setMinimumSize(new Dimension(550, 0));
        this.addMessageButton = new ButtonWidget(scene, NbBundle.getMessage(MessagesWidget.class, (String)"LBL_MessagesWidget_AddMessage"), true);
        this.addMessageButton.setActionListener(this);
        this.buttons = new Widget(scene);
        this.buttons.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)8));
        this.buttons.addChild((Widget)this.addMessageButton);
        this.headerWidget = new Widget(scene);
        this.headerWidget.setMinimumSize(new Dimension(700, 0));
        this.headerWidget.setLayout(WidgetConstants.HEADER_LAYOUT);
        this.headerWidget.setBorder(WidgetConstants.HEADER_BORDER);
        this.addChild(this.headerWidget);
        this.headerWidget.addChild(this.buttons);
        this.messageHitPoint = new MessageHitPointWidget(scene);
        this.messageHitPoint.setMinimumSize(new Dimension(550, 25));
        this.contentWidget = new Widget(scene);
        this.contentWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)16));
        this.addChild(this.contentWidget);
        this.getActions().addAction(((PartnerScene)scene).getDnDAction());
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this));
        this.createContent();
    }

    private void createContent() {
        LinkedList linkedList = this.model.getDefinitions().getMessages();
        if (linkedList == null) {
            linkedList = new LinkedList();
        }
        Scene scene = this.getScene();
        this.headerLabel = new ImageLabelWidget(scene, IMAGE, NbBundle.getMessage(MessagesWidget.class, (String)"LBL_MessagesWidget_Messages"), "(" + linkedList.size() + ")");
        this.headerWidget.addChild(0, (Widget)this.headerLabel);
        WidgetFactory widgetFactory = WidgetFactory.getInstance();
        if (linkedList.isEmpty()) {
            this.contentWidget.addChild((Widget)this.stubWidget);
        } else {
            for (Message message : linkedList) {
                Widget widget = widgetFactory.getOrCreateWidget(scene, (WSDLComponent)message, this.contentWidget);
                this.contentWidget.addChild(widget);
            }
        }
    }

    private void update() {
        this.stubWidget.removeFromParent();
        Collection collection = this.model.getDefinitions().getMessages();
        this.headerLabel.setComment("(" + collection.size() + ")");
        if (collection.isEmpty()) {
            this.contentWidget.addChild((Widget)this.stubWidget);
        }
    }

    void updateContent(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("message")) {
            this.update();
            Object object = propertyChangeEvent.getNewValue();
            if (object != null && object instanceof Message) {
                if (propertyChangeEvent.getOldValue() == null) {
                    Message message;
                    Message message2 = (Message)object;
                    Widget widget = WidgetFactory.getInstance().getOrCreateWidget(this.getScene(), (WSDLComponent)message2, this.contentWidget);
                    Collection collection = this.model.getDefinitions().getMessages();
                    int n = 0;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext() && (message = (Message)iterator.next()) != message2) {
                        ++n;
                    }
                    if (n > this.contentWidget.getChildren().size()) {
                        this.contentWidget.addChild(widget);
                    } else {
                        this.contentWidget.addChild(n, widget);
                    }
                }
            } else {
                object = propertyChangeEvent.getOldValue();
                if (object != null && object instanceof Message) {
                    WidgetHelper.removeObjectFromScene(this.getScene(), object);
                }
            }
            this.getScene().validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addMessageButton) {
            Object object;
            Message message = null;
            try {
                if (this.model.startTransaction()) {
                    message = this.model.getFactory().createMessage();
                    object = NameGenerator.getInstance();
                    message.setName(((NameGenerator)object).generateUniqueMessageName(this.model));
                    Part part = this.model.getFactory().createPart();
                    part.setName(((NameGenerator)object).generateUniqueMessagePartName(message));
                    message.addPart(part);
                    this.model.getDefinitions().addMessage(message);
                }
            }
            finally {
                this.model.endTransaction();
            }
            if (message != null) {
                ActionHelper.selectNode((WSDLComponent)message);
                object = (WidgetEditCookie)WidgetHelper.getWidgetLookup((WSDLComponent)message, this.getScene()).lookup(WidgetEditCookie.class);
                if (object != null) {
                    object.edit();
                }
            }
        }
    }

    public void dragExit() {
        this.hideHitPoint();
        this.getScene().validate();
    }

    public boolean dragOver(Point point, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
        Node node;
        Transferable transferable = widgetDropTargetDragEvent.getTransferable();
        if (transferable != null && (node = Utility.getPaletteNode(transferable)) != null && "Message".equals(node.getName())) {
            this.showHitPoint(point);
            this.getScene().validate();
            return true;
        }
        return false;
    }

    private boolean hasMessages() {
        Collection collection = this.model.getDefinitions().getMessages();
        if (collection == null) {
            return false;
        }
        return !collection.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop(Point point, WidgetAction.WidgetDropTargetDropEvent widgetDropTargetDropEvent) {
        int n = this.messageHitPointIndex;
        this.hideHitPoint();
        this.getScene().validate();
        if (n >= 0) {
            Object object;
            Message message = null;
            try {
                if (this.model.startTransaction()) {
                    object = this.model.getDefinitions().getMessages().toArray(new Message[0]);
                    NameGenerator nameGenerator = NameGenerator.getInstance();
                    message = this.model.getFactory().createMessage();
                    message.setName(nameGenerator.generateUniqueMessageName(this.model));
                    Part part = this.model.getFactory().createPart();
                    part.setName(nameGenerator.generateUniqueMessagePartName(message));
                    message.addPart(part);
                    if (n == ((Object)object).length) {
                        this.model.getDefinitions().addMessage(message);
                    } else {
                        Utility.insertIntoDefinitionsAtIndex(n, this.model, (WSDLComponent)message, "message");
                    }
                }
            }
            finally {
                this.model.endTransaction();
            }
            ActionHelper.selectNode(message);
            object = (WidgetEditCookie)WidgetHelper.getWidgetLookup(message, this.getScene()).lookup(WidgetEditCookie.class);
            if (object != null) {
                object.edit();
            }
            return true;
        }
        return false;
    }

    public boolean isCollapsed() {
        return !this.isVisible();
    }

    public void expandForDragAndDrop() {
        this.setVisible(true);
    }

    private void hideHitPoint() {
        this.messageHitPoint.removeFromParent();
        if (!this.hasMessages() && this.stubWidget.getParentWidget() == null) {
            this.contentWidget.addChild((Widget)this.stubWidget);
        }
        this.messageHitPointIndex = -1;
    }

    private void showHitPoint(Point point) {
        if (this.contentWidget.getParentWidget() == null) {
            return;
        }
        int n = this.placeHolderIndex(point);
        if (n < 0) {
            return;
        }
        this.messageHitPointIndex = n;
        this.messageHitPoint.removeFromParent();
        this.stubWidget.removeFromParent();
        this.contentWidget.addChild(this.messageHitPointIndex, (Widget)this.messageHitPoint);
    }

    private MessageWidget[] getMessageWidgets() {
        ArrayList<MessageWidget> arrayList = new ArrayList<MessageWidget>();
        for (Widget widget : this.contentWidget.getChildren()) {
            if (!(widget instanceof MessageWidget)) continue;
            arrayList.add((MessageWidget)widget);
        }
        return arrayList.toArray(new MessageWidget[arrayList.size()]);
    }

    private int placeHolderIndex(Point point) {
        MessageWidget[] messageWidgetArray = this.getMessageWidgets();
        if (messageWidgetArray == null) {
            return -1;
        }
        if (this.messageHitPoint.getParentWidget() != null && this.messageHitPoint.isHitAt(this.messageHitPoint.convertSceneToLocal(point))) {
            return -1;
        }
        for (int i = 0; i < messageWidgetArray.length; ++i) {
            MessageWidget messageWidget = messageWidgetArray[i];
            Point point2 = messageWidget.convertSceneToLocal(point);
            Rectangle rectangle = messageWidget.getBounds();
            if (!((double)point2.y < rectangle.getCenterY())) continue;
            return i;
        }
        return messageWidgetArray.length;
    }

    public Object hashKey() {
        return this.model.getDefinitions().getName();
    }

    protected TopComponent findTopComponent() {
        return (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.getScene().getView());
    }

    private synchronized Node getNode() {
        if (this.componentNode == null) {
            this.componentNode = new MessageFolderNode(this.model.getDefinitions());
            this.componentNode = new WidgetFilterNode(this.componentNode);
        }
        return this.componentNode;
    }

    public JPopupMenu getPopupMenu(Widget widget, Point point) {
        Node node = this.getNode();
        if (node != null) {
            Lookup lookup;
            TopComponent topComponent = this.findTopComponent();
            if (topComponent != null) {
                topComponent.setActivatedNodes(new Node[]{node});
                lookup = topComponent.getLookup();
            } else {
                lookup = Lookup.EMPTY;
            }
            Action[] actionArray = node.getActions(true);
            return Utilities.actionsToPopup((Action[])actionArray, (Lookup)lookup);
        }
        return null;
    }

    private static class MessageHitPointBorder
    implements Border {
        private MessageHitPointBorder() {
        }

        public Insets getInsets() {
            return new Insets(8, 8, 8, 8);
        }

        public void paint(Graphics2D graphics2D, Rectangle rectangle) {
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fill(rectangle);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setPaint(WidgetConstants.HIT_POINT_BORDER);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.drawRoundRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, 6, 6);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
        }

        public boolean isOpaque() {
            return true;
        }
    }

    private static class MessageHitPointWidget
    extends LabelWidget {
        public MessageHitPointWidget(Scene scene) {
            super(scene, " ");
            this.setFont(scene.getDefaultFont());
            this.setBorder(new MessageHitPointBorder());
        }
    }
}

