/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetConstants;

public class ArrowWidget
extends Widget {
    private int _width = -1;
    private int _height = 10;
    private int _x = 0;
    private int _y = 0;
    private int _thickness = 2;
    private Color _color = WidgetConstants.INPUT_OUTPUT_ARROW_COLOR;
    private boolean mToEast;
    private ParameterType _type;
    private Stroke _stroke;

    public ArrowWidget(Scene scene) {
        super(scene);
    }

    public ArrowWidget(Scene scene, boolean bl, ParameterType parameterType) {
        this(scene);
        this.mToEast = bl;
        this._type = parameterType;
        this._stroke = this._type == ParameterType.INPUT ? new BasicStroke(this._thickness) : new BasicStroke(this._thickness, 2, 1, 1.0f, new float[]{5.0f, 10.0f, 5.0f, 10.0f}, 0.0f);
    }

    protected Rectangle calculateClientArea() {
        Rectangle rectangle = super.calculateClientArea();
        rectangle.height = this._height;
        return rectangle;
    }

    protected void paintWidget() {
        Graphics2D graphics2D = this.getGraphics();
        this.drawArrow(graphics2D, this._x, this._y, this.getClientArea().width, this._height, this._color, this._stroke);
    }

    private void drawArrow(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Stroke stroke) {
        double d = Math.sqrt(n4 * n4 * 5 / 4);
        int n5 = new Double(d).intValue();
        int n6 = n;
        int n7 = n3 - n5;
        if (!this.mToEast) {
            n6 = n + n5;
        }
        Color color2 = graphics2D.getColor();
        Stroke stroke2 = graphics2D.getStroke();
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
        int n8 = n2 + n4 / 2;
        graphics2D.drawLine(n6, n8, n6 + n7, n8);
        Polygon polygon = new Polygon();
        int n9 = this.mToEast ? n + n7 : n + n5;
        int n10 = this.mToEast ? n + n3 : n;
        int n11 = n2;
        int n12 = n2 + n4;
        int n13 = n2 + n4 / 2;
        polygon.addPoint(n9, n11);
        polygon.addPoint(n10, n13);
        polygon.addPoint(n9, n12);
        graphics2D.fillPolygon(polygon);
        graphics2D.setColor(color2);
        graphics2D.setStroke(stroke2);
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public int getHeight() {
        return this._height;
    }

    public void setHeight(int n) {
        this._height = n;
    }

    public int getThickness() {
        return this._thickness;
    }

    public void setThickness(int n) {
        this._thickness = n;
    }

    public int getWidth() {
        return this._width;
    }

    public void setWidth(int n) {
        this._width = n;
    }

    public int getX() {
        return this._x;
    }

    public void setX(int n) {
        this._x = n;
    }

    public int getY() {
        return this._y;
    }

    public void setY(int n) {
        this._y = n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParameterType {
        INPUT,
        OUTPUT,
        FAULT;

    }
}

