/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.border;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import org.netbeans.api.visual.border.Border;

public class GradientFillBorder
implements Border {
    private Insets borderWidth;
    private Insets padding;
    private Color borderColor;
    private Color gradientTopColor;
    private Color gradientBottomColor;

    public GradientFillBorder(int n, int n2, int n3, int n4, Color color, Color color2, Color color3) {
        this.borderWidth = new Insets(n, n2, n, n2);
        this.padding = new Insets(n3, n4, n3, n4);
        this.borderColor = color;
        this.gradientTopColor = color2;
        this.gradientBottomColor = color3;
    }

    public GradientFillBorder(Insets insets, Insets insets2, Color color, Color color2, Color color3) {
        this.borderWidth = (Insets)insets.clone();
        this.padding = (Insets)insets2.clone();
        this.borderColor = color;
        this.gradientTopColor = color2;
        this.gradientBottomColor = color3;
    }

    public Insets getInsets() {
        return new Insets(this.borderWidth.top + this.padding.top, this.borderWidth.left + this.padding.left, this.borderWidth.bottom + this.padding.bottom, this.borderWidth.right + this.padding.right);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        Paint paint = graphics2D.getPaint();
        if (this.borderColor != null) {
            graphics2D.setPaint(this.borderColor);
            graphics2D.fill(rectangle);
        }
        if (this.gradientTopColor != null && this.gradientBottomColor != null) {
            int n = rectangle.y + this.borderWidth.top;
            int n2 = rectangle.y + rectangle.height - this.borderWidth.bottom;
            graphics2D.setPaint(new GradientPaint(0.0f, n, this.gradientTopColor, 0.0f, n2, this.gradientBottomColor, false));
            graphics2D.fillRect(rectangle.x + this.borderWidth.left, n, rectangle.width - this.borderWidth.left - this.borderWidth.right, n2 - n);
        }
        graphics2D.setPaint(paint);
    }

    public boolean isOpaque() {
        return true;
    }
}

