/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.border;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import org.netbeans.api.visual.border.Border;

public class FilledBorder
implements Border {
    private Insets borderWidth;
    private Insets padding;
    private Color borderColor;
    private Color fillColor;

    public FilledBorder(int n, int n2, int n3, int n4, Color color, Color color2) {
        this.borderWidth = new Insets(n, n2, n, n2);
        this.padding = new Insets(n3, n4, n3, n4);
        this.borderColor = color;
        this.fillColor = color2;
    }

    public FilledBorder(Insets insets, Insets insets2, Color color, Color color2) {
        this.borderWidth = (Insets)insets.clone();
        this.padding = (Insets)insets2.clone();
        this.borderColor = color;
        this.fillColor = color2;
    }

    public Insets getInsets() {
        return new Insets(this.borderWidth.top + this.padding.top, this.borderWidth.left + this.padding.left, this.borderWidth.bottom + this.padding.bottom, this.borderWidth.right + this.padding.right);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        Paint paint = graphics2D.getPaint();
        if (this.borderColor != null) {
            graphics2D.setPaint(this.borderColor);
            graphics2D.fill(rectangle);
        }
        if (this.fillColor != null) {
            graphics2D.setPaint(this.fillColor);
            graphics2D.fillRect(rectangle.x + this.borderWidth.left, rectangle.y + this.borderWidth.top, rectangle.width - this.borderWidth.left - this.borderWidth.right, rectangle.height - this.borderWidth.top - this.borderWidth.bottom);
        }
        graphics2D.setPaint(paint);
    }

    public boolean isOpaque() {
        return true;
    }
}

