/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.border;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import org.netbeans.api.visual.border.Border;

public class ButtonBorder
implements Border {
    private int top;
    private int left;
    private int bottom;
    private int right;
    private static final Color BUTTON_BORDER_COLOR = new Color(8363449);
    private static final Color BUTTON_BACKGROUND_COLOR = new Color(0xEBEBE4);

    public ButtonBorder(int n, int n2, int n3, int n4) {
        this.top = n;
        this.left = n2;
        this.bottom = n3;
        this.right = n4;
    }

    public Insets getInsets() {
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(BUTTON_BORDER_COLOR);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setPaint(BUTTON_BACKGROUND_COLOR);
        graphics2D.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        graphics2D.setPaint(paint);
    }

    public boolean isOpaque() {
        return true;
    }

    public static ButtonBorder createTextButtonBorder() {
        return new ButtonBorder(2, 8, 2, 8);
    }

    public static ButtonBorder createImageButtonBorder() {
        return new ButtonBorder(2, 2, 2, 2);
    }
}

