/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.util.List;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions.DragDropDecorator;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.DnDHandler;

public class DragDropAction
extends WidgetAction.LockedAdapter {
    private static final int MIN_DIFFERENCE = 5;
    private DragDropDecorator decorator;
    private Widget interractionLayer;
    private ConnectProvider provider;
    private Widget dragWidget = null;
    private Widget sourceWidget = null;
    private Widget targetWidget = null;
    private Point startingPoint = null;
    private Cursor cursor = null;

    public DragDropAction(DragDropDecorator dragDropDecorator, Widget widget, ConnectProvider connectProvider) {
        this.decorator = dragDropDecorator;
        this.interractionLayer = widget;
        this.provider = connectProvider;
    }

    protected boolean isLocked() {
        return this.sourceWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        if (widgetMouseEvent.getButton() == 1 && widgetMouseEvent.getClickCount() == 1 && this.provider.isSourceWidget(widget)) {
            this.sourceWidget = widget;
            this.targetWidget = null;
            this.startingPoint = new Point(widgetMouseEvent.getPoint());
            this.dragWidget = this.decorator.createDragWidget(this.interractionLayer.getScene());
            assert (this.dragWidget != null);
            Point point = widget.convertLocalToScene(widgetMouseEvent.getPoint());
            point.x += 16;
            this.dragWidget.setPreferredLocation(this.interractionLayer.convertSceneToLocal(point));
            this.interractionLayer.addChild(this.dragWidget);
            this.cursor = widget.getScene().getView().getCursor();
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        Point point = widgetMouseEvent.getPoint();
        boolean bl = this.move(widget, point);
        if (bl && this.targetWidget != null && (Math.abs(this.startingPoint.x - point.x) >= 5 || Math.abs(this.startingPoint.y - point.y) >= 5)) {
            this.provider.createConnection(this.sourceWidget, this.targetWidget);
        }
        this.cancel();
        return bl ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    private void cancel() {
        this.sourceWidget = null;
        this.targetWidget = null;
        this.startingPoint = null;
        this.dragWidget.getScene().getView().setCursor(this.cursor);
        this.dragWidget.removeFromParent();
        this.dragWidget = null;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        return this.move(widget, widgetMouseEvent.getPoint()) ? WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this) : WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point point) {
        if (this.sourceWidget != widget) {
            return false;
        }
        Point point2 = widget.convertLocalToScene(point);
        this.targetWidget = this.resolveTargetWidgetCore(this.interractionLayer.getScene(), point2);
        Point point3 = new Point(point2);
        point3.x += 16;
        this.dragWidget.setPreferredLocation(this.interractionLayer.convertSceneToLocal(point3));
        return true;
    }

    private Widget resolveTargetWidgetCore(Scene scene, Point point) {
        if (this.provider != null && this.provider.hasCustomTargetWidgetResolver(scene)) {
            return this.provider.resolveTargetWidget(scene, point);
        }
        Point point2 = scene.getLocation();
        point = new Point(point.x + point2.x, point.y + point2.y);
        Widget[] widgetArray = new Widget[]{null};
        this.resolveTargetWidgetCoreDive(widgetArray, (Widget)scene, point);
        return widgetArray[0];
    }

    private boolean resolveTargetWidgetCoreDive(Widget[] widgetArray, Widget widget, Point point) {
        if (this.interractionLayer.equals((Object)widget)) {
            return false;
        }
        Point point2 = widget.getLocation();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        if (!widget.getBounds().contains(point3)) {
            return false;
        }
        List list = widget.getChildren();
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!this.resolveTargetWidgetCoreDive(widgetArray, (Widget)list.get(i), point3)) continue;
            return true;
        }
        if (!widget.isHitAt(point3)) {
            return false;
        }
        ConnectorState connectorState = this.provider.isTargetWidget(this.sourceWidget, widget);
        if (connectorState == ConnectorState.REJECT) {
            DnDHandler dnDHandler;
            if (widget instanceof DnDHandler && (dnDHandler = (DnDHandler)widget).isCollapsed()) {
                dnDHandler.expandForDragAndDrop();
            }
            widget.getScene().getView().setCursor(DragSource.DefaultMoveNoDrop);
            return false;
        }
        if (connectorState == ConnectorState.ACCEPT) {
            widget.getScene().getView().setCursor(DragSource.DefaultMoveDrop);
            widgetArray[0] = widget;
        }
        return true;
    }

    public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
        if (this.isLocked() && widgetKeyEvent.getKeyCode() == 27) {
            this.cancel();
            return WidgetAction.State.CONSUMED;
        }
        return super.keyPressed(widget, widgetKeyEvent);
    }
}

