/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EnumSet;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions.ComboBoxInplaceEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComboBoxInplaceEditorProvider
implements InplaceEditorProvider<JComboBox> {
    private ComboBoxInplaceEditor localEditor;
    private EnumSet<InplaceEditorProvider.ExpansionDirection> expansionDirections;
    private FocusListener focusListener;
    private KeyListener keyListener;

    public ComboBoxInplaceEditorProvider(ComboBoxInplaceEditor comboBoxInplaceEditor, EnumSet<InplaceEditorProvider.ExpansionDirection> enumSet) {
        this.localEditor = comboBoxInplaceEditor;
        this.expansionDirections = enumSet;
    }

    public JComboBox createEditorComponent(InplaceEditorProvider.EditorController editorController, Widget widget) {
        if (!this.localEditor.isEnabled(widget)) {
            return null;
        }
        ComboBoxModel comboBoxModel = this.localEditor.getModel();
        JComboBox jComboBox = new JComboBox(comboBoxModel);
        jComboBox.setEditable(this.localEditor.getEditable());
        jComboBox.setPreferredSize(widget.getBounds().getSize());
        return jComboBox;
    }

    public void notifyOpened(final InplaceEditorProvider.EditorController editorController, Widget widget, JComboBox jComboBox) {
        jComboBox.setMinimumSize(new Dimension(64, 19));
        this.keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        keyEvent.consume();
                        editorController.closeEditor(false);
                        break;
                    }
                    case 10: {
                        keyEvent.consume();
                        editorController.closeEditor(true);
                    }
                }
            }
        };
        jComboBox.addKeyListener(this.keyListener);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                editorController.closeEditor(true);
            }
        });
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                editorController.closeEditor(true);
            }
        };
        jComboBox.addFocusListener(focusAdapter);
    }

    public void notifyClosing(InplaceEditorProvider.EditorController editorController, Widget widget, JComboBox jComboBox, boolean bl) {
        jComboBox.removeKeyListener(this.keyListener);
        if (bl && widget != null) {
            widget.revalidate();
            widget.getScene().validate();
        }
        this.localEditor.setSelectedItem(jComboBox.getSelectedItem());
    }

    public EnumSet<InplaceEditorProvider.ExpansionDirection> getExpansionDirections(InplaceEditorProvider.EditorController editorController, Widget widget, JComboBox jComboBox) {
        return this.expansionDirections;
    }

    public Rectangle getInitialEditorComponentBounds(InplaceEditorProvider.EditorController editorController, Widget widget, JComboBox jComboBox, Rectangle rectangle) {
        return null;
    }
}

