/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.OperationWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartnerLinkTypeContentWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.RectangleWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.RoleWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetConstants;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetFactory;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetHelper;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationSceneLayer
extends Widget {
    private static final int OPERATION_GAP = 25;
    private final PartnerLinkTypeContentWidget mOuterWidget;
    private Widget rightHitPointOperationWidget;
    private PortType leftPortType;
    private PortType rightPortType;
    private Widget dummyEndWidget;
    private final Widget rightsideWidgetsHolder;
    private final Widget leftsideWidgetsHolder;
    private Widget leftHitPointOperationWidget;

    public OperationSceneLayer(Scene scene, PartnerLinkTypeContentWidget partnerLinkTypeContentWidget) {
        super(scene);
        this.mOuterWidget = partnerLinkTypeContentWidget;
        this.rightPortType = this.getPortType(this.mOuterWidget.getRightRoleWidget());
        this.leftPortType = this.getPortType(this.mOuterWidget.getLeftRoleWidget());
        Layout layout = LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)25);
        this.setLayout(layout);
        this.rightsideWidgetsHolder = new Widget(this.getScene());
        this.rightsideWidgetsHolder.setLayout(layout);
        this.addChild(this.rightsideWidgetsHolder);
        this.leftsideWidgetsHolder = new Widget(this.getScene());
        this.leftsideWidgetsHolder.setLayout(layout);
        this.addChild(this.leftsideWidgetsHolder);
        this.init();
    }

    private void init() {
        this.rightHitPointOperationWidget = new Widget(this.getScene());
        Border border = BorderFactory.createEmptyBorder((int)3);
        RectangleWidget rectangleWidget = new RectangleWidget(this.getScene(), 12, 70);
        rectangleWidget.setThickness(4);
        rectangleWidget.setColor(WidgetConstants.HIT_POINT_BORDER);
        Layout layout = LayoutFactory.createHorizontalFlowLayout();
        this.rightHitPointOperationWidget.setLayout(layout);
        this.rightHitPointOperationWidget.setBorder(border);
        this.rightHitPointOperationWidget.addChild(new Widget(this.getScene()), (Object)1);
        this.rightHitPointOperationWidget.addChild((Widget)rectangleWidget);
        this.leftHitPointOperationWidget = new Widget(this.getScene());
        RectangleWidget rectangleWidget2 = new RectangleWidget(this.getScene(), 12, 70);
        rectangleWidget2.setThickness(4);
        rectangleWidget2.setColor(WidgetConstants.HIT_POINT_BORDER);
        this.leftHitPointOperationWidget.setLayout(layout);
        this.leftHitPointOperationWidget.setBorder(border);
        this.leftHitPointOperationWidget.addChild((Widget)rectangleWidget2);
        this.leftHitPointOperationWidget.addChild(new Widget(this.getScene()), (Object)1);
        this.dummyEndWidget = new Widget(this.getScene());
        this.dummyEndWidget.setMinimumSize(new Dimension(0, 25));
        this.refreshOperations();
    }

    private void refreshOperations() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OperationSceneLayer.this.rightsideWidgetsHolder.removeChildren();
                OperationSceneLayer.this.leftsideWidgetsHolder.removeChildren();
                OperationSceneLayer.this.dummyEndWidget.removeFromParent();
                OperationSceneLayer.this.clearHotSpot();
                OperationSceneLayer.this.mOuterWidget.revalidate();
                OperationSceneLayer.this.renderOperations(true);
                OperationSceneLayer.this.renderOperations(false);
                OperationSceneLayer.this.addChild(OperationSceneLayer.this.dummyEndWidget);
                OperationSceneLayer.this.getScene().validate();
            }
        });
    }

    public void showHotSpot(boolean bl) {
        this.showBlankWidget(bl);
    }

    public void clearHotSpot() {
        this.removeBlankWidget();
    }

    private void renderOperations(boolean bl) {
        Widget widget;
        PortType portType = bl ? this.rightPortType : this.leftPortType;
        Widget widget2 = widget = bl ? this.rightsideWidgetsHolder : this.leftsideWidgetsHolder;
        if (portType != null) {
            Collection collection = portType.getOperations();
            WidgetFactory widgetFactory = WidgetFactory.getInstance();
            ArrayList<OperationWidget> arrayList = new ArrayList<OperationWidget>();
            for (Operation operation : collection) {
                OperationWidget operationWidget = (OperationWidget)widgetFactory.getOrCreateWidget(this.getScene(), (WSDLComponent)operation, widget);
                operationWidget.setRightSided(bl);
                arrayList.add(operationWidget);
            }
            this.addChildren(arrayList, bl);
        }
    }

    private void addChildren(Collection<? extends Widget> collection, boolean bl) {
        Widget widget = null;
        widget = bl ? this.rightsideWidgetsHolder : this.leftsideWidgetsHolder;
        if (widget == null) {
            return;
        }
        for (Widget widget2 : collection) {
            widget.addChild(widget2);
        }
    }

    private PortType getPortType(RoleWidget roleWidget) {
        try {
            NamedComponentReference namedComponentReference;
            Role role;
            if (roleWidget != null && (role = (Role)roleWidget.getWSDLComponent()) != null && (namedComponentReference = role.getPortType()) != null) {
                return (PortType)namedComponentReference.get();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    public void showBlankWidget(boolean bl) {
        this.removeBlankWidget();
        this.dummyEndWidget.removeFromParent();
        if (bl) {
            this.rightsideWidgetsHolder.addChild(this.rightHitPointOperationWidget);
        } else {
            this.leftsideWidgetsHolder.addChild(this.leftHitPointOperationWidget);
        }
        this.addChild(this.dummyEndWidget);
    }

    public void removeBlankWidget() {
        this.rightHitPointOperationWidget.removeFromParent();
        this.leftHitPointOperationWidget.removeFromParent();
    }

    public void updateOperations(boolean bl) {
        if (bl) {
            PortType portType = this.getPortType(this.mOuterWidget.getRightRoleWidget());
            if (this.rightPortType != portType) {
                WidgetHelper.removeWidgetFromScene(this.getScene(), this.rightsideWidgetsHolder);
                this.rightPortType = portType;
                if (portType != null) {
                    this.renderOperations(bl);
                }
            } else {
                this.rightsideWidgetsHolder.removeChildren();
                this.renderOperations(bl);
            }
        } else {
            PortType portType = this.getPortType(this.mOuterWidget.getLeftRoleWidget());
            if (this.leftPortType != portType) {
                WidgetHelper.removeWidgetFromScene(this.getScene(), this.leftsideWidgetsHolder);
                this.leftsideWidgetsHolder.removeChildren();
                this.leftPortType = portType;
                if (portType != null) {
                    this.renderOperations(bl);
                }
            } else {
                this.leftsideWidgetsHolder.removeChildren();
                this.renderOperations(bl);
            }
        }
    }
}

