/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.search;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.visitor.ChildVisitor;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLVisitor;
import org.netbeans.modules.xml.wsdl.ui.search.Providers;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.ui.category.Category;
import org.netbeans.modules.xml.xam.ui.search.Query;
import org.netbeans.modules.xml.xam.ui.search.SearchException;
import org.netbeans.modules.xml.xam.ui.search.SearchProvider;
import org.netbeans.modules.xml.xam.ui.search.WildcardStringMatcher;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentNameSearchProvider
extends ChildVisitor
implements SearchProvider {
    private String phrase;
    private boolean wildcarded;
    private WSDLModel model;
    private List<Object> results;
    private Category category;
    private Pattern pattern;

    public ComponentNameSearchProvider(WSDLModel wSDLModel, Category category) {
        this.model = wSDLModel;
        this.category = category;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ComponentNameSearchProvider.class, (String)"LBL_SearchProvider_ComponentName");
    }

    public String getInputDescription() {
        return NbBundle.getMessage(ComponentNameSearchProvider.class, (String)"HELP_SearchProvider_ComponentName");
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ComponentNameSearchProvider.class, (String)"HINT_SearchProvider_ComponentName");
    }

    public List<Object> search(Query query) throws SearchException {
        if (query.isRegularExpression()) {
            try {
                this.pattern = Pattern.compile(query.getQuery());
                this.phrase = null;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SearchException(patternSyntaxException.getMessage(), (Throwable)patternSyntaxException);
            }
        } else {
            this.pattern = null;
            this.phrase = query.getQuery().toLowerCase();
            this.wildcarded = WildcardStringMatcher.containsWildcards((String)this.phrase);
        }
        this.results = new ArrayList<Object>();
        if (query.useSelected()) {
            WSDLComponent wSDLComponent = Providers.getSelectedComponent(this.category);
            if (wSDLComponent != null) {
                wSDLComponent.accept((WSDLVisitor)this);
            } else {
                Class<? extends WSDLComponent> clazz = Providers.getSelectedChildType(this.category);
                if (clazz != null) {
                    List list = this.model.getDefinitions().getChildren(clazz);
                    for (WSDLComponent wSDLComponent2 : list) {
                        wSDLComponent2.accept((WSDLVisitor)this);
                    }
                }
            }
        } else {
            this.model.getDefinitions().accept((WSDLVisitor)this);
        }
        return this.results;
    }

    protected void visitComponent(WSDLComponent wSDLComponent) {
        Named named;
        String string;
        if (wSDLComponent instanceof Named && (string = (named = (Named)wSDLComponent).getName()) != null) {
            Matcher matcher;
            if (this.phrase != null) {
                string = string.toLowerCase();
                if (this.wildcarded) {
                    if (WildcardStringMatcher.match((String)string, (String)this.phrase)) {
                        this.results.add(wSDLComponent);
                    }
                } else if (string.indexOf(this.phrase) > -1) {
                    this.results.add(wSDLComponent);
                }
            } else if (this.pattern != null && (matcher = this.pattern.matcher(string)).find()) {
                this.results.add(wSDLComponent);
            }
        }
        super.visitComponent(wSDLComponent);
    }
}

