/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.search;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.visitor.ChildVisitor;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLVisitor;
import org.netbeans.modules.xml.wsdl.ui.search.Providers;
import org.netbeans.modules.xml.xam.ui.category.Category;
import org.netbeans.modules.xml.xam.ui.search.Query;
import org.netbeans.modules.xml.xam.ui.search.SearchException;
import org.netbeans.modules.xml.xam.ui.search.SearchProvider;
import org.netbeans.modules.xml.xam.ui.search.WildcardStringMatcher;
import org.openide.util.NbBundle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueSearchProvider
extends ChildVisitor
implements SearchProvider {
    private WSDLModel model;
    private List<Object> results;
    private Category category;
    private String phrase;
    private boolean wildcarded;
    private Pattern pattern;

    public AttributeValueSearchProvider(WSDLModel wSDLModel, Category category) {
        this.model = wSDLModel;
        this.category = category;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AttributeValueSearchProvider.class, (String)"LBL_SearchProvider_AttributeValue");
    }

    public String getInputDescription() {
        return NbBundle.getMessage(AttributeValueSearchProvider.class, (String)"HELP_SearchProvider_AttributeValue");
    }

    public String getShortDescription() {
        return NbBundle.getMessage(AttributeValueSearchProvider.class, (String)"HINT_SearchProvider_AttributeValue");
    }

    public List<Object> search(Query query) throws SearchException {
        if (query.isRegularExpression()) {
            try {
                this.pattern = Pattern.compile(query.getQuery());
                this.phrase = null;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SearchException(patternSyntaxException.getMessage(), (Throwable)patternSyntaxException);
            }
        } else {
            this.pattern = null;
            this.phrase = query.getQuery().toLowerCase();
            this.wildcarded = WildcardStringMatcher.containsWildcards((String)this.phrase);
        }
        this.results = new ArrayList<Object>();
        if (query.useSelected()) {
            WSDLComponent wSDLComponent = Providers.getSelectedComponent(this.category);
            if (wSDLComponent != null) {
                wSDLComponent.accept((WSDLVisitor)this);
            } else {
                Class<? extends WSDLComponent> clazz = Providers.getSelectedChildType(this.category);
                if (clazz != null) {
                    List list = this.model.getDefinitions().getChildren(clazz);
                    for (WSDLComponent wSDLComponent2 : list) {
                        wSDLComponent2.accept((WSDLVisitor)this);
                    }
                }
            }
        } else {
            this.model.getDefinitions().accept((WSDLVisitor)this);
        }
        return this.results;
    }

    protected void visitComponent(WSDLComponent wSDLComponent) {
        NamedNodeMap namedNodeMap = wSDLComponent.getPeer().getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Matcher matcher;
            Node node = namedNodeMap.item(i);
            String string = node.getNodeValue();
            if (this.phrase != null) {
                string = string.toLowerCase();
                if (this.wildcarded) {
                    if (!WildcardStringMatcher.match((String)string, (String)this.phrase)) continue;
                    this.results.add(wSDLComponent);
                    continue;
                }
                if (string.indexOf(this.phrase) <= -1) continue;
                this.results.add(wSDLComponent);
                break;
            }
            if (this.pattern == null || !(matcher = this.pattern.matcher(string)).find()) continue;
            this.results.add(wSDLComponent);
            break;
        }
        super.visitComponent(wSDLComponent);
    }
}

