/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.schema.visitor;

import java.util.Collection;
import java.util.Locale;
import org.netbeans.modules.xml.schema.model.Annotation;
import org.netbeans.modules.xml.schema.model.Documentation;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalComplexType;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.LocalSimpleType;
import org.netbeans.modules.xml.wsdl.ui.model.StringAttribute;
import org.netbeans.modules.xml.wsdl.ui.schema.visitor.AbstractXSDVisitor;
import org.netbeans.modules.xml.xam.dom.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaDocumentationFinderVisitor
extends AbstractXSDVisitor {
    private StringBuffer mDocumentationBuf = new StringBuffer(40);
    private static StringAttribute xmlLangAttribute = new StringAttribute("xml:lang");
    private String xmlLangValue = this.convertLocaleToXmlLangValue();

    public String getDocumentation() {
        return this.mDocumentationBuf.toString();
    }

    @Override
    public void visit(LocalAttribute localAttribute) {
        Annotation annotation = localAttribute.getAnnotation();
        if (annotation != null) {
            this.visit(annotation);
        } else if (localAttribute.getType() != null) {
            this.visit((GlobalSimpleType)localAttribute.getType().get());
        } else if (localAttribute.getInlineType() != null) {
            this.visit(localAttribute.getInlineType());
        }
    }

    @Override
    public void visit(GlobalAttribute globalAttribute) {
        Annotation annotation = globalAttribute.getAnnotation();
        if (annotation != null) {
            this.visit(annotation);
        } else if (globalAttribute.getType() != null) {
            this.visit((GlobalSimpleType)globalAttribute.getType().get());
        } else if (globalAttribute.getInlineType() != null) {
            this.visit(globalAttribute.getInlineType());
        }
    }

    @Override
    public void visit(GlobalElement globalElement) {
        Annotation annotation = globalElement.getAnnotation();
        if (annotation != null) {
            this.visit(annotation);
        } else if (globalElement.getType() != null) {
            this.visit((GlobalType)globalElement.getType().get());
        } else if (globalElement.getInlineType() != null) {
            this.visit(globalElement.getInlineType());
        }
    }

    @Override
    public void visit(LocalElement localElement) {
        Annotation annotation = localElement.getAnnotation();
        if (annotation != null) {
            this.visit(annotation);
        } else if (localElement.getType() != null) {
            this.visit((GlobalType)localElement.getType().get());
        } else if (localElement.getInlineType() != null) {
            this.visit(localElement.getInlineType());
        }
    }

    @Override
    public void visit(GlobalComplexType globalComplexType) {
        Annotation annotation = globalComplexType.getAnnotation();
        if (annotation != null) {
            this.visit(annotation);
        }
    }

    @Override
    public void visit(GlobalSimpleType globalSimpleType) {
        Annotation annotation;
        if (globalSimpleType != null && (annotation = globalSimpleType.getAnnotation()) != null) {
            this.visit(annotation);
        }
    }

    @Override
    public void visit(LocalComplexType localComplexType) {
        Annotation annotation = localComplexType.getAnnotation();
        if (annotation != null) {
            this.visit(annotation);
        }
    }

    @Override
    public void visit(LocalSimpleType localSimpleType) {
        Annotation annotation = localSimpleType.getAnnotation();
        if (annotation != null) {
            this.visit(annotation);
        }
    }

    @Override
    public void visit(Annotation annotation) {
        this.visitLocalizedDocumentation(annotation);
    }

    @Override
    public void visit(Documentation documentation) {
        String string = documentation.getContent();
        if (string != null) {
            string = string.trim();
            this.mDocumentationBuf.append(string);
        }
    }

    private void visitLocalizedDocumentation(Annotation annotation) {
        boolean bl = false;
        Collection collection = annotation.getDocumentationElements();
        if (collection != null) {
            for (Documentation documentation : collection) {
                String string = documentation.getAttribute((Attribute)xmlLangAttribute);
                if (string == null || !string.equals(this.xmlLangValue)) continue;
                this.visit(documentation);
                bl = true;
                break;
            }
            if (!bl && collection.size() > 0) {
                this.visitDefaultDocumentation(collection);
            }
        }
    }

    private String convertLocaleToXmlLangValue() {
        StringBuffer stringBuffer = new StringBuffer(15);
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        if (string != null && !string.trim().equals("")) {
            stringBuffer.append(string);
        }
        if (string2 != null && !string2.trim().equals("")) {
            stringBuffer.append("-");
            stringBuffer.append(string2);
        }
        if (string3 != null && !string3.trim().equals("")) {
            stringBuffer.append("-");
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private void visitDefaultDocumentation(Collection<Documentation> collection) {
        if (collection != null) {
            for (Documentation documentation : collection) {
                String string = documentation.getAttribute((Attribute)xmlLangAttribute);
                if (string != null && !string.trim().equals("")) continue;
                this.visit(documentation);
                break;
            }
        }
    }
}

