/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.netbeans.module;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.UIUtilities;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLDataObject;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLEditorSupport;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLMultiViewFactory;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.ui.cookies.ViewComponentCookie;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLMultiViewSupport
implements ViewComponentCookie,
ShowCookie {
    private WSDLDataObject dobj;
    private final Class[] DESIGNABLE_COMPONENTS = new Class[]{Message.class, Operation.class, OperationParameter.class, Part.class, PortType.class, PartnerLinkType.class, Role.class};

    public WSDLMultiViewSupport(WSDLDataObject wSDLDataObject) {
        this.dobj = wSDLDataObject;
    }

    public void view(final ViewComponentCookie.View view, final Component component, final Object ... objectArray) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    WSDLMultiViewSupport.this.viewInSwingThread(view, component, objectArray);
                }
            });
        } else {
            this.viewInSwingThread(view, component, objectArray);
        }
    }

    private void viewInSwingThread(ViewComponentCookie.View view, Component component, Object ... objectArray) {
        if (this.canView(view, component)) {
            WSDLEditorSupport wSDLEditorSupport = this.dobj.getWSDLEditorSupport();
            wSDLEditorSupport.open();
            if (view != null) {
                switch (view) {
                    case SOURCE: {
                        WSDLMultiViewFactory.requestMultiviewActive("wsdl-sourceview");
                        break;
                    }
                    case STRUCTURE: {
                        WSDLMultiViewFactory.requestMultiviewActive("wsdl-treeview");
                        break;
                    }
                    case DESIGN: {
                        WSDLMultiViewFactory.requestMultiviewActive("wsdl-designview");
                    }
                }
            }
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            ShowCookie showCookie = (ShowCookie)topComponent.getLookup().lookup(ShowCookie.class);
            Validator.ResultItem resultItem = null;
            if (objectArray != null && objectArray.length != 0) {
                for (Object object : objectArray) {
                    if (!(object instanceof Validator.ResultItem)) continue;
                    resultItem = (Validator.ResultItem)object;
                    break;
                }
            }
            if (showCookie != null && component != null) {
                if (resultItem == null) {
                    resultItem = new Validator.ResultItem(null, null, component, null);
                }
                showCookie.show(resultItem);
            }
        }
    }

    public boolean canView(ViewComponentCookie.View view, Component component) {
        if (view != null) {
            switch (view) {
                case SOURCE: {
                    if ("wsdl-sourceview".equals(WSDLMultiViewSupport.getMultiviewActive()) && WSDLMultiViewSupport.getActiveComponents().contains(component)) break;
                    return true;
                }
                case STRUCTURE: {
                    if (!(component instanceof SchemaComponent) && !(component instanceof WSDLComponent)) {
                        return false;
                    }
                    if ("wsdl-treeview".equals(WSDLMultiViewSupport.getMultiviewActive()) && WSDLMultiViewSupport.getActiveComponents().contains(component)) {
                        TopComponent topComponent = TopComponent.getRegistry().getActivated();
                        WSDLDataObject wSDLDataObject = (WSDLDataObject)((Object)topComponent.getLookup().lookup(WSDLDataObject.class));
                        return wSDLDataObject != this.dobj;
                    }
                    return true;
                }
                case CURRENT: 
                case SUPER: {
                    return true;
                }
                case DESIGN: {
                    boolean bl = false;
                    for (Class clazz : this.DESIGNABLE_COMPONENTS) {
                        if (!clazz.isInstance(component)) continue;
                        bl = true;
                        break;
                    }
                    if ("wsdl-designview".equals(WSDLMultiViewSupport.getMultiviewActive()) && WSDLMultiViewSupport.getActiveComponents().contains(component) && bl) {
                        TopComponent topComponent = TopComponent.getRegistry().getActivated();
                        WSDLDataObject wSDLDataObject = (WSDLDataObject)((Object)topComponent.getLookup().lookup(WSDLDataObject.class));
                        return wSDLDataObject != this.dobj;
                    }
                    return bl;
                }
            }
        }
        return false;
    }

    public void show(Validator.ResultItem resultItem) {
        Component component = resultItem.getComponents();
        if (component == null || component.getModel() == null || component.getModel().getState() == Model.State.NOT_WELL_FORMED) {
            this.view(ViewComponentCookie.View.SOURCE, component, resultItem);
        } else {
            String string;
            if (component instanceof DocumentComponent) {
                UIUtilities.annotateSourceView(this.dobj, (DocumentComponent)component, resultItem.getDescription(), false);
            }
            if ("wsdl-treeview".equals(string = WSDLMultiViewSupport.getMultiviewActive())) {
                this.view(ViewComponentCookie.View.STRUCTURE, component, resultItem);
            } else if ("wsdl-sourceview".equals(string)) {
                this.view(ViewComponentCookie.View.SOURCE, component, resultItem);
            } else if ("wsdl-designview".equals(string)) {
                if (this.canView(ViewComponentCookie.View.DESIGN, component)) {
                    this.view(ViewComponentCookie.View.DESIGN, component, resultItem);
                } else {
                    this.view(ViewComponentCookie.View.STRUCTURE, component, resultItem);
                }
            }
        }
    }

    private static String getMultiviewActive() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler != null) {
            return multiViewHandler.getSelectedPerspective().preferredID();
        }
        return null;
    }

    private static Collection<Component> getActiveComponents() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        Set<Component> set = Collections.emptySet();
        for (Node node : topComponent.getActivatedNodes()) {
            Component component = (Component)node.getLookup().lookup(Component.class);
            if (component == null) continue;
            if (set.isEmpty()) {
                set = new HashSet<Component>();
            }
            set.add(component);
        }
        return set;
    }
}

