/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.netbeans.module;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLColumnsView;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.DefinitionsNode;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.DummyDefinitionsNode;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.FolderNode;
import org.netbeans.modules.xml.xam.ui.column.Column;
import org.netbeans.modules.xml.xam.ui.column.ColumnListCellRenderer;
import org.netbeans.modules.xml.xam.ui.column.ColumnListView;
import org.netbeans.modules.xml.xam.ui.column.ColumnProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class WSDLColumn
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider,
NodeListener,
PropertyChangeListener,
Column,
FocusListener {
    private static final long serialVersionUID = 1L;
    private WSDLColumnsView columnView;
    private ExplorerManager explorerManager;
    private transient Lookup lookup;
    private ListView nodeView;
    public static final String WSDL_COLUMN_NODE_SELECTED = "wsdl-column-node-selected";
    private JLabel noChildrenLabel;

    public WSDLColumn(WSDLColumnsView wSDLColumnsView, Node object, boolean bl) {
        this.columnView = wSDLColumnsView;
        this.explorerManager = new ExplorerManager();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        Color color = UIManager.getColor("window");
        this.setBackground(color != null ? color : Color.white);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(200, 200));
        this.nodeView = new ColumnListView(this.explorerManager);
        this.nodeView.setSelectionMode(2);
        this.nodeView.setTraversalAllowed(false);
        this.nodeView.setVerticalScrollBarPolicy(22);
        this.add((Component)this.nodeView, "Center");
        JList jList = (JList)this.nodeView.getViewport().getView();
        jList.addFocusListener(this);
        jList.setCellRenderer(new ColumnListCellRenderer());
        if (object != null) {
            if (object.getCookie(DummyDefinitionsNode.class) == null && object.getCookie(DefinitionsNode.class) != null) {
                object = new DummyDefinitionsNode((Node)object);
            }
            this.getExplorerManager().setRootContext(object);
            object.addNodeListener((NodeListener)this);
            this.noChildrenLabel = new JLabel(NbBundle.getMessage(WSDLColumn.class, (String)"LBL_NoChildren"));
            this.noChildrenLabel.setBackground(this.getBackground());
            this.noChildrenLabel.setHorizontalTextPosition(0);
            this.noChildrenLabel.setHorizontalAlignment(0);
            this.noChildrenLabel.setVisible(false);
            this.noChildrenLabel.setEnabled(false);
            if (object.getCookie(FolderNode.class) != null) {
                this.noChildrenLabel.setText(NbBundle.getMessage(WSDLColumn.class, (String)"LBL_NoCateroryChildren", (Object)object.getDisplayName()));
            }
        }
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)false));
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)actionMap);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void requestFocus() {
        super.requestFocus();
        this.nodeView.requestFocus();
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.nodeView.requestFocusInWindow();
    }

    protected TopComponent findParentTopComponent() {
        return (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        Node node = this.getExplorerManager().getRootContext();
        Column column = this.columnView.getFirstColumn();
        if (column == this && (node.getCookie(DummyDefinitionsNode.class) != null || node.getCookie(DefinitionsNode.class) != null)) {
            return NbBundle.getMessage(WSDLColumn.class, (String)"LBL_DefinitionsNode_Title");
        }
        return node.getDisplayName();
    }

    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        Node node = this.getExplorerManager().getRootContext();
        stringBuilder.append(node.getDisplayName());
        for (node = node.getParentNode(); node != null; node = node.getParentNode()) {
            stringBuilder.insert(0, '/');
            stringBuilder.insert(0, node.getDisplayName());
        }
        return stringBuilder.toString();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if ("selectedNodes".equals(string)) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray != null && nodeArray.length >= 1) {
                TopComponent topComponent = this.findParentTopComponent();
                if (topComponent != null) {
                    topComponent.setActivatedNodes(nodeArray);
                }
                this.addDetailColumn(nodeArray[0]);
                EventListener eventListener = this.getColumnView().getColumnListener();
                if (eventListener != null) {
                    this.firePropertyChange(WSDL_COLUMN_NODE_SELECTED, null, nodeArray[0]);
                }
            }
        } else if ("displayName".equals(string) && object instanceof Node) {
            this.firePropertyChange("title", null, null);
        }
    }

    protected void addDetailColumn(final Node node) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WSDLColumn wSDLColumn;
                Column column = null;
                ColumnProvider columnProvider = (ColumnProvider)node.getLookup().lookup(ColumnProvider.class);
                WSDLColumnsView wSDLColumnsView = WSDLColumn.this.getColumnView();
                if (columnProvider != null && (column = columnProvider.getColumn()) instanceof WSDLColumn && (wSDLColumn = (WSDLColumn)column).getColumnView() == null) {
                    wSDLColumn.setColumnView(wSDLColumnsView);
                }
                if (column == null && node != WSDLColumn.this.getExplorerManager().getRootContext() && node.getChildren() != Children.LEAF) {
                    column = wSDLColumnsView.createColumnComponent(node, false);
                }
                if (wSDLColumnsView.getColumnIndex(WSDLColumn.this) != -1) {
                    wSDLColumnsView.removeColumnsAfter(WSDLColumn.this);
                }
                if (column != null) {
                    wSDLColumnsView.appendColumn(column);
                }
                WSDLColumn.this.requestFocusInWindow();
            }
        });
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        Node node;
        JList jList;
        Object e;
        TopComponent topComponent = this.findParentTopComponent();
        if (topComponent != null && (e = (jList = (JList)this.nodeView.getViewport().getView()).getSelectedValue()) != null && (node = Visualizer.findNode(e)) != null) {
            topComponent.setActivatedNodes(new Node[]{node});
        }
    }

    public void addNotify() {
        super.addNotify();
        this.getColumnView().addColumnListener(this);
        Node node = this.getExplorerManager().getRootContext();
        if (node != null && node.getChildren().getNodesCount() == 0) {
            this.remove((Component)this.nodeView);
            this.noChildrenLabel.setVisible(true);
            this.add((Component)this.noChildrenLabel, "Center");
        }
    }

    public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        Node node = nodeMemberEvent.getNode();
        if (node != null && node == this.getExplorerManager().getRootContext() && this.noChildrenLabel.isVisible()) {
            this.noChildrenLabel.setVisible(false);
            this.remove(this.noChildrenLabel);
            this.add((Component)this.nodeView, "Center");
        }
    }

    public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        final Node node = nodeMemberEvent.getNode();
        if (node != null && node == this.getExplorerManager().getRootContext() && !this.noChildrenLabel.isVisible()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (node.getChildren().getNodesCount() == 0) {
                        WSDLColumn.this.noChildrenLabel.setVisible(true);
                        WSDLColumn.this.remove((Component)WSDLColumn.this.nodeView);
                        WSDLColumn.this.add((Component)WSDLColumn.this.noChildrenLabel, "Center");
                    }
                }
            });
        }
    }

    public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
    }

    public void nodeDestroyed(NodeEvent nodeEvent) {
        Node node = nodeEvent.getNode();
        if (node != null && node == this.getExplorerManager().getRootContext()) {
            final WSDLColumnsView wSDLColumnsView = this.getColumnView();
            int n = wSDLColumnsView.getColumnIndex(this);
            if (n <= 0) {
                return;
            }
            Column column = wSDLColumnsView.getFirstColumn();
            for (int i = 1; i < n; ++i) {
                column = wSDLColumnsView.getNextColumn(column);
            }
            final Column column2 = column;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    wSDLColumnsView.removeColumnsAfter(column2);
                }
            });
        }
    }

    protected WSDLColumnsView getColumnView() {
        return this.columnView;
    }

    protected void setColumnView(WSDLColumnsView wSDLColumnsView) {
        this.columnView = wSDLColumnsView;
    }
}

