/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.UIUtilities;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLModelCookie;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.NodesFactory;
import org.netbeans.modules.xml.xam.Model;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class WSDLNavigatorContent
extends JPanel
implements ExplorerManager.Provider,
Runnable,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String CURRENT_NODES = "WSDLEDITOR_CURRENT_SELECTION";
    private ExplorerManager explorerManager;
    private TreeView treeView;
    private Node rootNode;
    private final JLabel notAvailableLabel = new JLabel(NbBundle.getMessage(WSDLNavigatorContent.class, (String)"MSG_NotAvailable"));
    private WSDLNavigatorContent content;

    public WSDLNavigatorContent() {
        this.setLayout(new BorderLayout());
        this.explorerManager = new ExplorerManager();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.notAvailableLabel.setHorizontalAlignment(0);
        this.notAvailableLabel.setEnabled(false);
        Color color = UIManager.getColor("window");
        this.notAvailableLabel.setBackground(color != null ? color : Color.white);
        this.notAvailableLabel.setOpaque(true);
        this.getTreeView();
    }

    public WSDLNavigatorContent getDefault() {
        if (this.content == null) {
            this.content = new WSDLNavigatorContent();
        }
        return this.content;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void navigate(DataObject dataObject) {
        WSDLModel wSDLModel = this.getModel(dataObject);
        if (wSDLModel == null || wSDLModel.getState() != Model.State.VALID) {
            this.showError();
        } else {
            this.show(wSDLModel);
        }
        this.repaint();
    }

    private WSDLModel getModel(DataObject dataObject) {
        WSDLModel wSDLModel = null;
        try {
            WSDLModelCookie wSDLModelCookie = (WSDLModelCookie)dataObject.getCookie(WSDLModelCookie.class);
            if (wSDLModelCookie != null && (wSDLModel = (WSDLModel)wSDLModelCookie.getModel()) != null) {
                wSDLModel.removePropertyChangeListener((PropertyChangeListener)this);
                wSDLModel.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return wSDLModel;
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        if (this.treeView != null) {
            return this.treeView.requestFocusInWindow();
        }
        return bl;
    }

    public void run() {
        if (this.treeView != null && this.rootNode != null) {
            this.explorerManager.setRootContext(this.rootNode);
            this.treeView.expandNode(this.rootNode);
            Utility.expandNodes(this.treeView, 1, this.rootNode);
            this.selectActivatedNodes();
            this.validate();
            this.repaint();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TopComponent topComponent;
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if ("state".equals(string) && object instanceof WSDLModel) {
            Model.State state = (Model.State)propertyChangeEvent.getNewValue();
            if (state == Model.State.VALID) {
                WSDLModel wSDLModel = (WSDLModel)propertyChangeEvent.getSource();
                this.show(wSDLModel);
            } else {
                this.showError();
            }
            return;
        }
        if ((object instanceof TopComponent.Registry || object instanceof ExplorerManager) && (topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this)) != null) {
            boolean bl;
            boolean bl2 = bl = topComponent == TopComponent.getRegistry().getActivated();
            if (CURRENT_NODES.equals(string) && !bl) {
                this.selectActivatedNodes();
            } else if ("selectedNodes".equals(string)) {
                Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                if (nodeArray != null) {
                    topComponent.setActivatedNodes(nodeArray);
                    this.validate();
                }
            } else if ("activatedNodes".equals(string) && !bl) {
                this.selectActivatedNodes();
                this.validate();
            } else if ("activated".equals(string) && bl) {
                topComponent.setActivatedNodes(this.getExplorerManager().getSelectedNodes());
                this.validate();
            }
        }
    }

    private void selectActivatedNodes() {
        final Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (Node node : nodeArray) {
                    List<Node> list;
                    WSDLComponent wSDLComponent = (WSDLComponent)node.getLookup().lookup(WSDLComponent.class);
                    if (wSDLComponent == null || (list = UIUtilities.findPathFromRoot(WSDLNavigatorContent.this.getExplorerManager().getRootContext(), wSDLComponent)) == null || list.isEmpty()) continue;
                    arrayList.add(list.get(list.size() - 1));
                }
                WSDLNavigatorContent.this.revalidate();
                try {
                    WSDLNavigatorContent.this.getExplorerManager().setSelectedNodes(arrayList.toArray(new Node[arrayList.size()]));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                WSDLNavigatorContent.this.validate();
            }
        });
    }

    private void showError() {
        if (this.notAvailableLabel.isShowing()) {
            return;
        }
        if (this.treeView != null && this.treeView.isShowing()) {
            this.remove((Component)this.treeView);
        }
        this.add((Component)this.notAvailableLabel, "Center");
        this.validate();
        this.repaint();
    }

    private void show(WSDLModel wSDLModel) {
        this.remove(this.notAvailableLabel);
        TreeView treeView = this.getTreeView();
        this.add((Component)treeView, "Center");
        this.validate();
        NodesFactory nodesFactory = NodesFactory.getInstance();
        this.rootNode = nodesFactory.create((WSDLComponent)wSDLModel.getDefinitions());
        this.getExplorerManager().setRootContext(this.rootNode);
        SwingUtilities.invokeLater(this);
    }

    public void release() {
        Definitions definitions;
        this.removeAll();
        this.validate();
        this.getExplorerManager().setRootContext(Node.EMPTY);
        this.getExplorerManager().setExploredContext(Node.EMPTY, new Node[0]);
        if (this.rootNode != null && (definitions = (Definitions)this.rootNode.getLookup().lookup(Definitions.class)) != null && definitions.isInDocumentModel()) {
            definitions.getModel().removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.rootNode = null;
        this.treeView = null;
    }

    private TreeView getTreeView() {
        if (this.treeView == null) {
            this.treeView = new BeanTreeView();
        }
        return this.treeView;
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (WSDLNavigatorContent.this.treeView != null) {
                    WSDLNavigatorContent.this.treeView.setRootVisible(true);
                    WSDLNavigatorContent.this.explorerManager.setRootContext((Node)new WaitNode());
                }
            }
        });
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = Utilities.loadImage((String)"org/netbeans/modules/xml/text/navigator/resources/wait.gif");

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int n) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public String getDisplayName() {
            return "Please Wait...";
        }
    }
}

